/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.util;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolNameValidator {
    private static final Logger logger = LoggerFactory.getLogger(ToolNameValidator.class);
    private static final int MAX_LENGTH = 128;
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[A-Za-z0-9_\\-.]+$");
    public static final String STRICT_VALIDATION_PROPERTY = "io.modelcontextprotocol.strictToolNameValidation";

    private ToolNameValidator() {
    }

    public static boolean isStrictByDefault() {
        return !"false".equalsIgnoreCase(System.getProperty(STRICT_VALIDATION_PROPERTY));
    }

    public static void validate(String name, boolean strict) {
        if (name == null || name.isEmpty()) {
            ToolNameValidator.handleError("Tool name must not be null or empty", name, strict);
        } else if (name.length() > 128) {
            ToolNameValidator.handleError("Tool name must not exceed 128 characters", name, strict);
        } else if (!VALID_NAME_PATTERN.matcher(name).matches()) {
            ToolNameValidator.handleError("Tool name contains invalid characters (allowed: A-Z, a-z, 0-9, _, -, .)", name, strict);
        }
    }

    private static void handleError(String message, String name, boolean strict) {
        String fullMessage = message + ": '" + name + "'";
        if (strict) {
            throw new IllegalArgumentException(fullMessage);
        }
        logger.warn("{}. Processing continues, but tool name should be fixed.", (Object)fullMessage);
    }
}

