/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.util.Map;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.mcf.HealthStatus;
import redis.clients.jedis.mcf.HealthStatusManager;
import redis.clients.jedis.mcf.InitializationPolicy;
import redis.clients.jedis.mcf.MultiDbConnectionProvider;

class ConnectionInitializationContext
implements InitializationPolicy.InitializationContext {
    private int available = 0;
    private int failed = 0;
    private int pending = 0;

    public ConnectionInitializationContext(Map<Endpoint, MultiDbConnectionProvider.Database> databases, HealthStatusManager healthStatusManager) {
        for (Map.Entry<Endpoint, MultiDbConnectionProvider.Database> entry : databases.entrySet()) {
            Endpoint endpoint = entry.getKey();
            if (healthStatusManager.hasHealthCheck(endpoint)) {
                HealthStatus status = healthStatusManager.getHealthStatus(endpoint);
                if (status == HealthStatus.HEALTHY) {
                    ++this.available;
                    continue;
                }
                if (status == HealthStatus.UNHEALTHY) {
                    ++this.failed;
                    continue;
                }
                ++this.pending;
                continue;
            }
            ++this.available;
        }
    }

    @Override
    public int getAvailableConnections() {
        return this.available;
    }

    @Override
    public int getFailedConnections() {
        return this.failed;
    }

    @Override
    public int getPendingConnections() {
        return this.pending;
    }

    public InitializationPolicy.Decision conformsTo(InitializationPolicy policy) {
        return policy.evaluate(this);
    }

    public String toString() {
        return "ConnectionInitializationContext{available=" + this.available + ", failed=" + this.failed + ", pending=" + this.pending + '}';
    }
}

