/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.nat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.model.api.nat.ImmutableNatRuleDto;
import com.ubnt.model.api.nat.NatRuleFilterDto;
import com.ubnt.return.F;
import com.ubnt.service.nat.G;
import com.ubnt.service.nat.NatRuleDocument;
import com.ubnt.service.nat.String;
import com.ubnt.service.nat.return;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Schema(name="NAT Rules")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableNatRuleDto.class)
@Value.Immutable
@F
public interface NatRuleDto {
    @JsonProperty(value="_id")
    @Nullable
    public java.lang.String id();

    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="type")
    public G type();

    @JsonProperty(value="description")
    public java.lang.String description();

    @JsonProperty(value="protocol")
    public java.lang.String protocol();

    @JsonProperty(value="in_interface")
    public java.lang.String inInterface();

    @JsonProperty(value="out_interface")
    public java.lang.String outInterface();

    @JsonProperty(value="pppoe_use_base_interface")
    public boolean pppoeUseBaseInterface();

    @JsonProperty(value="ip_version")
    public String ipVersion();

    @JsonProperty(value="ip_address")
    public java.lang.String ipAddress();

    @JsonProperty(value="port")
    public java.lang.String port();

    @JsonProperty(value="source_filter")
    public NatRuleFilterDto sourceFilter();

    @JsonProperty(value="destination_filter")
    public NatRuleFilterDto destinationFilter();

    @JsonProperty(value="logging")
    public boolean logging();

    @JsonProperty(value="exclude")
    public boolean exclude();

    @JsonProperty(value="setting_preference")
    public return settingPreference();

    @JsonProperty(value="rule_index")
    @Min(value=0L)
    public @Min(value=0L) Integer ruleIndex();

    @JsonProperty(value="is_predefined")
    public boolean isPredefined();

    public static ImmutableNatRuleDto.Builder builder() {
        return ImmutableNatRuleDto.builder();
    }

    public static NatRuleDto ofDocument(NatRuleDocument natRuleDocument) {
        return NatRuleDto.builder().id(natRuleDocument.getId()).enabled(natRuleDocument.isEnabled()).type(natRuleDocument.getType()).description(natRuleDocument.getDescription()).protocol(natRuleDocument.getProtocol()).inInterface(natRuleDocument.getInNetworkConfId()).outInterface(natRuleDocument.getOutNetworkConfId()).pppoeUseBaseInterface(natRuleDocument.getPppoeUseBaseInterface()).ipAddress(natRuleDocument.getIpAddress()).ipVersion(natRuleDocument.getIpVersion()).port(natRuleDocument.getPort()).sourceFilter(NatRuleFilterDto.ofDocument(natRuleDocument.getSrcFilter())).destinationFilter(NatRuleFilterDto.ofDocument(natRuleDocument.getDstFilter())).logging(natRuleDocument.isLogging()).exclude(natRuleDocument.getExclude()).settingPreference(natRuleDocument.getSettingPreference()).ruleIndex(natRuleDocument.getRuleIndex()).isPredefined(natRuleDocument.isPredefined()).build();
    }

    default public NatRuleDocument toDocument(java.lang.String string) {
        return this.documentBuilder(string).\u00d6O0000(this.id()).o00000();
    }

    default public NatRuleDocument toDocument(java.lang.String string, java.lang.String string2) {
        return this.documentBuilder(string2).\u00d6O0000(string).o00000();
    }

    default public NatRuleDocument._o documentBuilder(java.lang.String string) {
        return NatRuleDocument.builder().\u00f800000(string).newsuper(this.enabled()).\u00d8O0000(this.type()).\u00d2O0000(this.description()).\u00d600000(this.protocol()).\u00f600000(this.inInterface()).String(this.outInterface()).private(this.pppoeUseBaseInterface()).\u00d200000(this.ipAddress()).\u00d500000(this.ipVersion()).\u00d5O0000(this.port()).null(this.sourceFilter().toDocument()).\u00d3O0000(this.destinationFilter().toDocument()).oO0000(this.logging()).\u00d300000(this.exclude()).\u00d800000(this.settingPreference()).\u00f500000(this.ruleIndex()).for(this.isPredefined());
    }
}

