/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.notification;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.service.notification.D;
import com.ubnt.service.notification.NotificationDocument;
import com.ubnt.service.notification.void;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="UI Notification")
public class NotificationDto {
    @NotEmpty
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="show_at_millis")
    private Long showAtMillis;
    @JsonProperty(value="admin_id")
    private String adminId;
    @JsonProperty(value="notified")
    private Boolean notified;
    @JsonProperty(value="site_name")
    private String siteName;
    @JsonProperty(value="site_id")
    private String siteId;
    @JsonProperty(value="show")
    private boolean show;
    @JsonProperty(value="display_option")
    private void displayOption;
    @JsonProperty(value="action_required")
    private Boolean actionRequired;
    @JsonProperty(value="global")
    private Boolean global;
    @NotNull
    @JsonProperty(value="scope")
    private D scope;

    public String getName() {
        return this.name;
    }

    public NotificationDto setName(String string) {
        this.name = StringUtils.lowerCase((String)string);
        return this;
    }

    public Long getShowAtMillis() {
        return this.showAtMillis;
    }

    public NotificationDto setShowAtMillis(Long l2) {
        this.showAtMillis = l2;
        return this;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public NotificationDto setAdminId(String string) {
        this.adminId = string;
        return this;
    }

    public Boolean isNotified() {
        return this.notified;
    }

    public NotificationDto setNotified(Boolean bl) {
        this.notified = bl;
        return this;
    }

    public Optional<String> getSiteId() {
        return Optional.ofNullable(this.siteId);
    }

    public NotificationDto setSiteId(String string) {
        this.siteId = string;
        return this;
    }

    public Optional<String> getSiteName() {
        return Optional.ofNullable(this.siteName);
    }

    public NotificationDto setSiteName(String string) {
        this.siteName = string;
        return this;
    }

    public boolean getShow() {
        return this.show;
    }

    public NotificationDto setShow(boolean bl) {
        this.show = bl;
        return this;
    }

    public D getScope() {
        return this.scope;
    }

    public NotificationDto setScope(D d2) {
        this.scope = d2;
        return this;
    }

    public Optional<void> getDisplayOption() {
        return Optional.ofNullable(this.displayOption);
    }

    public NotificationDto setDisplayOption(void void_) {
        this.displayOption = void_;
        return this;
    }

    public Boolean isActionRequired() {
        return this.actionRequired;
    }

    public NotificationDto setActionRequired(Boolean bl) {
        this.actionRequired = bl;
        return this;
    }

    public Boolean isGlobal() {
        return this.global;
    }

    public NotificationDto setGlobal(Boolean bl) {
        this.global = bl;
        return this;
    }

    public NotificationDocument._o toDocumentBuilder(String string, @Nullable String string2) {
        return NotificationDocument.builder(this.name, string, this.scope, string2).class(this.showAtMillis == null ? null : Instant.ofEpochMilli(this.showAtMillis)).\u00d400000(this.notified).super(this.displayOption);
    }

    public static NotificationDto fromDocument(NotificationDocument notificationDocument) {
        Instant instant = Instant.now();
        return new NotificationDto().setName(notificationDocument.getName()).setShowAtMillis(notificationDocument.getShowAt().toEpochMilli()).setAdminId(notificationDocument.getAdminId()).setSiteId(notificationDocument.getSiteId()).setNotified(notificationDocument.isNotified()).setScope(notificationDocument.getScope()).setShow(instant.isAfter(notificationDocument.getShowAt()) && notificationDocument.isNotified() == false).setDisplayOption(notificationDocument.getDisplayOption()).setActionRequired(notificationDocument.isActionRequired()).setGlobal(notificationDocument.isGlobal());
    }
}

