/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.firewall.policy.dto.ip.protocol.ipv4;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.ubnt.net.integration.api.firewall.policy.dto.ip.protocol.ipv4.IntegrationFirewallPolicyIpv4ProtocolFilterDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.beans.ConstructorProperties;
import lombok.Generated;

@Schema(name="Firewall policy IPv4 protocol number", description="Defines rules for matching by protocol number.")
@JsonDeserialize(builder=IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder.class)
public final class IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto
implements IntegrationFirewallPolicyIpv4ProtocolFilterDto {
    @Min(value=0L)
    @Max(value=255L)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Protocol number as defined by IANA.")
    private final @Min(value=0L) @Max(value=255L) int protocolNumber;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Match on all protocols except the specified protocol.")
    private final boolean matchOpposite;

    @ConstructorProperties(value={"protocolNumber", "matchOpposite"})
    @Generated
    IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto(int n2, boolean bl) {
        this.protocolNumber = n2;
        this.matchOpposite = bl;
    }

    @Generated
    public static IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder builder() {
        return new IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder();
    }

    @Generated
    public int getProtocolNumber() {
        return this.protocolNumber;
    }

    @Generated
    public boolean isMatchOpposite() {
        return this.matchOpposite;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto)) {
            return false;
        }
        IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto integrationFirewallPolicyIpv4ProtocolNumberFilterDto = (IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto)object;
        if (this.getProtocolNumber() != integrationFirewallPolicyIpv4ProtocolNumberFilterDto.getProtocolNumber()) {
            return false;
        }
        return this.isMatchOpposite() == integrationFirewallPolicyIpv4ProtocolNumberFilterDto.isMatchOpposite();
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        n2 = n2 * 59 + this.getProtocolNumber();
        n2 = n2 * 59 + (this.isMatchOpposite() ? 79 : 97);
        return n2;
    }

    @Generated
    public String toString() {
        return "IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto(protocolNumber=" + this.getProtocolNumber() + ", matchOpposite=" + this.isMatchOpposite() + ")";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder {
        @Generated
        private int new;
        @Generated
        private boolean o00000;

        @Generated
        IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder() {
        }

        @Generated
        public IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder protocolNumber(int n2) {
            this.new = n2;
            return this;
        }

        @Generated
        public IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder matchOpposite(boolean bl) {
            this.o00000 = bl;
            return this;
        }

        @Generated
        public IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto build() {
            return new IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto(this.new, this.o00000);
        }

        @Generated
        public String toString() {
            return "IntegrationFirewallPolicyIpv4ProtocolNumberFilterDto.IntegrationFirewallPolicyIpv4ProtocolNumberFilterDtoBuilder(protocolNumber=" + this.new + ", matchOpposite=" + this.o00000 + ")";
        }
    }
}

