/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.wifi;

import com.ubnt.ace.U;
import com.ubnt.ace.api.J;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.WlanConf;
import com.ubnt.data.X;
import com.ubnt.service.apgroup.C;
import com.ubnt.service.network.configuration.repository.B;
import com.ubnt.service.orchestration.model.TemplateConfigMetaData;
import com.ubnt.service.orchestration.model.TemplateMetaData;
import com.ubnt.service.orchestration.model.WifiTemplate;
import com.ubnt.service.orchestration.model.wifi.MdnsProxyMode;
import com.ubnt.service.orchestration.model.wifi.WifiBroadcast;
import com.ubnt.service.orchestration.model.wifi.WifiBroadcastPresharedKey;
import com.ubnt.service.orchestration.model.wifi.mdnsproxy.CustomConfiguration;
import com.ubnt.service.orchestration.template.TemplateConfigurationConstructor;
import com.ubnt.service.orchestration.template.wifi.WifiTemplateConverter;
import com.ubnt.service.wifi.return;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WifiTemplateConfigurationConstructor
implements TemplateConfigurationConstructor<WifiTemplate, WlanConf> {
    public static final List<String> NOT_REMOVABLE_CLOUD_CONFIG_FIELDS = List.of("_id", "site_id", "cloud_template", "ap_group_ids", "attr_no_edit");
    private final J amendExecutor;
    private final C defaultApGroupService;
    private final return wlanConfCrudService;
    private final B networkConfigCrudService;

    @Override
    public WlanConf construct(String string, WifiTemplate wifiTemplate) {
        WlanConf wlanConf;
        TemplateMetaData templateMetaData = wifiTemplate.getMetaData();
        WlanConf wlanConf2 = this.wlanConfCrudService.\u00d200000(string, templateMetaData.orchestrationId());
        boolean bl = this.amendExecutor.\u00d400000(string, wlanConf2, wlanConf = this.\u00f600000(string, wifiTemplate.getConfig(), wlanConf2, templateMetaData));
        return bl ? wlanConf : null;
    }

    private WlanConf \u00f600000(String string, WifiBroadcast wifiBroadcast, @Nullable WlanConf wlanConf, TemplateMetaData templateMetaData) {
        if (wlanConf == null) {
            return this.\u00d4O0000(string, wifiBroadcast, templateMetaData);
        }
        String string2 = this.\u00d6O0000(string, wifiBroadcast);
        Map<Integer, String> map = this.\u00d2O0000(string, wifiBroadcast);
        Map<Integer, String> map2 = this.OO0000(string, wifiBroadcast);
        WlanConf wlanConf2 = WifiTemplateConverter.toWlanConf(wifiBroadcast, map, map2, string2);
        WlanConf wlanConf3 = new WlanConf();
        wlanConf3.copyAttrsIfPresent((X)wlanConf, NOT_REMOVABLE_CLOUD_CONFIG_FIELDS);
        wlanConf3.mergeFrom(wlanConf2);
        wlanConf3.setCloudTemplateId(templateMetaData.templateId());
        wlanConf3.setCloudTemplateRevisionId(templateMetaData.revisionId());
        return wlanConf3;
    }

    private WlanConf \u00d4O0000(String string, WifiBroadcast wifiBroadcast, TemplateMetaData templateMetaData) {
        String string2 = this.\u00d6O0000(string, wifiBroadcast);
        Map<Integer, String> map = this.\u00d2O0000(string, wifiBroadcast);
        Map<Integer, String> map2 = this.OO0000(string, wifiBroadcast);
        WlanConf wlanConf = WifiTemplateConverter.toWlanConf(wifiBroadcast, map, map2, string2).setSiteId(string).setApGroupIds(List.of(this.defaultApGroupService.\u00d300000(string).getId()));
        wlanConf.setNotEditable(true);
        wlanConf.setCloudTemplate(TemplateConfigMetaData.builder().organizationId(templateMetaData.organizationId()).orchestrationId(templateMetaData.orchestrationId()).templateId(templateMetaData.templateId()).revisionId(templateMetaData.revisionId()).configId(wifiBroadcast.id()).build());
        return wlanConf;
    }

    private Map<Integer, String> OO0000(String string, WifiBroadcast wifiBroadcast) {
        if (this.\u00f4O0000(wifiBroadcast)) {
            List<Integer> list = wifiBroadcast.mdnsProxyCustomConfigurations().stream().filter(this::oO0000).flatMap(customConfiguration -> customConfiguration.vlanIds().stream()).toList();
            return this.public(string, list);
        }
        return Map.of();
    }

    private boolean \u00f4O0000(WifiBroadcast wifiBroadcast) {
        return MdnsProxyMode.CUSTOM == wifiBroadcast.mdnsProxyMode() && !Objects.requireNonNullElse(wifiBroadcast.mdnsProxyCustomConfigurations(), List.of()).isEmpty();
    }

    private boolean oO0000(CustomConfiguration customConfiguration) {
        return !Objects.requireNonNullElse(customConfiguration.vlanIds(), List.of()).isEmpty();
    }

    private Map<Integer, String> public(String string, List<Integer> list) {
        return list.stream().collect(Collectors.toMap(UnaryOperator.identity(), n2 -> this.networkConfigCrudService.thissuper(string, (int)n2).map(NetworkConf::getId).orElse(""), U.\u00f4O0000()));
    }

    private Map<Integer, String> \u00d2O0000(String string, WifiBroadcast wifiBroadcast) {
        if (this.supersuper(wifiBroadcast)) {
            List<Integer> list = wifiBroadcast.privatePresharedKeys().stream().map(WifiBroadcastPresharedKey::vlanId).filter(Objects::nonNull).toList();
            return this.public(string, list);
        }
        return Map.of();
    }

    private boolean supersuper(WifiBroadcast wifiBroadcast) {
        return wifiBroadcast.privatePresharedKeysEnabled() && wifiBroadcast.privatePresharedKeys() != null;
    }

    private String \u00d6O0000(String string, WifiBroadcast wifiBroadcast) {
        Integer n2 = wifiBroadcast.basedNetworkVlanId();
        if (n2 != null) {
            return this.public(string, List.of(n2)).get(n2);
        }
        return null;
    }

    @ConstructorProperties(value={"amendExecutor", "defaultApGroupService", "wlanConfCrudService", "networkConfigCrudService"})
    @Generated
    public WifiTemplateConfigurationConstructor(J j2, C c2, return return_, B b2) {
        this.amendExecutor = j2;
        this.defaultApGroupService = c2;
        this.wlanConfCrudService = return_;
        this.networkConfigCrudService = b2;
    }
}

