/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap;

import com.axlradius.radclient4.auth.eap.EAPPacket;

public class EAPType {
    private int Q = 0;
    private int type = 0;
    private int hashCode;

    public EAPType(EAPType eAPType) {
        this.type = eAPType.getType();
        this.Q = eAPType.getVendorId();
    }

    public EAPType(int n2, int n3) {
        this.type = n3;
        this.Q = n2;
    }

    public EAPType(int n2) {
        this.type = n2;
        this.Q = 0;
    }

    public int getType() {
        return this.type;
    }

    public int getVendorId() {
        return this.Q;
    }

    public boolean isVendor() {
        return this.Q != 0;
    }

    public boolean isIETF() {
        return this.Q == 0;
    }

    public boolean isControl() {
        return this.isIETF() && this.type < 4;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.type << 24 | this.Q & 0xFFFFFF;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object.hashCode() == this.hashCode()) {
            return ((EAPType)(object = (EAPType)object)).getVendorId() == this.getVendorId() && ((EAPType)object).getType() == this.getType();
        }
        return false;
    }

    public String toString() {
        if (this.Q == 0) {
            return EAPPacket.getTypeName(this.type);
        }
        return this.Q + ":" + this.type;
    }

    public static enum TYPE {
        AKA(23),
        AKAPrime(50),
        GTC(6),
        EXPANDED(254),
        EXPANDED_NAK(254),
        EXPERIMENTAL(255),
        IDENTITY(1),
        LEAP(17),
        MD5(4),
        MSCHAPV2(26),
        NAK(3),
        MS_AUTHENTICATION_TLV(33),
        NOTIFICATION(2),
        OTP(5),
        PEAP(25),
        PEAPV1(25),
        PEAPV2(25),
        SIM(18),
        TLS(13),
        PSK(47),
        TTLS(21),
        IKEv2(49),
        FAST(43),
        UNDEFINED(0);

        private final EAPType c;

        private TYPE(int n3) {
            this.c = new EAPType(n3);
        }

        public final EAPType getType() {
            return this.c;
        }

        public final String toString() {
            return "EAP-" + this.name();
        }
    }
}

