/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.internal.util.RunnablesAction;
import io.jenetics.internal.util.RunnablesRunnable;
import io.jenetics.util.Seq;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public abstract class Concurrency
implements Executor,
AutoCloseable {
    public static final int CORES = Runtime.getRuntime().availableProcessors();
    public static final Concurrency SERIAL_EXECUTOR = new SerialConcurrency();

    public abstract void execute(Seq<? extends Runnable> var1);

    @Override
    public abstract void close();

    public Executor getInnerExecutor() {
        return this;
    }

    public static Concurrency with(Executor executor) {
        if (executor instanceof ForkJoinPool) {
            return new ForkJoinPoolConcurrency((ForkJoinPool)executor);
        }
        if (executor instanceof ExecutorService) {
            return new ExecutorServiceConcurrency((ExecutorService)executor);
        }
        if (executor == SERIAL_EXECUTOR) {
            return SERIAL_EXECUTOR;
        }
        return new ExecutorConcurrency(executor);
    }

    public static Concurrency withCommonPool() {
        return Concurrency.with(ForkJoinPool.commonPool());
    }

    private static int[] partition(int size, int parts) {
        int i;
        if (size < 1) {
            throw new IllegalArgumentException("Size must greater than zero: " + size);
        }
        if (parts < 1) {
            throw new IllegalArgumentException("Number of partitions must greater than zero: " + parts);
        }
        int pts = Math.min(size, parts);
        int[] partition = new int[pts + 1];
        int bulk = size / pts;
        int rest = size % pts;
        assert (bulk * pts + rest == size);
        int n = pts - rest;
        for (i = 0; i < n; ++i) {
            partition[i] = i * bulk;
        }
        n = rest + 1;
        for (i = 0; i < n; ++i) {
            partition[pts - rest + i] = (pts - rest) * bulk + i * (bulk + 1);
        }
        return partition;
    }

    private static final class Env {
        private static final int maxBatchSize = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("io.jenetics.concurrency.maxBatchSize", Integer.MAX_VALUE)), 1);

        private Env() {
        }
    }

    private static final class SerialConcurrency
    extends Concurrency {
        private SerialConcurrency() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void execute(Seq<? extends Runnable> runnables) {
            runnables.forEach(Runnable::run);
        }

        @Override
        public void close() {
        }
    }

    private static final class ExecutorConcurrency
    extends Concurrency {
        private final List<FutureTask<?>> _tasks = new ArrayList();
        private final Executor _executor;

        ExecutorConcurrency(Executor executor) {
            this._executor = Objects.requireNonNull(executor);
        }

        @Override
        public void execute(Runnable command) {
            FutureTask<Object> task = new FutureTask<Object>(command, null);
            this._tasks.add(task);
            this._executor.execute(task);
        }

        @Override
        public void execute(Seq<? extends Runnable> runnables) {
            if (runnables.nonEmpty()) {
                int[] parts = Concurrency.partition(runnables.size(), Math.max((ExecutorConcurrency.CORES + 1) * 2, (int)Math.ceil((double)runnables.size() / (double)Env.maxBatchSize)));
                for (int i = 0; i < parts.length - 1; ++i) {
                    this.execute(new RunnablesRunnable(runnables, parts[i], parts[i + 1]));
                }
            }
        }

        @Override
        public void close() {
            try {
                for (FutureTask<?> t : this._tasks) {
                    t.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                String msg = e.getMessage();
                throw (CancellationException)new CancellationException(msg).initCause(e);
            }
        }
    }

    private static final class ExecutorServiceConcurrency
    extends Concurrency {
        private final List<Future<?>> _futures = new ArrayList();
        private final ExecutorService _service;

        ExecutorServiceConcurrency(ExecutorService service) {
            this._service = Objects.requireNonNull(service);
        }

        @Override
        public void execute(Runnable command) {
            this._futures.add(this._service.submit(command));
        }

        @Override
        public void execute(Seq<? extends Runnable> runnables) {
            if (runnables.nonEmpty()) {
                int[] parts = Concurrency.partition(runnables.size(), Math.max((ExecutorServiceConcurrency.CORES + 1) * 2, (int)Math.ceil((double)runnables.size() / (double)Env.maxBatchSize)));
                for (int i = 0; i < parts.length - 1; ++i) {
                    this.execute(new RunnablesRunnable(runnables, parts[i], parts[i + 1]));
                }
            }
        }

        @Override
        public Executor getInnerExecutor() {
            return this._service;
        }

        @Override
        public void close() {
            try {
                for (Future<?> f : this._futures) {
                    f.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                String msg = e.getMessage();
                throw (CancellationException)new CancellationException(msg).initCause(e);
            }
        }
    }

    private static final class ForkJoinPoolConcurrency
    extends Concurrency {
        private final List<ForkJoinTask<?>> _tasks = new ArrayList();
        private final ForkJoinPool _pool;

        ForkJoinPoolConcurrency(ForkJoinPool pool) {
            this._pool = Objects.requireNonNull(pool);
        }

        @Override
        public void execute(Runnable runnable) {
            this._tasks.add((ForkJoinTask<?>)this._pool.submit(runnable));
        }

        @Override
        public void execute(Seq<? extends Runnable> runnables) {
            if (runnables.nonEmpty()) {
                this._tasks.add(this._pool.submit(new RunnablesAction(runnables)));
            }
        }

        @Override
        public Executor getInnerExecutor() {
            return this._pool;
        }

        @Override
        public void close() {
            this._tasks.forEach(ForkJoinTask::join);
        }
    }
}

