/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.VarMapHolder;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.collections.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.collections.SFormsFastMapDirect;

public abstract class SFormsConstructor {
    @Deprecated(forRemoval=true)
    public final boolean trackFieldVars;
    @Deprecated(forRemoval=true)
    public final boolean trackDirectAssignments;
    private final HashMap<String, SFormsFastMapDirect> inVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> outVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> outNegVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> extraVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> catchableVersions = new HashMap();
    private final HashMap<Integer, Integer> lastversion = new HashMap();
    FastSparseSetFactory<Integer> factory;
    private SFormsFastMapDirect currentCatchableMap = null;
    protected RootStatement root;
    private StructMethod mt;
    DirectGraph dgraph;

    public SFormsConstructor(boolean trackFieldVars, boolean trackDirectAssignments) {
        this.trackFieldVars = trackFieldVars;
        this.trackDirectAssignments = trackDirectAssignments;
    }

    public void splitVariables(RootStatement root, StructMethod mt) {
        DirectGraph dgraph;
        this.root = root;
        this.mt = mt;
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        this.dgraph = dgraph = flatthelper.buildDirectGraph(root);
        ValidationHelper.validateDGraph(dgraph, root);
        ValidationHelper.validateVars(dgraph, root, var -> var.getVersion() == 0, "Var version is not zero");
        DotExporter.toDotFile(dgraph, mt, "ssaSplitVariables");
        ArrayList<Integer> setInit = new ArrayList<Integer>();
        for (int i = 0; i < 64; ++i) {
            setInit.add(i);
        }
        this.factory = new FastSparseSetFactory(setInit);
        this.extraVarVersions.put(dgraph.first.id, this.createFirstMap());
        this.setCatchMaps(root, dgraph, flatthelper);
        int iteration = 1;
        HashSet<String> updated = new HashSet<String>();
        do {
            this.ssaStatements(dgraph, updated, false, mt, iteration++);
        } while (!updated.isEmpty());
    }

    void ssaStatements(DirectGraph dgraph, Set<String> updated, boolean calcLiveVars, StructMethod mt, int iteration) {
        DotExporter.toDotFile(dgraph, mt, "ssaStatements_" + iteration, this.outVarVersions);
        for (DirectNode node : dgraph.nodes) {
            updated.remove(node.id);
            this.mergeInVarMaps(node, dgraph);
            SFormsFastMapDirect varmap = this.inVarVersions.get(node.id);
            VarMapHolder varmaps = VarMapHolder.ofNormal(varmap);
            this.currentCatchableMap = null;
            if (node.hasSuccessors(DirectEdgeType.EXCEPTION)) {
                this.currentCatchableMap = varmap.getCopy();
                this.currentCatchableMap.removeAllStacks();
                this.currentCatchableMap.removeAllFields();
                this.catchableVersions.put(node.id, this.currentCatchableMap);
            }
            if (node.type == DirectNodeType.FOREACH_VARDEF && node.exprents.get(0) instanceof VarExprent) {
                this.updateVarExprent((VarExprent)node.exprents.get(0), node.statement, varmaps.getNormal(), calcLiveVars);
            } else if (node.exprents != null) {
                for (Exprent expr : node.exprents) {
                    varmaps.toNormal();
                    expr.processSforms(this, varmaps, node.statement, calcLiveVars);
                }
            }
            if (!this.hasUpdated(node, varmaps)) continue;
            this.outVarVersions.put(node.id, varmaps.getIfTrue());
            if (dgraph.mapNegIfBranch.containsKey(node.id)) {
                this.outNegVarVersions.put(node.id, varmaps.getIfFalse());
            }
            if (dgraph.extraNodes.contains(node)) continue;
            for (DirectEdge nd : node.getSuccessors(DirectEdgeType.REGULAR)) {
                updated.add(nd.getDestination().id);
            }
            for (DirectEdge nd : node.getSuccessors(DirectEdgeType.EXCEPTION)) {
                updated.add(nd.getDestination().id);
            }
        }
    }

    public abstract VarVersionPair getOrCreatePhantom(VarVersionPair var1);

    public void varRead(VarMapHolder varMaps, Statement stat, boolean calcLiveVars, VarExprent varExprent) {
        SFormsFastMapDirect varmap = varMaps.getNormal();
        FastSparseSetFactory.FastSparseSet<Integer> versions = varmap.get(varExprent);
        int cardinality = versions != null ? versions.getCardinality() : 0;
        switch (cardinality) {
            case 0: {
                this.updateVarExprent(varExprent, stat, varmap, calcLiveVars);
                ValidationHelper.validateTrue(false, "Variable read before assignment: " + String.valueOf(varExprent));
                break;
            }
            case 1: {
                this.varReadSingleVersion(stat, calcLiveVars, varExprent, varmap, versions.iterator().next());
                break;
            }
            case 2: {
                this.varReadMultipleVersions(stat, calcLiveVars, varExprent, varmap, versions);
            }
        }
    }

    abstract void varReadSingleVersion(Statement var1, boolean var2, VarExprent var3, SFormsFastMapDirect var4, int var5);

    abstract void varReadMultipleVersions(Statement var1, boolean var2, VarExprent var3, SFormsFastMapDirect var4, FastSparseSetFactory.FastSparseSet<Integer> var5);

    public abstract void markDirectAssignment(VarVersionPair var1, VarVersionPair var2);

    private static boolean makesFieldsDirty(Exprent expr) {
        switch (expr.type) {
            case INVOCATION: {
                return true;
            }
            case NEW: {
                if (((NewExprent)expr).getNewType().type != CodeType.OBJECT) break;
                return true;
            }
        }
        return false;
    }

    abstract void initVersion(VarExprent var1, Statement var2);

    public void updateVarExprent(VarExprent varassign, Statement stat, SFormsFastMapDirect varmap, boolean calcLiveVars) {
        int varIndex = varassign.getIndex();
        this.initVersion(varassign, stat);
        this.onAssignment(varassign.getVarVersionPair(), varmap, calcLiveVars);
        this.setCurrentVar(varmap, varIndex, varassign.getVersion());
        if (this.currentCatchableMap != null && varIndex < 10000 && varIndex >= 0) {
            if (this.currentCatchableMap.containsKey(varIndex)) {
                this.currentCatchableMap.get(varIndex).add(varassign.getVersion());
            } else {
                FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.createEmptySet();
                set.add(varassign.getVersion());
                varmap.put(varIndex, set);
            }
        }
    }

    protected void onAssignment(VarVersionPair varVersionPair, SFormsFastMapDirect varMap, boolean calcLiveVars) {
    }

    private void mergeInVarMaps(DirectNode node, DirectGraph dgraph) {
        SFormsFastMapDirect mapOut;
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect(this.factory);
        for (DirectEdge pred : node.getPredecessors(DirectEdgeType.REGULAR)) {
            mapOut = this.getFilteredOutMap(node, pred.getSource(), dgraph);
            if (mapNew.isEmpty()) {
                mapNew = mapOut.getCopy();
                continue;
            }
            VarMapHolder.mergeMaps(mapNew, mapOut);
        }
        for (DirectEdge pred : node.getPredecessors(DirectEdgeType.EXCEPTION)) {
            mapOut = this.catchableVersions.get(pred.getSource().id);
            if (mapOut == null) continue;
            if (mapNew.isEmpty()) {
                mapNew = mapOut.getCopy();
                continue;
            }
            VarMapHolder.mergeMaps(mapNew, mapOut);
        }
        if (this.extraVarVersions.containsKey(node.id)) {
            SFormsFastMapDirect mapExtra = this.extraVarVersions.get(node.id);
            if (mapNew.isEmpty()) {
                mapNew = mapExtra.getCopy();
            } else {
                VarMapHolder.mergeMaps(mapNew, mapExtra);
            }
        }
        this.inVarVersions.put(node.id, mapNew);
    }

    private SFormsFastMapDirect getFilteredOutMap(DirectNode node, DirectNode pred, DirectGraph dgraph) {
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect(this.factory);
        if (node.id.equals(dgraph.mapNegIfBranch.get(pred.id))) {
            if (this.outNegVarVersions.containsKey(pred.id)) {
                mapNew = this.outNegVarVersions.get(pred.id).getCopy();
            }
        } else if (this.outVarVersions.containsKey(pred.id)) {
            mapNew = this.outVarVersions.get(pred.id).getCopy();
        }
        if (node.tryFinally != pred.tryFinally && (node.tryFinally == null || node.tryFinally.type != DirectNodeType.FINALLY || node.tryFinally.tryFinally != pred.tryFinally) && pred.type != DirectNodeType.FINALLY) {
            DirectNode finallyNode = pred.tryFinally;
            while (finallyNode != node.tryFinally) {
                ValidationHelper.notNull(finallyNode);
                if (finallyNode.type == DirectNodeType.FINALLY) {
                    SFormsConstructor.getAndApplyDiff(this.inVarVersions.get(finallyNode.statement.id + "_FINALLY"), this.outVarVersions.get(finallyNode.id), mapNew);
                }
                finallyNode = finallyNode.tryFinally;
            }
        }
        return mapNew;
    }

    private static void getAndApplyDiff(SFormsFastMapDirect input, SFormsFastMapDirect output, SFormsFastMapDirect target) {
        Integer key;
        if (input == null || output == null) {
            return;
        }
        for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> entry : input.entryList()) {
            key = entry.getKey();
            if (key >= 10000 || entry.getValue().isEmpty()) continue;
            Integer first = entry.getValue().iterator().next();
            if (!output.containsKey(key)) continue;
            if (output.get(key).contains(first)) {
                FastSparseSetFactory.FastSparseSet<Integer> check = output.get(key).getCopy();
                check.complement(entry.getValue());
                if (check.isEmpty()) continue;
                target.get(key).union(check);
                continue;
            }
            target.put(key, entry.getValue().getCopy());
        }
        for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> entry : output.entryList()) {
            key = entry.getKey();
            if (key >= 10000 || entry.getValue().isEmpty() || input.containsKey(key) && !input.get(key).isEmpty()) continue;
            target.put(key, entry.getValue().getCopy());
        }
    }

    public static Statement getFirstProtectedRange(Statement stat) {
        Statement parent;
        while ((parent = stat.getParent()) != null) {
            if (parent instanceof CatchAllStatement || parent instanceof CatchStatement ? parent.getFirst() == stat : parent instanceof SynchronizedStatement && ((SynchronizedStatement)parent).getBody() == stat) {
                return parent;
            }
            stat = parent;
        }
        return null;
    }

    private void setCatchMaps(Statement stat, DirectGraph dgraph, FlattenStatementsHelper flatthelper) {
        switch (stat.type) {
            case CATCH_ALL: 
            case TRY_CATCH: {
                List<VarExprent> lstVars = stat instanceof CatchAllStatement ? ((CatchAllStatement)stat).getVars() : ((CatchStatement)stat).getVars();
                for (int i = 1; i < stat.getStats().size(); ++i) {
                    int varindex = lstVars.get(i - 1).getIndex();
                    SFormsFastMapDirect map = new SFormsFastMapDirect(this.factory);
                    this.initParameter(varindex, map, true);
                    this.extraVarVersions.put(flatthelper.getDirectNode((Statement)((Statement)stat.getStats().get((int)i))).id, map);
                }
                break;
            }
        }
        for (Statement st : stat.getStats()) {
            this.setCatchMaps(st, dgraph, flatthelper);
        }
    }

    private SFormsFastMapDirect createFirstMap() {
        boolean hasThis = !this.mt.hasModifier(8);
        MethodDescriptor md = MethodDescriptor.parseDescriptor(this.mt.getDescriptor());
        int paramCount = md.params.length + (hasThis ? 1 : 0);
        SFormsFastMapDirect varMap = new SFormsFastMapDirect(this.factory);
        int varIndex = 0;
        for (int i = 0; i < paramCount; ++i) {
            this.initParameter(varIndex, varMap, false);
            if (hasThis) {
                if (i == 0) {
                    ++varIndex;
                    continue;
                }
                varIndex += md.params[i - 1].stackSize;
                continue;
            }
            varIndex += md.params[i].stackSize;
        }
        return varMap;
    }

    public abstract void initParameter(int var1, SFormsFastMapDirect var2, boolean var3);

    public static void makeReadEdge(VarVersionNode phiNode, VarVersionNode tempNode) {
        tempNode.successors.add(phiNode);
        phiNode.predecessors.add(tempNode);
    }

    static boolean mapsEqual(SFormsFastMapDirect map1, SFormsFastMapDirect map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> ent2 : map2.entryList()) {
            if (InterpreterUtil.equalObjects(map1.get(ent2.getKey()), ent2.getValue())) continue;
            return false;
        }
        return true;
    }

    public void fieldRead(FieldExprent field, SFormsFastMapDirect varmap) {
        if (this.trackFieldVars) {
            int index = this.getFieldIndex(field);
            varmap.setCurrentVar(index, 1);
        }
    }

    @Deprecated
    void setCurrentVar(SFormsFastMapDirect varmap, int var, int vers) {
        FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.createEmptySet();
        set.add(vers);
        varmap.put(var, set);
    }

    boolean hasUpdated(DirectNode node, VarMapHolder varmaps) {
        return !SFormsConstructor.mapsEqual(varmaps.getIfTrue(), this.outVarVersions.get(node.id)) || this.outNegVarVersions.containsKey(node.id) && !SFormsConstructor.mapsEqual(varmaps.getIfFalse(), this.outNegVarVersions.get(node.id));
    }

    public abstract Integer getFieldIndex(FieldExprent var1);

    protected int getNextFreeVersion(int var, Statement stat) {
        return this.lastversion.compute(var, (k, v) -> v == null ? 1 : v + 1);
    }

    public DirectGraph getDirectGraph() {
        return this.dgraph;
    }
}

