/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;

public class FailOnVersionConflictGraphVisitor
implements DependencyGraphVisitor {
    private final Set<Conflict> allConflicts = new LinkedHashSet<Conflict>();

    @Override
    public void visitNode(DependencyGraphNode node) {
        DependencyGraphComponent owner = node.getOwner();
        ComponentSelectionReason selectionReason = owner.getSelectionReason();
        if (selectionReason.isConflictResolution()) {
            this.allConflicts.add(FailOnVersionConflictGraphVisitor.buildConflict(owner, selectionReason));
        }
    }

    private static Conflict buildConflict(DependencyGraphComponent owner, ComponentSelectionReason selectionReason) {
        ModuleIdentifier module = owner.getModuleVersion().getModule();
        return new Conflict((List<? extends ModuleVersionIdentifier>)ImmutableList.copyOf(owner.getAllVersions()), FailOnVersionConflictGraphVisitor.buildConflictMessage(module, selectionReason));
    }

    private static String buildConflictMessage(ModuleIdentifier owner, ComponentSelectionReason selectionReason) {
        String conflictDescription = null;
        for (ComponentSelectionDescriptor description : selectionReason.getDescriptions()) {
            if (!description.getCause().equals((Object)ComponentSelectionCause.CONFLICT_RESOLUTION)) continue;
            conflictDescription = description.getDescription();
        }
        assert (conflictDescription != null);
        return owner.getGroup() + ":" + owner.getName() + " " + conflictDescription;
    }

    public Set<Conflict> getAllConflicts() {
        return this.allConflicts;
    }
}

