/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar.misplaced;

import com.eed3si9n.jarjar.misplaced.FatalMisplacedClassProcessor;
import com.eed3si9n.jarjar.misplaced.MisplacedClassProcessor;
import com.eed3si9n.jarjar.misplaced.MoveMisplacedClassProcessor;
import com.eed3si9n.jarjar.misplaced.OmitMisplacedClassProcessor;
import com.eed3si9n.jarjar.misplaced.SkipMisplacedClassProcessor;

public class MisplacedClassProcessorFactory {
    private static MisplacedClassProcessorFactory me;

    public static synchronized MisplacedClassProcessorFactory getInstance() {
        if (me == null) {
            me = new MisplacedClassProcessorFactory();
        }
        return me;
    }

    private MisplacedClassProcessorFactory() {
    }

    public MisplacedClassProcessor getDefaultProcessor() {
        return new OmitMisplacedClassProcessor();
    }

    public MisplacedClassProcessor getProcessorForName(String string) {
        if (string == null) {
            return this.getDefaultProcessor();
        }
        switch (Strategy.valueOf(string.toUpperCase())) {
            case FATAL: {
                return new FatalMisplacedClassProcessor();
            }
            case MOVE: {
                return new MoveMisplacedClassProcessor();
            }
            case OMIT: {
                return new OmitMisplacedClassProcessor();
            }
            case SKIP: {
                return new SkipMisplacedClassProcessor();
            }
        }
        throw new IllegalArgumentException("Unrecognized strategy name \"" + string + "\".");
    }

    public static enum Strategy {
        FATAL,
        SKIP,
        OMIT,
        MOVE;

    }
}

