/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import coursierapi.shaded.commonscompress.utils.ByteUtils;
import java.io.Serializable;

public final class ZipShort
implements Serializable,
Cloneable {
    public static final ZipShort ZERO = new ZipShort(0);
    private final int value;

    public static byte[] getBytes(int value) {
        byte[] result2 = new byte[2];
        ZipShort.putShort(value, result2, 0);
        return result2;
    }

    public static int getValue(byte[] bytes) {
        return ZipShort.getValue(bytes, 0);
    }

    public static int getValue(byte[] bytes, int offset) {
        return (int)ByteUtils.fromLittleEndian(bytes, offset, 2);
    }

    public static void putShort(int value, byte[] buf, int offset) {
        ByteUtils.toLittleEndian(buf, value, offset, 2);
    }

    public ZipShort(byte[] bytes, int offset) {
        this.value = ZipShort.getValue(bytes, offset);
    }

    public ZipShort(int value) {
        this.value = value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnfe) {
            throw new UnsupportedOperationException(cnfe);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)o).getValue();
    }

    public byte[] getBytes() {
        byte[] result2 = new byte[2];
        ByteUtils.toLittleEndian(result2, this.value, 0, 2);
        return result2;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return "ZipShort value: " + this.value;
    }
}

