/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CommandLineExecutor.class);

    public void execute(CommandLine cmd, @Nullable File workingDirectory, int timeout) throws InterruptedException, IOException {
        LOG.info("executing command {}", (Object)cmd.toString());
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)timeout);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWatchdog(watchdog);
        if (workingDirectory != null) {
            executor.setWorkingDirectory(workingDirectory);
        }
        LOG.debug("workdir: {}", (Object)executor.getWorkingDirectory());
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)out, (OutputStream)err));
        executor.execute(cmd, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor();
        int exitCode = resultHandler.getExitValue();
        if (out.size() > 0) {
            LOG.info(out.toString());
        }
        if (exitCode != 0) {
            String msg = executor.getWatchdog().killedProcess() ? "Command took too long to execute, try setting a higher timout: '" + cmd + "'" : (err.size() == 0 ? "Command didn't succeed: '" + cmd + "'" : err.toString());
            throw new IOException(msg);
        }
    }
}

