/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import jlibs.core.io.FileUtil;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.net.URLUtil;

public class ClassUtil {
    private static final HashMap<Class, Class> PRIMITIVES = new HashMap();
    private static final HashMap<Class, Class> PRIMITIVE_WRAPPERS;

    public static String getClassPath(Class clazz) {
        String relativePath;
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            return URLUtil.toSystemID(codeSource.getLocation());
        }
        URL url = clazz.getResource(clazz.getSimpleName() + ".class");
        if ("jar".equals(url.getProtocol())) {
            String path = url.getPath();
            try {
                return URLUtil.toSystemID(new URL(path.substring(0, path.lastIndexOf(33))));
            }
            catch (MalformedURLException ex) {
                throw new ImpossibleException("as per JAR URL Syntax this should never happen", ex);
            }
        }
        String resource = URLUtil.toSystemID(url);
        if (resource.endsWith(relativePath = "/" + clazz.getName().replace(".", FileUtil.SEPARATOR) + ".class")) {
            resource = resource.substring(0, resource.length() - relativePath.length());
        }
        return resource;
    }

    public static ClassLoader getClassLoader(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    public static Class unbox(Class clazz) {
        Class unboxedClass = PRIMITIVES.get(clazz);
        return unboxedClass == null ? clazz : unboxedClass;
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return PRIMITIVES.containsKey(clazz);
    }

    public static Class box(Class clazz) {
        Class boxedClass = PRIMITIVE_WRAPPERS.get(clazz);
        return boxedClass == null ? clazz : boxedClass;
    }

    public static Class getPrimitiveType(String className) {
        if (className.equals("void")) {
            return Void.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public static Class getClassingClass(int offset) {
        Class[] context = ClassContext.INSTANCE.getClassContext();
        return context.length > (offset += 2) ? context[offset] : null;
    }

    public static Class getClassingClass() {
        return ClassUtil.getClassingClass(1);
    }

    public static ClassLoader getClassingClassLoader() {
        Class caller = ClassUtil.getClassingClass(1);
        return caller == null ? ClassLoader.getSystemClassLoader() : ClassUtil.getClassLoader(caller);
    }

    static {
        PRIMITIVES.put(Void.class, Void.TYPE);
        PRIMITIVES.put(Boolean.class, Boolean.TYPE);
        PRIMITIVES.put(Character.class, Character.TYPE);
        PRIMITIVES.put(Byte.class, Byte.TYPE);
        PRIMITIVES.put(Short.class, Short.TYPE);
        PRIMITIVES.put(Integer.class, Integer.TYPE);
        PRIMITIVES.put(Long.class, Long.TYPE);
        PRIMITIVES.put(Float.class, Float.TYPE);
        PRIMITIVES.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPERS = new HashMap();
        PRIMITIVE_WRAPPERS.put(Void.TYPE, Void.TYPE);
        PRIMITIVE_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPERS.put(Double.TYPE, Double.class);
    }

    private static class ClassContext
    extends SecurityManager {
        public static final ClassContext INSTANCE = new ClassContext();

        private ClassContext() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

