############################################
###         CPANPLUS::Config.pm          ###
###  Configuration structure for CPAN++  ###
############################################

#last changed: Thu Dec  4 10:12:13 2003 GMT

package CPANPLUS::Config;

$VERSION = 0.047;

use strict;

sub new {
    my $class = shift;

    my $conf = {
                 '_source' => {
                                'hosts' => 'MIRRORED.BY',
                                'smod' => 'packages',
                                'sauth' => 'mailrc',
                                'dslip' => '03modlist.data.gz',
                                'sdslip' => 'dslip',
                                'auth' => '01mailrc.txt.gz',
                                'update' => '86400',
                                'mod' => '02packages.details.txt.gz'
                              },
                 '_build' => {
                               'tar' => 'i:/UTILS/tar.exe',
                               'unzip' => 'i:/UTILS/unzip.exe',
                               'autdir' => 'authors/',
                               'ftp' => 'd:/tcpip/bin/ftp.exe',
                               'rsync' => 'i:/emx.add/BIN/rsync.exe',
                               'curl' => '',
                               'lynx' => 'i:/emx.add/BIN/lynx.exe',
                               'shell' => 'i:/BIN/ksh.exe',
                               'ncftp' => 'i:/UTILS/ncftp.exe',
                               'gzip' => 'i:/UTILS/gzip.exe',
                               'ncftpget' => '',
                               'base' => 'J:/home/.cpanplus',
                               'moddir' => 'build/',
                               'distdir' => 'dist/',
                               'startdir' => '',
                               'make' => 'i:/emx.add/BIN/make.exe',
                               'targetdir' => '',
                               'perl' => '',
                               'wget' => '',
                               'sudo' => '',
                               'pager' => 'i:/UTILS/less.exe',
                               'autobundle' => 'autobundle/',
                               'autobundle_prefix' => 'Snapshot'
                             },
                 '_ftp' => {
                             'auth' => 'authors/01mailrc.txt.gz',
                             'base' => 'authors/id/',
                             'email' => 'cpanplus@example.com',
                             'passive' => 1,
                             'dslip' => 'modules/03modlist.data.gz',
                             'urilist' => [
                                            {
                                              'scheme' => 'ftp',
                                              'path' => '/pub/CPAN',
                                              'host' => 'mirrors.kernel.org'
                                            },
                                            {
                                              'scheme' => 'ftp',
                                              'path' => '/pub/CPAN',
                                              'host' => 'mirrors.kernel.org'
                                            }
                                          ],
                             'mod' => 'modules/02packages.details.txt.gz'
                           },
                 'conf' => {
                             'verbose' => 0,
                             'storable' => 1,
                             'skiptest' => 0,
                             'makeflags' => {
                                              '-j4' => undef
                                            },
                             'force' => 0,
                             'cpantest' => 0,
                             'prereqs' => 2,
                             'format' => 'MakeMaker',
                             'signature' => 0,
                             'makemakerflags' => {},
                             'lib' => [],
                             'debug' => 0,
                             'shell' => 'CPANPLUS::Shell::Default',
                             'md5' => 1
                           }
    };

    bless($conf, $class);
    return $conf;

} #new


1;

__END__
