/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.Comments;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.stream.Stream;

@BugPattern(summary="Non-standard parameter comment; prefer `/* paramName= */ arg`", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ParameterComment
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matchNewClassOrMethodInvocation(ASTHelpers.getSymbol((MethodInvocationTree)tree), (ImmutableList<Commented<ExpressionTree>>)Comments.findCommentsForArguments((MethodInvocationTree)tree, (VisitorState)state), tree);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.matchNewClassOrMethodInvocation(ASTHelpers.getSymbol((NewClassTree)tree), (ImmutableList<Commented<ExpressionTree>>)Comments.findCommentsForArguments((NewClassTree)tree, (VisitorState)state), tree);
    }

    private Description matchNewClassOrMethodInvocation(Symbol.MethodSymbol symbol, ImmutableList<Commented<ExpressionTree>> arguments, Tree tree) {
        if (((List)symbol.getParameters()).isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        Streams.forEachPair((Stream)arguments.stream(), Stream.concat(symbol.getParameters().stream(), Stream.iterate((Symbol.VarSymbol)Iterables.getLast((Iterable)symbol.getParameters()), x -> x)), (commented, param) -> {
            if (commented.beforeComments().stream().anyMatch(c -> Comments.getTextFromComment((Tokens.Comment)c).replace(" ", "").equals((Name)param.getSimpleName() + "="))) {
                return;
            }
            ImmutableList comments = commented.afterComments().isEmpty() ? commented.beforeComments() : commented.afterComments();
            comments.stream().filter(c -> ParameterComment.matchingParamComment(c, param)).findFirst().ifPresent(c -> ParameterComment.fixParamComment(fix, (Commented<ExpressionTree>)commented, param, c));
        });
        return fix.isEmpty() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)fix.build());
    }

    private static boolean matchingParamComment(Tokens.Comment c, Symbol.VarSymbol param) {
        return ((Name)param.getSimpleName()).contentEquals(Comments.getTextFromComment((Tokens.Comment)c).replaceAll("\\s*=\\s*$", ""));
    }

    private static void fixParamComment(SuggestedFix.Builder fix, Commented<ExpressionTree> commented, Symbol.VarSymbol param, Tokens.Comment c) {
        fix.prefixWith(commented.tree(), String.format("/* %s= */ ", param.getSimpleName())).replace(c.getSourcePos(0), c.getSourcePos(0) + c.getText().length(), "");
    }
}

