/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_UTypeParameter;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.StringName;
import com.google.errorprone.refaster.UAnnotation;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UTree;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.Nullable;

@AutoValue
abstract class UTypeParameter
extends UTree<JCTree.JCTypeParameter>
implements TypeParameterTree {
    UTypeParameter() {
    }

    @VisibleForTesting
    static UTypeParameter create(CharSequence name, UExpression ... bounds) {
        return UTypeParameter.create(name, (Iterable<? extends UExpression>)ImmutableList.copyOf((Object[])bounds), (Iterable<? extends UAnnotation>)ImmutableList.of());
    }

    static UTypeParameter create(CharSequence name, Iterable<? extends UExpression> bounds, Iterable<? extends UAnnotation> annotations) {
        return new AutoValue_UTypeParameter(StringName.of(name), (ImmutableList<UExpression>)ImmutableList.copyOf(bounds), (ImmutableList<UAnnotation>)ImmutableList.copyOf(annotations));
    }

    @Override
    public abstract StringName getName();

    public abstract ImmutableList<UExpression> getBounds();

    public abstract ImmutableList<UAnnotation> getAnnotations();

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_PARAMETER;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitTypeParameter(this, data);
    }

    @Override
    public JCTree.JCTypeParameter inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().TypeParameter(this.getName().inline(inliner), inliner.inlineList(this.getBounds()));
    }

    @Override
    @Nullable
    public Choice<Unifier> visitTypeParameter(TypeParameterTree node, @Nullable Unifier unifier) {
        return this.getName().unify(node.getName(), unifier).thenChoose(Unifier.unifications(this.getBounds(), node.getBounds())).thenChoose(Unifier.unifications(this.getAnnotations(), node.getAnnotations()));
    }
}

