//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

// Possible remote log data block statuses.
type MAV_REMOTE_LOG_DATA_BLOCK_STATUSES uint64

const (
	// This block has NOT been received.
	MAV_REMOTE_LOG_DATA_BLOCK_NACK MAV_REMOTE_LOG_DATA_BLOCK_STATUSES = 0
	// This block has been received.
	MAV_REMOTE_LOG_DATA_BLOCK_ACK MAV_REMOTE_LOG_DATA_BLOCK_STATUSES = 1
)

var value_to_label_MAV_REMOTE_LOG_DATA_BLOCK_STATUSES = map[MAV_REMOTE_LOG_DATA_BLOCK_STATUSES]string{
	MAV_REMOTE_LOG_DATA_BLOCK_NACK: "MAV_REMOTE_LOG_DATA_BLOCK_NACK",
	MAV_REMOTE_LOG_DATA_BLOCK_ACK:  "MAV_REMOTE_LOG_DATA_BLOCK_ACK",
}

var label_to_value_MAV_REMOTE_LOG_DATA_BLOCK_STATUSES = map[string]MAV_REMOTE_LOG_DATA_BLOCK_STATUSES{
	"MAV_REMOTE_LOG_DATA_BLOCK_NACK": MAV_REMOTE_LOG_DATA_BLOCK_NACK,
	"MAV_REMOTE_LOG_DATA_BLOCK_ACK":  MAV_REMOTE_LOG_DATA_BLOCK_ACK,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_REMOTE_LOG_DATA_BLOCK_STATUSES) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_REMOTE_LOG_DATA_BLOCK_STATUSES[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_REMOTE_LOG_DATA_BLOCK_STATUSES) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_REMOTE_LOG_DATA_BLOCK_STATUSES[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_REMOTE_LOG_DATA_BLOCK_STATUSES(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_REMOTE_LOG_DATA_BLOCK_STATUSES) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
