//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type SECURE_COMMAND_OP uint64

const (
	// Get an 8 byte session key which is used for remote secure updates which operate on flight controller data such as bootloader public keys. Return data will be 8 bytes on success. The session key remains valid until either the flight controller reboots or another SECURE_COMMAND_GET_SESSION_KEY is run.
	SECURE_COMMAND_GET_SESSION_KEY SECURE_COMMAND_OP = 0
	// Get an 8 byte session key which is used for remote secure updates which operate on RemoteID module data. Return data will be 8 bytes on success. The session key remains valid until either the remote ID module reboots or another SECURE_COMMAND_GET_REMOTEID_SESSION_KEY is run.
	SECURE_COMMAND_GET_REMOTEID_SESSION_KEY SECURE_COMMAND_OP = 1
	// Remove range of public keys from the bootloader. Command data consists of two bytes, first byte if index of first public key to remove. Second byte is the number of keys to remove. If all keys are removed then secure boot is disabled and insecure firmware can be loaded.
	SECURE_COMMAND_REMOVE_PUBLIC_KEYS SECURE_COMMAND_OP = 2
	// Get current public keys from the bootloader. Command data consists of two bytes, first byte is index of first public key to fetch, 2nd byte is number of keys to fetch. Total data needs to fit in data portion of reply (max 6 keys for 32 byte keys). Reply data has the index of the first key in the first byte, followed by the keys. Returned keys may be less than the number of keys requested if there are less keys installed than requested.
	SECURE_COMMAND_GET_PUBLIC_KEYS SECURE_COMMAND_OP = 3
	// Set current public keys in the bootloader. Data consists of a one byte public key index followed by the public keys. With 32 byte keys this allows for up to 6 keys to be set in one request. Keys outside of the range that is being set will remain unchanged.
	SECURE_COMMAND_SET_PUBLIC_KEYS SECURE_COMMAND_OP = 4
	// Get config data for remote ID module. This command should be sent to the component ID of the flight controller which will forward it to the RemoteID module either over mavlink or DroneCAN. Data format is specific to the RemoteID implementation, see RemoteID firmware documentation for details.
	SECURE_COMMAND_GET_REMOTEID_CONFIG SECURE_COMMAND_OP = 5
	// Set config data for remote ID module. This command should be sent to the component ID of the flight controller which will forward it to the RemoteID module either over mavlink or DroneCAN. Data format is specific to the RemoteID implementation, see RemoteID firmware documentation for details.
	SECURE_COMMAND_SET_REMOTEID_CONFIG SECURE_COMMAND_OP = 6
	// Flash bootloader from local storage. Data is the filename to use for the bootloader. This is intended to be used with MAVFtp to upload a new bootloader to a microSD before flashing.
	SECURE_COMMAND_FLASH_BOOTLOADER SECURE_COMMAND_OP = 7
)

var value_to_label_SECURE_COMMAND_OP = map[SECURE_COMMAND_OP]string{
	SECURE_COMMAND_GET_SESSION_KEY:          "SECURE_COMMAND_GET_SESSION_KEY",
	SECURE_COMMAND_GET_REMOTEID_SESSION_KEY: "SECURE_COMMAND_GET_REMOTEID_SESSION_KEY",
	SECURE_COMMAND_REMOVE_PUBLIC_KEYS:       "SECURE_COMMAND_REMOVE_PUBLIC_KEYS",
	SECURE_COMMAND_GET_PUBLIC_KEYS:          "SECURE_COMMAND_GET_PUBLIC_KEYS",
	SECURE_COMMAND_SET_PUBLIC_KEYS:          "SECURE_COMMAND_SET_PUBLIC_KEYS",
	SECURE_COMMAND_GET_REMOTEID_CONFIG:      "SECURE_COMMAND_GET_REMOTEID_CONFIG",
	SECURE_COMMAND_SET_REMOTEID_CONFIG:      "SECURE_COMMAND_SET_REMOTEID_CONFIG",
	SECURE_COMMAND_FLASH_BOOTLOADER:         "SECURE_COMMAND_FLASH_BOOTLOADER",
}

var label_to_value_SECURE_COMMAND_OP = map[string]SECURE_COMMAND_OP{
	"SECURE_COMMAND_GET_SESSION_KEY":          SECURE_COMMAND_GET_SESSION_KEY,
	"SECURE_COMMAND_GET_REMOTEID_SESSION_KEY": SECURE_COMMAND_GET_REMOTEID_SESSION_KEY,
	"SECURE_COMMAND_REMOVE_PUBLIC_KEYS":       SECURE_COMMAND_REMOVE_PUBLIC_KEYS,
	"SECURE_COMMAND_GET_PUBLIC_KEYS":          SECURE_COMMAND_GET_PUBLIC_KEYS,
	"SECURE_COMMAND_SET_PUBLIC_KEYS":          SECURE_COMMAND_SET_PUBLIC_KEYS,
	"SECURE_COMMAND_GET_REMOTEID_CONFIG":      SECURE_COMMAND_GET_REMOTEID_CONFIG,
	"SECURE_COMMAND_SET_REMOTEID_CONFIG":      SECURE_COMMAND_SET_REMOTEID_CONFIG,
	"SECURE_COMMAND_FLASH_BOOTLOADER":         SECURE_COMMAND_FLASH_BOOTLOADER,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e SECURE_COMMAND_OP) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_SECURE_COMMAND_OP[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *SECURE_COMMAND_OP) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_SECURE_COMMAND_OP[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = SECURE_COMMAND_OP(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e SECURE_COMMAND_OP) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
