//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Precision land modes (used in MAV_CMD_NAV_LAND).
type PRECISION_LAND_MODE uint64

const (
	// Normal (non-precision) landing.
	PRECISION_LAND_MODE_DISABLED PRECISION_LAND_MODE = 0
	// Use precision landing if beacon detected when land command accepted, otherwise land normally.
	PRECISION_LAND_MODE_OPPORTUNISTIC PRECISION_LAND_MODE = 1
	// Use precision landing, searching for beacon if not found when land command accepted (land normally if beacon cannot be found).
	PRECISION_LAND_MODE_REQUIRED PRECISION_LAND_MODE = 2
)

var value_to_label_PRECISION_LAND_MODE = map[PRECISION_LAND_MODE]string{
	PRECISION_LAND_MODE_DISABLED:      "PRECISION_LAND_MODE_DISABLED",
	PRECISION_LAND_MODE_OPPORTUNISTIC: "PRECISION_LAND_MODE_OPPORTUNISTIC",
	PRECISION_LAND_MODE_REQUIRED:      "PRECISION_LAND_MODE_REQUIRED",
}

var label_to_value_PRECISION_LAND_MODE = map[string]PRECISION_LAND_MODE{
	"PRECISION_LAND_MODE_DISABLED":      PRECISION_LAND_MODE_DISABLED,
	"PRECISION_LAND_MODE_OPPORTUNISTIC": PRECISION_LAND_MODE_OPPORTUNISTIC,
	"PRECISION_LAND_MODE_REQUIRED":      PRECISION_LAND_MODE_REQUIRED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e PRECISION_LAND_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_PRECISION_LAND_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *PRECISION_LAND_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_PRECISION_LAND_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = PRECISION_LAND_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e PRECISION_LAND_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
