//autogenerated:yes
//nolint:revive,misspell,govet,lll
package loweheiser

// Composite EFI and Governor data from Loweheiser equipment.  This message is created by the EFI unit based on its own data and data received from a governor attached to that EFI unit.
type MessageLoweheiserGovEfi struct {
	// Generator Battery voltage.
	VoltBatt float32
	// Generator Battery current.
	CurrBatt float32
	// Current being produced by generator.
	CurrGen float32
	// Load current being consumed by the UAV (sum of curr_gen and curr_batt)
	CurrRot float32
	// Generator fuel remaining in litres.
	FuelLevel float32
	// Throttle Output.
	Throttle float32
	// Seconds this generator has run since it was rebooted.
	Runtime uint32
	// Seconds until this generator requires maintenance.  A negative value indicates maintenance is past due.
	UntilMaintenance int32
	// The Temperature of the rectifier.
	RectifierTemp float32
	// The temperature of the mechanical motor, fuel cell core or generator.
	GeneratorTemp float32
	// EFI Supply Voltage.
	EfiBatt float32
	// Motor RPM.
	EfiRpm float32
	// Injector pulse-width in milliseconds.
	EfiPw float32
	// Fuel flow rate in litres/hour.
	EfiFuelFlow float32
	// Fuel consumed.
	EfiFuelConsumed float32
	// Atmospheric pressure.
	EfiBaro float32
	// Manifold Air Temperature.
	EfiMat float32
	// Cylinder Head Temperature.
	EfiClt float32
	// Throttle Position.
	EfiTps float32
	// Exhaust gas temperature.
	EfiExhaustGasTemperature float32
	// EFI index.
	EfiIndex uint8
	// Generator status.
	GeneratorStatus uint16
	// EFI status.
	EfiStatus uint16
}

// GetID implements the message.Message interface.
func (*MessageLoweheiserGovEfi) GetID() uint32 {
	return 10151
}
