//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package marsh

import (
	"fmt"
	"strconv"
)

// Specific axis of pilot control inputs, with order corresponding to x, y, z, r fields in MANUAL_CONTROL message.
type CONTROL_AXIS uint64

const (
	// Roll axis, with positive values corresponding to stick right movement, causing the vehicle to roll right. For helicopters this is lateral cyclic.
	CONTROL_AXIS_ROLL CONTROL_AXIS = 0
	// Pitch axis, with positive values corresponding to stick forward movement, causing the vehicle to move nose down. For helicopters this is longitudinal cyclic.
	CONTROL_AXIS_PITCH CONTROL_AXIS = 1
	// Main thrust, with positive values corresponding to going faster and higher. For helicopters this is collective.
	CONTROL_AXIS_THRUST CONTROL_AXIS = 2
	// Yaw axis, with positive values corresponding to pushing right pedal, causing the vehicle to face right direction. For helicopters this is tail collective.
	CONTROL_AXIS_YAW CONTROL_AXIS = 3
)

var value_to_label_CONTROL_AXIS = map[CONTROL_AXIS]string{
	CONTROL_AXIS_ROLL:   "CONTROL_AXIS_ROLL",
	CONTROL_AXIS_PITCH:  "CONTROL_AXIS_PITCH",
	CONTROL_AXIS_THRUST: "CONTROL_AXIS_THRUST",
	CONTROL_AXIS_YAW:    "CONTROL_AXIS_YAW",
}

var label_to_value_CONTROL_AXIS = map[string]CONTROL_AXIS{
	"CONTROL_AXIS_ROLL":   CONTROL_AXIS_ROLL,
	"CONTROL_AXIS_PITCH":  CONTROL_AXIS_PITCH,
	"CONTROL_AXIS_THRUST": CONTROL_AXIS_THRUST,
	"CONTROL_AXIS_YAW":    CONTROL_AXIS_YAW,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e CONTROL_AXIS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_CONTROL_AXIS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *CONTROL_AXIS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_CONTROL_AXIS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = CONTROL_AXIS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e CONTROL_AXIS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
