//autogenerated:yes
//nolint:revive,misspell,govet,lll
package storm32

// Radio link information. Tx: ground-side device, Rx: vehicle-side device.
// The values of the fields in this message do normally not or only slowly change with time, and for most times the message can be send at a low rate, like 0.2 Hz.
// If values change then the message should temporarily be send more often to inform the system about the changes.
// The target_system field should normally be set to the system id of the system the link is connected to, typically the flight controller.
// The target_component field can normally be set to 0, so that all components of the system can receive the message.
type MessageMlrsRadioLinkInformation struct {
	// System ID (ID of target system, normally flight controller).
	TargetSystem uint8
	// Component ID (normally 0 for broadcast).
	TargetComponent uint8
	// Radio link type. 0: unknown/generic type.
	Type MLRS_RADIO_LINK_TYPE `mavenum:"uint8"`
	// Operation mode. Radio link dependent. UINT8_MAX: ignore/unknown.
	Mode uint8
	// Tx transmit power in dBm. INT8_MAX: unknown.
	TxPower int8
	// Rx transmit power in dBm. INT8_MAX: unknown.
	RxPower int8
	// Frame rate in Hz (frames per second) for Tx to Rx transmission. 0: unknown.
	TxFrameRate uint16
	// Frame rate in Hz (frames per second) for Rx to Tx transmission. Normally equal to tx_packet_rate. 0: unknown.
	RxFrameRate uint16
	// Operation mode as human readable string. Radio link dependent. Terminated by NULL if the string length is less than 6 chars and WITHOUT NULL termination if the length is exactly 6 chars - applications have to provide 6+1 bytes storage if the mode is stored as string. Use a zero-length string if not known.
	ModeStr string `mavlen:"6"`
	// Frequency band as human readable string. Radio link dependent. Terminated by NULL if the string length is less than 6 chars and WITHOUT NULL termination if the length is exactly 6 chars - applications have to provide 6+1 bytes storage if the mode is stored as string. Use a zero-length string if not known.
	BandStr string `mavlen:"6"`
	// Maximum data rate of serial stream in bytes/s for Tx to Rx transmission. 0: unknown. UINT16_MAX: data rate is 64 KBytes/s or larger.
	TxSerDataRate uint16
	// Maximum data rate of serial stream in bytes/s for Rx to Tx transmission. 0: unknown. UINT16_MAX: data rate is 64 KBytes/s or larger.
	RxSerDataRate uint16
	// Receive sensitivity of Tx in inverted dBm. 1..255 represents -1..-255 dBm, 0: unknown.
	TxReceiveSensitivity uint8
	// Receive sensitivity of Rx in inverted dBm. 1..255 represents -1..-255 dBm, 0: unknown.
	RxReceiveSensitivity uint8
}

// GetID implements the message.Message interface.
func (*MessageMlrsRadioLinkInformation) GetID() uint32 {
	return 60046
}
