// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/ai/generativelanguage/v1alpha/model_service.proto

package generativelanguagepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ModelService_GetModel_FullMethodName         = "/google.ai.generativelanguage.v1alpha.ModelService/GetModel"
	ModelService_ListModels_FullMethodName       = "/google.ai.generativelanguage.v1alpha.ModelService/ListModels"
	ModelService_GetTunedModel_FullMethodName    = "/google.ai.generativelanguage.v1alpha.ModelService/GetTunedModel"
	ModelService_ListTunedModels_FullMethodName  = "/google.ai.generativelanguage.v1alpha.ModelService/ListTunedModels"
	ModelService_CreateTunedModel_FullMethodName = "/google.ai.generativelanguage.v1alpha.ModelService/CreateTunedModel"
	ModelService_UpdateTunedModel_FullMethodName = "/google.ai.generativelanguage.v1alpha.ModelService/UpdateTunedModel"
	ModelService_DeleteTunedModel_FullMethodName = "/google.ai.generativelanguage.v1alpha.ModelService/DeleteTunedModel"
)

// ModelServiceClient is the client API for ModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ModelServiceClient interface {
	// Gets information about a specific `Model` such as its version number, token
	// limits,
	// [parameters](https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters)
	// and other metadata. Refer to the [Gemini models
	// guide](https://ai.google.dev/gemini-api/docs/models/gemini) for detailed
	// model information.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists the [`Model`s](https://ai.google.dev/gemini-api/docs/models/gemini)
	// available through the Gemini API.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Gets information about a specific TunedModel.
	GetTunedModel(ctx context.Context, in *GetTunedModelRequest, opts ...grpc.CallOption) (*TunedModel, error)
	// Lists created tuned models.
	ListTunedModels(ctx context.Context, in *ListTunedModelsRequest, opts ...grpc.CallOption) (*ListTunedModelsResponse, error)
	// Creates a tuned model.
	// Check intermediate tuning progress (if any) through the
	// [google.longrunning.Operations] service.
	//
	// Access status and results through the Operations service.
	// Example:
	//
	//	GET /v1/tunedModels/az2mb0bpw6i/operations/000-111-222
	CreateTunedModel(ctx context.Context, in *CreateTunedModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a tuned model.
	UpdateTunedModel(ctx context.Context, in *UpdateTunedModelRequest, opts ...grpc.CallOption) (*TunedModel, error)
	// Deletes a tuned model.
	DeleteTunedModel(ctx context.Context, in *DeleteTunedModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type modelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelServiceClient(cc grpc.ClientConnInterface) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, ModelService_GetModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, ModelService_ListModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetTunedModel(ctx context.Context, in *GetTunedModelRequest, opts ...grpc.CallOption) (*TunedModel, error) {
	out := new(TunedModel)
	err := c.cc.Invoke(ctx, ModelService_GetTunedModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListTunedModels(ctx context.Context, in *ListTunedModelsRequest, opts ...grpc.CallOption) (*ListTunedModelsResponse, error) {
	out := new(ListTunedModelsResponse)
	err := c.cc.Invoke(ctx, ModelService_ListTunedModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) CreateTunedModel(ctx context.Context, in *CreateTunedModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelService_CreateTunedModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) UpdateTunedModel(ctx context.Context, in *UpdateTunedModelRequest, opts ...grpc.CallOption) (*TunedModel, error) {
	out := new(TunedModel)
	err := c.cc.Invoke(ctx, ModelService_UpdateTunedModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteTunedModel(ctx context.Context, in *DeleteTunedModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ModelService_DeleteTunedModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelServiceServer is the server API for ModelService service.
// All implementations should embed UnimplementedModelServiceServer
// for forward compatibility
type ModelServiceServer interface {
	// Gets information about a specific `Model` such as its version number, token
	// limits,
	// [parameters](https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters)
	// and other metadata. Refer to the [Gemini models
	// guide](https://ai.google.dev/gemini-api/docs/models/gemini) for detailed
	// model information.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists the [`Model`s](https://ai.google.dev/gemini-api/docs/models/gemini)
	// available through the Gemini API.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Gets information about a specific TunedModel.
	GetTunedModel(context.Context, *GetTunedModelRequest) (*TunedModel, error)
	// Lists created tuned models.
	ListTunedModels(context.Context, *ListTunedModelsRequest) (*ListTunedModelsResponse, error)
	// Creates a tuned model.
	// Check intermediate tuning progress (if any) through the
	// [google.longrunning.Operations] service.
	//
	// Access status and results through the Operations service.
	// Example:
	//
	//	GET /v1/tunedModels/az2mb0bpw6i/operations/000-111-222
	CreateTunedModel(context.Context, *CreateTunedModelRequest) (*longrunningpb.Operation, error)
	// Updates a tuned model.
	UpdateTunedModel(context.Context, *UpdateTunedModelRequest) (*TunedModel, error)
	// Deletes a tuned model.
	DeleteTunedModel(context.Context, *DeleteTunedModelRequest) (*emptypb.Empty, error)
}

// UnimplementedModelServiceServer should be embedded to have forward compatible implementations.
type UnimplementedModelServiceServer struct {
}

func (UnimplementedModelServiceServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (UnimplementedModelServiceServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (UnimplementedModelServiceServer) GetTunedModel(context.Context, *GetTunedModelRequest) (*TunedModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTunedModel not implemented")
}
func (UnimplementedModelServiceServer) ListTunedModels(context.Context, *ListTunedModelsRequest) (*ListTunedModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTunedModels not implemented")
}
func (UnimplementedModelServiceServer) CreateTunedModel(context.Context, *CreateTunedModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTunedModel not implemented")
}
func (UnimplementedModelServiceServer) UpdateTunedModel(context.Context, *UpdateTunedModelRequest) (*TunedModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTunedModel not implemented")
}
func (UnimplementedModelServiceServer) DeleteTunedModel(context.Context, *DeleteTunedModelRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTunedModel not implemented")
}

// UnsafeModelServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ModelServiceServer will
// result in compilation errors.
type UnsafeModelServiceServer interface {
	mustEmbedUnimplementedModelServiceServer()
}

func RegisterModelServiceServer(s grpc.ServiceRegistrar, srv ModelServiceServer) {
	s.RegisterService(&ModelService_ServiceDesc, srv)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_GetModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetTunedModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTunedModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetTunedModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_GetTunedModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetTunedModel(ctx, req.(*GetTunedModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListTunedModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTunedModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListTunedModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_ListTunedModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListTunedModels(ctx, req.(*ListTunedModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_CreateTunedModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTunedModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).CreateTunedModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_CreateTunedModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).CreateTunedModel(ctx, req.(*CreateTunedModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_UpdateTunedModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTunedModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).UpdateTunedModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_UpdateTunedModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).UpdateTunedModel(ctx, req.(*UpdateTunedModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteTunedModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTunedModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteTunedModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelService_DeleteTunedModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteTunedModel(ctx, req.(*DeleteTunedModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ModelService_ServiceDesc is the grpc.ServiceDesc for ModelService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ModelService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.ai.generativelanguage.v1alpha.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "GetTunedModel",
			Handler:    _ModelService_GetTunedModel_Handler,
		},
		{
			MethodName: "ListTunedModels",
			Handler:    _ModelService_ListTunedModels_Handler,
		},
		{
			MethodName: "CreateTunedModel",
			Handler:    _ModelService_CreateTunedModel_Handler,
		},
		{
			MethodName: "UpdateTunedModel",
			Handler:    _ModelService_UpdateTunedModel_Handler,
		},
		{
			MethodName: "DeleteTunedModel",
			Handler:    _ModelService_DeleteTunedModel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ai/generativelanguage/v1alpha/model_service.proto",
}
