// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// # [Deprecated] Google AI Go SDK for the Gemini API
//
// With Gemini 2.0, we took the chance to create a single unified SDK for all developers who want
// to use Google's GenAI models (Gemini, Veo, Imagen, etc). As part of that process, we took all of
// the feedback from this SDK and what developers like about other SDKs in the ecosystem to create
// the [Google Gen AI SDK]. 
//
// The Gemini API docs are fully updated to show examples of the new Google Gen AI SDK:
// [Get started].
//
// We know how disruptive an SDK change can be and don't take this change lightly, but our goal
// is to create an extremely simple and clear path for developers to build with our models so it
// felt necessary to make this change.
//
// Thank you for building with Gemini and [let us know] if you need any help!
//
// Please be advised that this repository is now considered legacy. For the latest features, performance
// improvements, and active development, we strongly recommend migrating to the official
// [Google Generative AI SDK for Go].
//
// Support Plan for this Repository:
//
//  - Limited Maintenance: Development is now restricted to critical bug fixes only. No new features will be added.
//  - Purpose: This limited support aims to provide stability for users while they transition to the new SDK.
//  - End-of-Life Date: All support for this repository (including bug fixes) will permanently end on August 31st, 2025.
//
// We encourage all users to begin planning their migration to the [Google Generative AI SDK] to ensure
// continued access to the latest capabilities and support.
//
//
// # Getting started
//
// NOTE: This client uses the v1beta version of the API.
//
// Reading the [examples] is the best way to learn how to use this package.
//
// # Authorization
//
// You will need an API key to use the service.
// See the [setup tutorial] for details.
//
// # Errors
//
// [examples]: https://pkg.go.dev/github.com/google/generative-ai-go/genai#pkg-examples
// [setup tutorial]: https://ai.google.dev/tutorials/setup
// [Google Gen AI SDK]: https://github.com/googleapis/go-genai
// [Get started]: https://ai.google.dev/gemini-api/docs/quickstart?lang=go
// [let us know]: https://discuss.ai.google.dev/c/gemini-api/4
// [Google Generative AI SDK for Go]: https://github.com/googleapis/go-genai
// [Google Generative AI SDK]: https://github.com/googleapis/go-genai
package genai
