// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/Microsoft/hcsshim/cmd/ncproxy/nodenetsvc/nodenetsvc.proto

package nodenetsvc

import (
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type RequestType int32

const (
	RequestType_Setup    RequestType = 0
	RequestType_Teardown RequestType = 1
)

var RequestType_name = map[int32]string{
	0: "Setup",
	1: "Teardown",
}

var RequestType_value = map[string]int32{
	"Setup":    0,
	"Teardown": 1,
}

func (x RequestType) String() string {
	return proto.EnumName(RequestType_name, int32(x))
}

func (RequestType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3a65404bd96160d4, []int{0}
}

type ConfigureNetworkingRequest struct {
	ContainerID          string      `protobuf:"bytes,1,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	RequestType          RequestType `protobuf:"varint,2,opt,name=request_type,json=requestType,proto3,enum=azure.nodenetworkservice.RequestType" json:"request_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ConfigureNetworkingRequest) Reset()      { *m = ConfigureNetworkingRequest{} }
func (*ConfigureNetworkingRequest) ProtoMessage() {}
func (*ConfigureNetworkingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a65404bd96160d4, []int{0}
}
func (m *ConfigureNetworkingRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigureNetworkingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigureNetworkingRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigureNetworkingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigureNetworkingRequest.Merge(m, src)
}
func (m *ConfigureNetworkingRequest) XXX_Size() int {
	return m.Size()
}
func (m *ConfigureNetworkingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigureNetworkingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigureNetworkingRequest proto.InternalMessageInfo

type ConfigureNetworkingResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigureNetworkingResponse) Reset()      { *m = ConfigureNetworkingResponse{} }
func (*ConfigureNetworkingResponse) ProtoMessage() {}
func (*ConfigureNetworkingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a65404bd96160d4, []int{1}
}
func (m *ConfigureNetworkingResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigureNetworkingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigureNetworkingResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigureNetworkingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigureNetworkingResponse.Merge(m, src)
}
func (m *ConfigureNetworkingResponse) XXX_Size() int {
	return m.Size()
}
func (m *ConfigureNetworkingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigureNetworkingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigureNetworkingResponse proto.InternalMessageInfo

type PingNodeNetworkServiceRequest struct {
	PingRequestMessage   string   `protobuf:"bytes,1,opt,name=pingRequestMessage,proto3" json:"pingRequestMessage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PingNodeNetworkServiceRequest) Reset()      { *m = PingNodeNetworkServiceRequest{} }
func (*PingNodeNetworkServiceRequest) ProtoMessage() {}
func (*PingNodeNetworkServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a65404bd96160d4, []int{2}
}
func (m *PingNodeNetworkServiceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PingNodeNetworkServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PingNodeNetworkServiceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PingNodeNetworkServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingNodeNetworkServiceRequest.Merge(m, src)
}
func (m *PingNodeNetworkServiceRequest) XXX_Size() int {
	return m.Size()
}
func (m *PingNodeNetworkServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PingNodeNetworkServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PingNodeNetworkServiceRequest proto.InternalMessageInfo

type PingNodeNetworkServiceResponse struct {
	PingResponseMessage  string   `protobuf:"bytes,1,opt,name=pingResponseMessage,proto3" json:"pingResponseMessage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PingNodeNetworkServiceResponse) Reset()      { *m = PingNodeNetworkServiceResponse{} }
func (*PingNodeNetworkServiceResponse) ProtoMessage() {}
func (*PingNodeNetworkServiceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a65404bd96160d4, []int{3}
}
func (m *PingNodeNetworkServiceResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PingNodeNetworkServiceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PingNodeNetworkServiceResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PingNodeNetworkServiceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingNodeNetworkServiceResponse.Merge(m, src)
}
func (m *PingNodeNetworkServiceResponse) XXX_Size() int {
	return m.Size()
}
func (m *PingNodeNetworkServiceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PingNodeNetworkServiceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PingNodeNetworkServiceResponse proto.InternalMessageInfo

type ConfigureContainerNetworkingRequest struct {
	RequestType          RequestType `protobuf:"varint,1,opt,name=request_type,json=requestType,proto3,enum=azure.nodenetworkservice.RequestType" json:"request_type,omitempty"`
	ContainerID          string      `protobuf:"bytes,2,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	NetworkNamespace     string      `protobuf:"bytes,3,opt,name=network_namespace,json=networkNamespace,proto3" json:"network_namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ConfigureContainerNetworkingRequest) Reset()      { *m = ConfigureContainerNetworkingRequest{} }
func (*ConfigureContainerNetworkingRequest) ProtoMessage() {}
func (*ConfigureContainerNetworkingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a65404bd96160d4, []int{4}
}
func (m *ConfigureContainerNetworkingRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigureContainerNetworkingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigureContainerNetworkingRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigureContainerNetworkingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigureContainerNetworkingRequest.Merge(m, src)
}
func (m *ConfigureContainerNetworkingRequest) XXX_Size() int {
	return m.Size()
}
func (m *ConfigureContainerNetworkingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigureContainerNetworkingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigureContainerNetworkingRequest proto.InternalMessageInfo

type ConfigureContainerNetworkingResponse struct {
	Success              bool     `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	ResponseJson         string   `protobuf:"bytes,2,opt,name=response_json,json=responseJson,proto3" json:"response_json,omitempty"`
	ErrorJson            string   `protobuf:"bytes,3,opt,name=error_json,json=errorJson,proto3" json:"error_json,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigureContainerNetworkingResponse) Reset()      { *m = ConfigureContainerNetworkingResponse{} }
func (*ConfigureContainerNetworkingResponse) ProtoMessage() {}
func (*ConfigureContainerNetworkingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a65404bd96160d4, []int{5}
}
func (m *ConfigureContainerNetworkingResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigureContainerNetworkingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigureContainerNetworkingResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigureContainerNetworkingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigureContainerNetworkingResponse.Merge(m, src)
}
func (m *ConfigureContainerNetworkingResponse) XXX_Size() int {
	return m.Size()
}
func (m *ConfigureContainerNetworkingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigureContainerNetworkingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigureContainerNetworkingResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("azure.nodenetworkservice.RequestType", RequestType_name, RequestType_value)
	proto.RegisterType((*ConfigureNetworkingRequest)(nil), "azure.nodenetworkservice.ConfigureNetworkingRequest")
	proto.RegisterType((*ConfigureNetworkingResponse)(nil), "azure.nodenetworkservice.ConfigureNetworkingResponse")
	proto.RegisterType((*PingNodeNetworkServiceRequest)(nil), "azure.nodenetworkservice.PingNodeNetworkServiceRequest")
	proto.RegisterType((*PingNodeNetworkServiceResponse)(nil), "azure.nodenetworkservice.PingNodeNetworkServiceResponse")
	proto.RegisterType((*ConfigureContainerNetworkingRequest)(nil), "azure.nodenetworkservice.ConfigureContainerNetworkingRequest")
	proto.RegisterType((*ConfigureContainerNetworkingResponse)(nil), "azure.nodenetworkservice.ConfigureContainerNetworkingResponse")
}

func init() {
	proto.RegisterFile("github.com/Microsoft/hcsshim/cmd/ncproxy/nodenetsvc/nodenetsvc.proto", fileDescriptor_3a65404bd96160d4)
}

var fileDescriptor_3a65404bd96160d4 = []byte{
	// 513 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0xae, 0x37, 0x01, 0xeb, 0x6b, 0x81, 0xe2, 0x49, 0x28, 0x2a, 0x34, 0x4c, 0xd9, 0x40, 0x13,
	0x48, 0x09, 0x2a, 0x20, 0xb8, 0xc0, 0x61, 0xdb, 0x81, 0x21, 0xad, 0xa0, 0x6c, 0x27, 0x2e, 0x55,
	0xe6, 0xbc, 0xa5, 0x01, 0xd5, 0x0e, 0x76, 0xb2, 0x51, 0x4e, 0x08, 0x71, 0xe3, 0x1f, 0x20, 0xf1,
	0x7b, 0xd8, 0x71, 0x47, 0x4e, 0x88, 0xe5, 0x97, 0x20, 0xea, 0xa4, 0x2d, 0x6b, 0x52, 0x6d, 0xbd,
	0x25, 0xef, 0xf3, 0xfb, 0xfc, 0x7d, 0x9f, 0xfd, 0x0c, 0x5b, 0x41, 0x18, 0xf7, 0x92, 0x7d, 0x9b,
	0x89, 0xbe, 0xb3, 0x13, 0x32, 0x29, 0x94, 0x38, 0x88, 0x9d, 0x1e, 0x53, 0xaa, 0x17, 0xf6, 0x1d,
	0xd6, 0xf7, 0x1d, 0xce, 0x22, 0x29, 0x3e, 0x0e, 0x1c, 0x2e, 0x7c, 0xe4, 0x18, 0xab, 0x43, 0x36,
	0xf1, 0x69, 0x47, 0x52, 0xc4, 0x82, 0x1a, 0xde, 0xa7, 0x44, 0xa2, 0x9d, 0xd5, 0x8f, 0x84, 0x7c,
	0xaf, 0x50, 0x1e, 0x86, 0x0c, 0xad, 0xef, 0x04, 0x9a, 0x9b, 0x82, 0x1f, 0x84, 0x41, 0x22, 0xb1,
	0xa3, 0xb1, 0x90, 0x07, 0x2e, 0x7e, 0x48, 0x50, 0xc5, 0xb4, 0x0d, 0x75, 0x26, 0x78, 0xec, 0x85,
	0x1c, 0x65, 0x37, 0xf4, 0x0d, 0xb2, 0x42, 0xd6, 0xab, 0x1b, 0xd7, 0xd3, 0xdf, 0x77, 0x6a, 0x9b,
	0x79, 0x7d, 0x7b, 0xcb, 0xad, 0x8d, 0x16, 0x6d, 0xfb, 0xf4, 0x25, 0xd4, 0xa5, 0x6e, 0xef, 0xc6,
	0x83, 0x08, 0x8d, 0x85, 0x15, 0xb2, 0x7e, 0xad, 0x7d, 0xd7, 0x2e, 0xd3, 0x60, 0x67, 0x9b, 0xed,
	0x0d, 0x22, 0x74, 0x6b, 0x72, 0xfc, 0x63, 0xb5, 0xe0, 0x56, 0xa1, 0x36, 0x15, 0x09, 0xae, 0xd0,
	0x7a, 0x0d, 0xad, 0x37, 0x21, 0x0f, 0x3a, 0xc2, 0xcf, 0xd1, 0x5d, 0xcd, 0x98, 0xab, 0xb7, 0x81,
	0x46, 0x63, 0x33, 0x3b, 0xa8, 0x94, 0x17, 0xa0, 0xf6, 0xe0, 0x16, 0x20, 0x96, 0x0b, 0x66, 0x19,
	0xa1, 0xde, 0x92, 0x3e, 0x84, 0xe5, 0x68, 0x42, 0xc2, 0xff, 0x94, 0x45, 0x90, 0x75, 0x42, 0x60,
	0x75, 0x64, 0x62, 0x94, 0xd9, 0x74, 0xd2, 0x67, 0x53, 0x23, 0xf3, 0xa6, 0x36, 0x75, 0x66, 0x0b,
	0xe7, 0x38, 0xb3, 0x07, 0x70, 0x23, 0xa3, 0xef, 0x72, 0xaf, 0x8f, 0x2a, 0xf2, 0x18, 0x1a, 0x8b,
	0x43, 0x57, 0x8d, 0x0c, 0xe8, 0xe4, 0x75, 0xeb, 0x2b, 0x81, 0xb5, 0xd9, 0x96, 0xb2, 0xb4, 0x0c,
	0xb8, 0xa2, 0x12, 0xc6, 0x50, 0xa9, 0xa1, 0x9d, 0x25, 0x37, 0xff, 0xa5, 0xab, 0x70, 0x55, 0x66,
	0xab, 0xba, 0xef, 0x94, 0xe0, 0x5a, 0xa4, 0x5b, 0xcf, 0x8b, 0xaf, 0x94, 0xe0, 0xb4, 0x05, 0x80,
	0x52, 0x0a, 0xa9, 0x57, 0x68, 0x35, 0xd5, 0x61, 0xe5, 0x1f, 0x7c, 0xff, 0x1e, 0xd4, 0x26, 0x32,
	0xa0, 0x55, 0xb8, 0xb4, 0x8b, 0x71, 0x12, 0x35, 0x2a, 0xb4, 0x0e, 0x4b, 0x7b, 0xe8, 0x49, 0x5f,
	0x1c, 0xf1, 0x06, 0x69, 0xff, 0x5c, 0x04, 0x3a, 0x7d, 0xa4, 0xf4, 0x0b, 0x81, 0xe5, 0x82, 0xdb,
	0x45, 0x1f, 0x97, 0x47, 0x5e, 0x3e, 0x28, 0xcd, 0x27, 0x17, 0xec, 0xca, 0x12, 0xfa, 0x41, 0xe0,
	0xf6, 0xac, 0x28, 0xe9, 0xf3, 0x73, 0xf0, 0x96, 0xdf, 0xaa, 0xe6, 0x8b, 0x79, 0xdb, 0x33, 0x7d,
	0xdf, 0x08, 0xdc, 0x2c, 0x1e, 0x09, 0xfa, 0xb4, 0x9c, 0x7a, 0xe6, 0x54, 0x36, 0x9f, 0x5d, 0xbc,
	0x51, 0xab, 0xd9, 0x58, 0x3b, 0x3e, 0x35, 0x2b, 0xbf, 0x4e, 0xcd, 0xca, 0xe7, 0xd4, 0x24, 0xc7,
	0xa9, 0x49, 0x4e, 0x52, 0x93, 0xfc, 0x49, 0x4d, 0xf2, 0x16, 0xc6, 0x4f, 0xde, 0xfe, 0xe5, 0xe1,
	0x9b, 0xf7, 0xe8, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x25, 0xe7, 0xf5, 0xc4, 0x3b, 0x05, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// NodeNetworkServiceClient is the client API for NodeNetworkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NodeNetworkServiceClient interface {
	ConfigureNetworking(ctx context.Context, in *ConfigureNetworkingRequest, opts ...grpc.CallOption) (*ConfigureNetworkingResponse, error)
	ConfigureContainerNetworking(ctx context.Context, in *ConfigureContainerNetworkingRequest, opts ...grpc.CallOption) (*ConfigureContainerNetworkingResponse, error)
	PingNodeNetworkService(ctx context.Context, in *PingNodeNetworkServiceRequest, opts ...grpc.CallOption) (*PingNodeNetworkServiceResponse, error)
}

type nodeNetworkServiceClient struct {
	cc *grpc.ClientConn
}

func NewNodeNetworkServiceClient(cc *grpc.ClientConn) NodeNetworkServiceClient {
	return &nodeNetworkServiceClient{cc}
}

func (c *nodeNetworkServiceClient) ConfigureNetworking(ctx context.Context, in *ConfigureNetworkingRequest, opts ...grpc.CallOption) (*ConfigureNetworkingResponse, error) {
	out := new(ConfigureNetworkingResponse)
	err := c.cc.Invoke(ctx, "/azure.nodenetworkservice.NodeNetworkService/ConfigureNetworking", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeNetworkServiceClient) ConfigureContainerNetworking(ctx context.Context, in *ConfigureContainerNetworkingRequest, opts ...grpc.CallOption) (*ConfigureContainerNetworkingResponse, error) {
	out := new(ConfigureContainerNetworkingResponse)
	err := c.cc.Invoke(ctx, "/azure.nodenetworkservice.NodeNetworkService/ConfigureContainerNetworking", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeNetworkServiceClient) PingNodeNetworkService(ctx context.Context, in *PingNodeNetworkServiceRequest, opts ...grpc.CallOption) (*PingNodeNetworkServiceResponse, error) {
	out := new(PingNodeNetworkServiceResponse)
	err := c.cc.Invoke(ctx, "/azure.nodenetworkservice.NodeNetworkService/PingNodeNetworkService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NodeNetworkServiceServer is the server API for NodeNetworkService service.
type NodeNetworkServiceServer interface {
	ConfigureNetworking(context.Context, *ConfigureNetworkingRequest) (*ConfigureNetworkingResponse, error)
	ConfigureContainerNetworking(context.Context, *ConfigureContainerNetworkingRequest) (*ConfigureContainerNetworkingResponse, error)
	PingNodeNetworkService(context.Context, *PingNodeNetworkServiceRequest) (*PingNodeNetworkServiceResponse, error)
}

// UnimplementedNodeNetworkServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNodeNetworkServiceServer struct {
}

func (*UnimplementedNodeNetworkServiceServer) ConfigureNetworking(ctx context.Context, req *ConfigureNetworkingRequest) (*ConfigureNetworkingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureNetworking not implemented")
}
func (*UnimplementedNodeNetworkServiceServer) ConfigureContainerNetworking(ctx context.Context, req *ConfigureContainerNetworkingRequest) (*ConfigureContainerNetworkingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureContainerNetworking not implemented")
}
func (*UnimplementedNodeNetworkServiceServer) PingNodeNetworkService(ctx context.Context, req *PingNodeNetworkServiceRequest) (*PingNodeNetworkServiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PingNodeNetworkService not implemented")
}

func RegisterNodeNetworkServiceServer(s *grpc.Server, srv NodeNetworkServiceServer) {
	s.RegisterService(&_NodeNetworkService_serviceDesc, srv)
}

func _NodeNetworkService_ConfigureNetworking_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureNetworkingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeNetworkServiceServer).ConfigureNetworking(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/azure.nodenetworkservice.NodeNetworkService/ConfigureNetworking",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeNetworkServiceServer).ConfigureNetworking(ctx, req.(*ConfigureNetworkingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeNetworkService_ConfigureContainerNetworking_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureContainerNetworkingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeNetworkServiceServer).ConfigureContainerNetworking(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/azure.nodenetworkservice.NodeNetworkService/ConfigureContainerNetworking",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeNetworkServiceServer).ConfigureContainerNetworking(ctx, req.(*ConfigureContainerNetworkingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeNetworkService_PingNodeNetworkService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PingNodeNetworkServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeNetworkServiceServer).PingNodeNetworkService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/azure.nodenetworkservice.NodeNetworkService/PingNodeNetworkService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeNetworkServiceServer).PingNodeNetworkService(ctx, req.(*PingNodeNetworkServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NodeNetworkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "azure.nodenetworkservice.NodeNetworkService",
	HandlerType: (*NodeNetworkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ConfigureNetworking",
			Handler:    _NodeNetworkService_ConfigureNetworking_Handler,
		},
		{
			MethodName: "ConfigureContainerNetworking",
			Handler:    _NodeNetworkService_ConfigureContainerNetworking_Handler,
		},
		{
			MethodName: "PingNodeNetworkService",
			Handler:    _NodeNetworkService_PingNodeNetworkService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/Microsoft/hcsshim/cmd/ncproxy/nodenetsvc/nodenetsvc.proto",
}

func (m *ConfigureNetworkingRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigureNetworkingRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigureNetworkingRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RequestType != 0 {
		i = encodeVarintNodenetsvc(dAtA, i, uint64(m.RequestType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.ContainerID) > 0 {
		i -= len(m.ContainerID)
		copy(dAtA[i:], m.ContainerID)
		i = encodeVarintNodenetsvc(dAtA, i, uint64(len(m.ContainerID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigureNetworkingResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigureNetworkingResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigureNetworkingResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *PingNodeNetworkServiceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingNodeNetworkServiceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PingNodeNetworkServiceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PingRequestMessage) > 0 {
		i -= len(m.PingRequestMessage)
		copy(dAtA[i:], m.PingRequestMessage)
		i = encodeVarintNodenetsvc(dAtA, i, uint64(len(m.PingRequestMessage)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PingNodeNetworkServiceResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingNodeNetworkServiceResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PingNodeNetworkServiceResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PingResponseMessage) > 0 {
		i -= len(m.PingResponseMessage)
		copy(dAtA[i:], m.PingResponseMessage)
		i = encodeVarintNodenetsvc(dAtA, i, uint64(len(m.PingResponseMessage)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfigureContainerNetworkingRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigureContainerNetworkingRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigureContainerNetworkingRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NetworkNamespace) > 0 {
		i -= len(m.NetworkNamespace)
		copy(dAtA[i:], m.NetworkNamespace)
		i = encodeVarintNodenetsvc(dAtA, i, uint64(len(m.NetworkNamespace)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ContainerID) > 0 {
		i -= len(m.ContainerID)
		copy(dAtA[i:], m.ContainerID)
		i = encodeVarintNodenetsvc(dAtA, i, uint64(len(m.ContainerID)))
		i--
		dAtA[i] = 0x12
	}
	if m.RequestType != 0 {
		i = encodeVarintNodenetsvc(dAtA, i, uint64(m.RequestType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConfigureContainerNetworkingResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigureContainerNetworkingResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigureContainerNetworkingResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorJson) > 0 {
		i -= len(m.ErrorJson)
		copy(dAtA[i:], m.ErrorJson)
		i = encodeVarintNodenetsvc(dAtA, i, uint64(len(m.ErrorJson)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ResponseJson) > 0 {
		i -= len(m.ResponseJson)
		copy(dAtA[i:], m.ResponseJson)
		i = encodeVarintNodenetsvc(dAtA, i, uint64(len(m.ResponseJson)))
		i--
		dAtA[i] = 0x12
	}
	if m.Success {
		i--
		if m.Success {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintNodenetsvc(dAtA []byte, offset int, v uint64) int {
	offset -= sovNodenetsvc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ConfigureNetworkingRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ContainerID)
	if l > 0 {
		n += 1 + l + sovNodenetsvc(uint64(l))
	}
	if m.RequestType != 0 {
		n += 1 + sovNodenetsvc(uint64(m.RequestType))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigureNetworkingResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PingNodeNetworkServiceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PingRequestMessage)
	if l > 0 {
		n += 1 + l + sovNodenetsvc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PingNodeNetworkServiceResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PingResponseMessage)
	if l > 0 {
		n += 1 + l + sovNodenetsvc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigureContainerNetworkingRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RequestType != 0 {
		n += 1 + sovNodenetsvc(uint64(m.RequestType))
	}
	l = len(m.ContainerID)
	if l > 0 {
		n += 1 + l + sovNodenetsvc(uint64(l))
	}
	l = len(m.NetworkNamespace)
	if l > 0 {
		n += 1 + l + sovNodenetsvc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigureContainerNetworkingResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Success {
		n += 2
	}
	l = len(m.ResponseJson)
	if l > 0 {
		n += 1 + l + sovNodenetsvc(uint64(l))
	}
	l = len(m.ErrorJson)
	if l > 0 {
		n += 1 + l + sovNodenetsvc(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNodenetsvc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNodenetsvc(x uint64) (n int) {
	return sovNodenetsvc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ConfigureNetworkingRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigureNetworkingRequest{`,
		`ContainerID:` + fmt.Sprintf("%v", this.ContainerID) + `,`,
		`RequestType:` + fmt.Sprintf("%v", this.RequestType) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ConfigureNetworkingResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigureNetworkingResponse{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PingNodeNetworkServiceRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PingNodeNetworkServiceRequest{`,
		`PingRequestMessage:` + fmt.Sprintf("%v", this.PingRequestMessage) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PingNodeNetworkServiceResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PingNodeNetworkServiceResponse{`,
		`PingResponseMessage:` + fmt.Sprintf("%v", this.PingResponseMessage) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ConfigureContainerNetworkingRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigureContainerNetworkingRequest{`,
		`RequestType:` + fmt.Sprintf("%v", this.RequestType) + `,`,
		`ContainerID:` + fmt.Sprintf("%v", this.ContainerID) + `,`,
		`NetworkNamespace:` + fmt.Sprintf("%v", this.NetworkNamespace) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ConfigureContainerNetworkingResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ConfigureContainerNetworkingResponse{`,
		`Success:` + fmt.Sprintf("%v", this.Success) + `,`,
		`ResponseJson:` + fmt.Sprintf("%v", this.ResponseJson) + `,`,
		`ErrorJson:` + fmt.Sprintf("%v", this.ErrorJson) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringNodenetsvc(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ConfigureNetworkingRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNodenetsvc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigureNetworkingRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigureNetworkingRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestType", wireType)
			}
			m.RequestType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestType |= RequestType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNodenetsvc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigureNetworkingResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNodenetsvc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigureNetworkingResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigureNetworkingResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipNodenetsvc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingNodeNetworkServiceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNodenetsvc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingNodeNetworkServiceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingNodeNetworkServiceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PingRequestMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PingRequestMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNodenetsvc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingNodeNetworkServiceResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNodenetsvc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingNodeNetworkServiceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingNodeNetworkServiceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PingResponseMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PingResponseMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNodenetsvc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigureContainerNetworkingRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNodenetsvc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigureContainerNetworkingRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigureContainerNetworkingRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestType", wireType)
			}
			m.RequestType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestType |= RequestType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNodenetsvc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigureContainerNetworkingResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNodenetsvc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigureContainerNetworkingResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigureContainerNetworkingResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Success", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Success = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseJson", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseJson = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorJson", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorJson = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNodenetsvc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNodenetsvc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNodenetsvc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNodenetsvc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNodenetsvc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNodenetsvc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNodenetsvc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNodenetsvc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNodenetsvc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNodenetsvc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNodenetsvc = fmt.Errorf("proto: unexpected end of group")
)
