package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ExportStatsOpenRequest Request Object
type ExportStatsOpenRequest struct {

	// 当用户开启企业项目功能时，该参数生效，表示查询资源所属项目，\"all\"表示所有项目。注意：当使用子账号调用接口时，该参数必传。
	EnterpriseProjectId *string `json:"enterprise_project_id,omitempty"`

	Body *ExportVo `json:"body,omitempty"`
}

func (o ExportStatsOpenRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ExportStatsOpenRequest struct{}"
	}

	return strings.Join([]string{"ExportStatsOpenRequest", string(data)}, " ")
}
