package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ShowConfigurationModifyHistoryRequest Request Object
type ShowConfigurationModifyHistoryRequest struct {

	// **参数解释：** 参数模板ID。 **约束限制：** 不涉及。 **取值范围：** 不涉及。 **默认取值：** 不涉及。
	ConfigId string `json:"config_id"`

	// **参数解释：** 索引位置，偏移量。 **约束限制：** 从第一条数据偏移offset条数据后开始查询，默认为0（偏移0条数据，表示从第一条数据开始查询）。 取值必须为数字，不能为负数。 **取值范围：** 不涉及。 **默认取值：** 0。
	Offset *int32 `json:"offset,omitempty"`

	// **参数解释：** 查询个数上限值。 **约束限制：** 不传该参数时，默认查询前100条信息。 **取值范围：** 1~100。 **默认取值：** 100。
	Limit *int32 `json:"limit,omitempty"`
}

func (o ShowConfigurationModifyHistoryRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ShowConfigurationModifyHistoryRequest struct{}"
	}

	return strings.Join([]string{"ShowConfigurationModifyHistoryRequest", string(data)}, " ")
}
