package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

type MysqlProxyV3 struct {

	// Proxy实例ID。
	PoolId *string `json:"pool_id,omitempty"`

	// Proxy实例开启状态。  取值: - “ACTIVE”，表示数据库代理正常； - “FAILED”，表示数据库代理创建失败； - “DELETED”，表示数据库代理已删除； - “ABNORMAL”，表示数据库代理异常； - “ENABLING PROXY”，表示数据库代理正在开启； - “DISABLING PROXY”，表示数据库代理正在关闭； - “ADDING PROXY NODE”，表示数据库代理正在扩容； - “DELETING READ REPLICAS FROM PROXY”，表示数据库代理正在移除只读节点； - “ADDING READ REPLICAS TO PROXY”，表示数据库代理正在添加只读节点； - “CHANGING WEIGHTS”，表示数据库代理正在修改只读节点权重。
	Status *string `json:"status,omitempty"`

	// Proxy读写分离地址。
	Address *string `json:"address,omitempty"`

	// Proxy端口信息。
	Port *int32 `json:"port,omitempty"`

	// Proxy实例状态。  取值范围： - ACTIVE，表示数据库代理正常 - ABNORMAL，表示数据库代理异常 - FAILED，表示数据库代理创建失败 - DELETED，表示数据库代理已删除
	PoolStatus *string `json:"pool_status,omitempty"`

	// 延时阈值，单位：秒。
	DelayThresholdInSeconds *int32 `json:"delay_threshold_in_seconds,omitempty"`

	// Elb模式的虚拟ip信息。
	ElbVip *string `json:"elb_vip,omitempty"`

	// 弹性公网IP信息。
	Eip *string `json:"eip,omitempty"`

	// Proxy实例规格的CPU数量。
	Vcpus *string `json:"vcpus,omitempty"`

	// Proxy实例规格的内存数量。
	Ram *string `json:"ram,omitempty"`

	// Proxy节点个数。
	NodeNum *int32 `json:"node_num,omitempty"`

	// **参数解释**：  数据库代理读写模式。  **取值范围**：  - readwrite：读写模式 - readonly：只读模式
	Type *MysqlProxyV3Type `json:"type,omitempty"`

	// 数据库代理创建时间。
	CreatedAt *string `json:"created_at,omitempty"`

	// 数据库代更新时间。
	UpdatedAt *string `json:"updated_at,omitempty"`

	// 是否支持HTAP节点。
	SupportApNode *bool `json:"support_ap_node,omitempty"`

	// Proxy主备模式，取值范围：Cluster。
	Mode *string `json:"mode,omitempty"`

	// Proxy节点信息。
	Nodes *[]MysqlProxyNodes `json:"nodes,omitempty"`

	// Proxy规格信息。
	FlavorRef *string `json:"flavor_ref,omitempty"`

	// Proxy实例名称。
	Name *string `json:"name,omitempty"`

	// Proxy事务拆分开关状态【ON/OFF】。
	TransactionSplit *string `json:"transaction_split,omitempty"`

	// 连接池类型。  取值范围: - CLOSED: 关闭连接池。 - SESSION: 开启会话级连接池。
	ConnectionPoolType *string `json:"connection_pool_type,omitempty"`

	// 数据库代理版本是否支持会话级连接池。  取值范围: - true: 支持。 - false: 不支持。
	SwitchConnectionPoolTypeEnabled *bool `json:"switch_connection_pool_type_enabled,omitempty"`

	// 数据库代理路由模式，默认为权重负载模式。  取值范围: - 0，表示权重负载模式; - 1，表示负载均衡模式（数据库主节点不接受读请求）； - 2，表示负载均衡模式（数据库主节点接受读请求）。
	RouteMode *int32 `json:"route_mode,omitempty"`

	// 数据库代理版本是否支持负载均衡模式。  取值范围: - true 支持; - false 不支持。
	BalanceRouteModeEnabled *bool `json:"balance_route_mode_enabled,omitempty"`

	// 一致性模式。默认值为空，此时以会话一致性参数session_consistence为准。 - session: 会话一致性。 - global: 全局一致性。 - eventual: 最终一致性。
	ConsistenceMode *string `json:"consistence_mode,omitempty"`

	// 数据库代理所属的子网ID。
	SubnetId *string `json:"subnet_id,omitempty"`

	// SSL数据加密开关设置。  取值范围： - true: 开启SSL数据加密。 - false: 关闭SSL数据加密。
	SslOption *string `json:"ssl_option,omitempty"`

	// 新增节点是否自动加入该Proxy。  取值范围： - ON：自动加入。 - OFF：不自动加入。
	NewNodeAutoAddStatus *string `json:"new_node_auto_add_status,omitempty"`

	// 新增节点的读权重。
	NewNodeWeight *int32 `json:"new_node_weight,omitempty"`
}

func (o MysqlProxyV3) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "MysqlProxyV3 struct{}"
	}

	return strings.Join([]string{"MysqlProxyV3", string(data)}, " ")
}

type MysqlProxyV3Type struct {
	value string
}

type MysqlProxyV3TypeEnum struct {
	READWRITE MysqlProxyV3Type
	READONLY  MysqlProxyV3Type
}

func GetMysqlProxyV3TypeEnum() MysqlProxyV3TypeEnum {
	return MysqlProxyV3TypeEnum{
		READWRITE: MysqlProxyV3Type{
			value: "readwrite",
		},
		READONLY: MysqlProxyV3Type{
			value: "readonly",
		},
	}
}

func (c MysqlProxyV3Type) Value() string {
	return c.value
}

func (c MysqlProxyV3Type) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *MysqlProxyV3Type) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
