package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type EnlargeReplicasetNodeRequestBody struct {

	// **参数解释：** 副本集节点扩容个数。 **约束限制：** 副本集有3个节点时，可以扩容2/4个节点，副本集有5个节点时，只能扩容2个。 **取值范围：** 不涉及。 **默认取值：** 不涉及。
	Num int32 `json:"num"`

	// **参数解释：** 变更包年包月实例规格时可指定，表示是否自动从账户中支付，此字段不影响自动续订的支付方式。 **约束限制：** - 对于降低规格场景，该字段无效。 - 对于扩大规格场景：   true，表示自动从账户中支付。   false，表示手动从账户中支付，默认为该方式。 **取值范围：** true和false。 **默认取值：** 不涉及。
	IsAutoPay *bool `json:"is_auto_pay,omitempty"`
}

func (o EnlargeReplicasetNodeRequestBody) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "EnlargeReplicasetNodeRequestBody struct{}"
	}

	return strings.Join([]string{"EnlargeReplicasetNodeRequestBody", string(data)}, " ")
}
