package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityDataObjectEnvironment 环境信息
type VulnerabilityDataObjectEnvironment struct {

	// 租户ID
	DomainId *string `json:"domain_id,omitempty"`

	// 租户名称
	DomainName *string `json:"domain_name,omitempty"`

	// 项目ID
	ProjectId *string `json:"project_id,omitempty"`

	// 区域ID
	RegionId *string `json:"region_id,omitempty"`

	// 区域名称
	RegionName *string `json:"region_name,omitempty"`

	// 厂商类型
	VendorType *string `json:"vendor_type,omitempty"`
}

func (o VulnerabilityDataObjectEnvironment) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDataObjectEnvironment struct{}"
	}

	return strings.Join([]string{"VulnerabilityDataObjectEnvironment", string(data)}, " ")
}
