// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package managedblockchainiface provides an interface to enable mocking the Amazon Managed Blockchain service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package managedblockchainiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/managedblockchain"
)

// ManagedBlockchainAPI provides an interface to enable mocking the
// managedblockchain.ManagedBlockchain service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Managed Blockchain.
//	func myFunc(svc managedblockchainiface.ManagedBlockchainAPI) bool {
//	    // Make svc.CreateMember request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := managedblockchain.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockManagedBlockchainClient struct {
//	    managedblockchainiface.ManagedBlockchainAPI
//	}
//	func (m *mockManagedBlockchainClient) CreateMember(input *managedblockchain.CreateMemberInput) (*managedblockchain.CreateMemberOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockManagedBlockchainClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ManagedBlockchainAPI interface {
	CreateMember(*managedblockchain.CreateMemberInput) (*managedblockchain.CreateMemberOutput, error)
	CreateMemberWithContext(aws.Context, *managedblockchain.CreateMemberInput, ...request.Option) (*managedblockchain.CreateMemberOutput, error)
	CreateMemberRequest(*managedblockchain.CreateMemberInput) (*request.Request, *managedblockchain.CreateMemberOutput)

	CreateNetwork(*managedblockchain.CreateNetworkInput) (*managedblockchain.CreateNetworkOutput, error)
	CreateNetworkWithContext(aws.Context, *managedblockchain.CreateNetworkInput, ...request.Option) (*managedblockchain.CreateNetworkOutput, error)
	CreateNetworkRequest(*managedblockchain.CreateNetworkInput) (*request.Request, *managedblockchain.CreateNetworkOutput)

	CreateNode(*managedblockchain.CreateNodeInput) (*managedblockchain.CreateNodeOutput, error)
	CreateNodeWithContext(aws.Context, *managedblockchain.CreateNodeInput, ...request.Option) (*managedblockchain.CreateNodeOutput, error)
	CreateNodeRequest(*managedblockchain.CreateNodeInput) (*request.Request, *managedblockchain.CreateNodeOutput)

	CreateProposal(*managedblockchain.CreateProposalInput) (*managedblockchain.CreateProposalOutput, error)
	CreateProposalWithContext(aws.Context, *managedblockchain.CreateProposalInput, ...request.Option) (*managedblockchain.CreateProposalOutput, error)
	CreateProposalRequest(*managedblockchain.CreateProposalInput) (*request.Request, *managedblockchain.CreateProposalOutput)

	DeleteMember(*managedblockchain.DeleteMemberInput) (*managedblockchain.DeleteMemberOutput, error)
	DeleteMemberWithContext(aws.Context, *managedblockchain.DeleteMemberInput, ...request.Option) (*managedblockchain.DeleteMemberOutput, error)
	DeleteMemberRequest(*managedblockchain.DeleteMemberInput) (*request.Request, *managedblockchain.DeleteMemberOutput)

	DeleteNode(*managedblockchain.DeleteNodeInput) (*managedblockchain.DeleteNodeOutput, error)
	DeleteNodeWithContext(aws.Context, *managedblockchain.DeleteNodeInput, ...request.Option) (*managedblockchain.DeleteNodeOutput, error)
	DeleteNodeRequest(*managedblockchain.DeleteNodeInput) (*request.Request, *managedblockchain.DeleteNodeOutput)

	GetMember(*managedblockchain.GetMemberInput) (*managedblockchain.GetMemberOutput, error)
	GetMemberWithContext(aws.Context, *managedblockchain.GetMemberInput, ...request.Option) (*managedblockchain.GetMemberOutput, error)
	GetMemberRequest(*managedblockchain.GetMemberInput) (*request.Request, *managedblockchain.GetMemberOutput)

	GetNetwork(*managedblockchain.GetNetworkInput) (*managedblockchain.GetNetworkOutput, error)
	GetNetworkWithContext(aws.Context, *managedblockchain.GetNetworkInput, ...request.Option) (*managedblockchain.GetNetworkOutput, error)
	GetNetworkRequest(*managedblockchain.GetNetworkInput) (*request.Request, *managedblockchain.GetNetworkOutput)

	GetNode(*managedblockchain.GetNodeInput) (*managedblockchain.GetNodeOutput, error)
	GetNodeWithContext(aws.Context, *managedblockchain.GetNodeInput, ...request.Option) (*managedblockchain.GetNodeOutput, error)
	GetNodeRequest(*managedblockchain.GetNodeInput) (*request.Request, *managedblockchain.GetNodeOutput)

	GetProposal(*managedblockchain.GetProposalInput) (*managedblockchain.GetProposalOutput, error)
	GetProposalWithContext(aws.Context, *managedblockchain.GetProposalInput, ...request.Option) (*managedblockchain.GetProposalOutput, error)
	GetProposalRequest(*managedblockchain.GetProposalInput) (*request.Request, *managedblockchain.GetProposalOutput)

	ListInvitations(*managedblockchain.ListInvitationsInput) (*managedblockchain.ListInvitationsOutput, error)
	ListInvitationsWithContext(aws.Context, *managedblockchain.ListInvitationsInput, ...request.Option) (*managedblockchain.ListInvitationsOutput, error)
	ListInvitationsRequest(*managedblockchain.ListInvitationsInput) (*request.Request, *managedblockchain.ListInvitationsOutput)

	ListInvitationsPages(*managedblockchain.ListInvitationsInput, func(*managedblockchain.ListInvitationsOutput, bool) bool) error
	ListInvitationsPagesWithContext(aws.Context, *managedblockchain.ListInvitationsInput, func(*managedblockchain.ListInvitationsOutput, bool) bool, ...request.Option) error

	ListMembers(*managedblockchain.ListMembersInput) (*managedblockchain.ListMembersOutput, error)
	ListMembersWithContext(aws.Context, *managedblockchain.ListMembersInput, ...request.Option) (*managedblockchain.ListMembersOutput, error)
	ListMembersRequest(*managedblockchain.ListMembersInput) (*request.Request, *managedblockchain.ListMembersOutput)

	ListMembersPages(*managedblockchain.ListMembersInput, func(*managedblockchain.ListMembersOutput, bool) bool) error
	ListMembersPagesWithContext(aws.Context, *managedblockchain.ListMembersInput, func(*managedblockchain.ListMembersOutput, bool) bool, ...request.Option) error

	ListNetworks(*managedblockchain.ListNetworksInput) (*managedblockchain.ListNetworksOutput, error)
	ListNetworksWithContext(aws.Context, *managedblockchain.ListNetworksInput, ...request.Option) (*managedblockchain.ListNetworksOutput, error)
	ListNetworksRequest(*managedblockchain.ListNetworksInput) (*request.Request, *managedblockchain.ListNetworksOutput)

	ListNetworksPages(*managedblockchain.ListNetworksInput, func(*managedblockchain.ListNetworksOutput, bool) bool) error
	ListNetworksPagesWithContext(aws.Context, *managedblockchain.ListNetworksInput, func(*managedblockchain.ListNetworksOutput, bool) bool, ...request.Option) error

	ListNodes(*managedblockchain.ListNodesInput) (*managedblockchain.ListNodesOutput, error)
	ListNodesWithContext(aws.Context, *managedblockchain.ListNodesInput, ...request.Option) (*managedblockchain.ListNodesOutput, error)
	ListNodesRequest(*managedblockchain.ListNodesInput) (*request.Request, *managedblockchain.ListNodesOutput)

	ListNodesPages(*managedblockchain.ListNodesInput, func(*managedblockchain.ListNodesOutput, bool) bool) error
	ListNodesPagesWithContext(aws.Context, *managedblockchain.ListNodesInput, func(*managedblockchain.ListNodesOutput, bool) bool, ...request.Option) error

	ListProposalVotes(*managedblockchain.ListProposalVotesInput) (*managedblockchain.ListProposalVotesOutput, error)
	ListProposalVotesWithContext(aws.Context, *managedblockchain.ListProposalVotesInput, ...request.Option) (*managedblockchain.ListProposalVotesOutput, error)
	ListProposalVotesRequest(*managedblockchain.ListProposalVotesInput) (*request.Request, *managedblockchain.ListProposalVotesOutput)

	ListProposalVotesPages(*managedblockchain.ListProposalVotesInput, func(*managedblockchain.ListProposalVotesOutput, bool) bool) error
	ListProposalVotesPagesWithContext(aws.Context, *managedblockchain.ListProposalVotesInput, func(*managedblockchain.ListProposalVotesOutput, bool) bool, ...request.Option) error

	ListProposals(*managedblockchain.ListProposalsInput) (*managedblockchain.ListProposalsOutput, error)
	ListProposalsWithContext(aws.Context, *managedblockchain.ListProposalsInput, ...request.Option) (*managedblockchain.ListProposalsOutput, error)
	ListProposalsRequest(*managedblockchain.ListProposalsInput) (*request.Request, *managedblockchain.ListProposalsOutput)

	ListProposalsPages(*managedblockchain.ListProposalsInput, func(*managedblockchain.ListProposalsOutput, bool) bool) error
	ListProposalsPagesWithContext(aws.Context, *managedblockchain.ListProposalsInput, func(*managedblockchain.ListProposalsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*managedblockchain.ListTagsForResourceInput) (*managedblockchain.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *managedblockchain.ListTagsForResourceInput, ...request.Option) (*managedblockchain.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*managedblockchain.ListTagsForResourceInput) (*request.Request, *managedblockchain.ListTagsForResourceOutput)

	RejectInvitation(*managedblockchain.RejectInvitationInput) (*managedblockchain.RejectInvitationOutput, error)
	RejectInvitationWithContext(aws.Context, *managedblockchain.RejectInvitationInput, ...request.Option) (*managedblockchain.RejectInvitationOutput, error)
	RejectInvitationRequest(*managedblockchain.RejectInvitationInput) (*request.Request, *managedblockchain.RejectInvitationOutput)

	TagResource(*managedblockchain.TagResourceInput) (*managedblockchain.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *managedblockchain.TagResourceInput, ...request.Option) (*managedblockchain.TagResourceOutput, error)
	TagResourceRequest(*managedblockchain.TagResourceInput) (*request.Request, *managedblockchain.TagResourceOutput)

	UntagResource(*managedblockchain.UntagResourceInput) (*managedblockchain.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *managedblockchain.UntagResourceInput, ...request.Option) (*managedblockchain.UntagResourceOutput, error)
	UntagResourceRequest(*managedblockchain.UntagResourceInput) (*request.Request, *managedblockchain.UntagResourceOutput)

	UpdateMember(*managedblockchain.UpdateMemberInput) (*managedblockchain.UpdateMemberOutput, error)
	UpdateMemberWithContext(aws.Context, *managedblockchain.UpdateMemberInput, ...request.Option) (*managedblockchain.UpdateMemberOutput, error)
	UpdateMemberRequest(*managedblockchain.UpdateMemberInput) (*request.Request, *managedblockchain.UpdateMemberOutput)

	UpdateNode(*managedblockchain.UpdateNodeInput) (*managedblockchain.UpdateNodeOutput, error)
	UpdateNodeWithContext(aws.Context, *managedblockchain.UpdateNodeInput, ...request.Option) (*managedblockchain.UpdateNodeOutput, error)
	UpdateNodeRequest(*managedblockchain.UpdateNodeInput) (*request.Request, *managedblockchain.UpdateNodeOutput)

	VoteOnProposal(*managedblockchain.VoteOnProposalInput) (*managedblockchain.VoteOnProposalOutput, error)
	VoteOnProposalWithContext(aws.Context, *managedblockchain.VoteOnProposalInput, ...request.Option) (*managedblockchain.VoteOnProposalOutput, error)
	VoteOnProposalRequest(*managedblockchain.VoteOnProposalInput) (*request.Request, *managedblockchain.VoteOnProposalOutput)
}

var _ ManagedBlockchainAPI = (*managedblockchain.ManagedBlockchain)(nil)
