// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/storagetransfer/v1/transfer.proto

package storagetransferpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	StorageTransferService_GetGoogleServiceAccount_FullMethodName = "/google.storagetransfer.v1.StorageTransferService/GetGoogleServiceAccount"
	StorageTransferService_CreateTransferJob_FullMethodName       = "/google.storagetransfer.v1.StorageTransferService/CreateTransferJob"
	StorageTransferService_UpdateTransferJob_FullMethodName       = "/google.storagetransfer.v1.StorageTransferService/UpdateTransferJob"
	StorageTransferService_GetTransferJob_FullMethodName          = "/google.storagetransfer.v1.StorageTransferService/GetTransferJob"
	StorageTransferService_ListTransferJobs_FullMethodName        = "/google.storagetransfer.v1.StorageTransferService/ListTransferJobs"
	StorageTransferService_PauseTransferOperation_FullMethodName  = "/google.storagetransfer.v1.StorageTransferService/PauseTransferOperation"
	StorageTransferService_ResumeTransferOperation_FullMethodName = "/google.storagetransfer.v1.StorageTransferService/ResumeTransferOperation"
	StorageTransferService_RunTransferJob_FullMethodName          = "/google.storagetransfer.v1.StorageTransferService/RunTransferJob"
	StorageTransferService_DeleteTransferJob_FullMethodName       = "/google.storagetransfer.v1.StorageTransferService/DeleteTransferJob"
	StorageTransferService_CreateAgentPool_FullMethodName         = "/google.storagetransfer.v1.StorageTransferService/CreateAgentPool"
	StorageTransferService_UpdateAgentPool_FullMethodName         = "/google.storagetransfer.v1.StorageTransferService/UpdateAgentPool"
	StorageTransferService_GetAgentPool_FullMethodName            = "/google.storagetransfer.v1.StorageTransferService/GetAgentPool"
	StorageTransferService_ListAgentPools_FullMethodName          = "/google.storagetransfer.v1.StorageTransferService/ListAgentPools"
	StorageTransferService_DeleteAgentPool_FullMethodName         = "/google.storagetransfer.v1.StorageTransferService/DeleteAgentPool"
)

// StorageTransferServiceClient is the client API for StorageTransferService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StorageTransferServiceClient interface {
	// Returns the Google service account that is used by Storage Transfer
	// Service to access buckets in the project where transfers
	// run or in other projects. Each Google service account is associated
	// with one Google Cloud project. Users
	// should add this service account to the Google Cloud Storage bucket
	// ACLs to grant access to Storage Transfer Service. This service
	// account is created and owned by Storage Transfer Service and can
	// only be used by Storage Transfer Service.
	GetGoogleServiceAccount(ctx context.Context, in *GetGoogleServiceAccountRequest, opts ...grpc.CallOption) (*GoogleServiceAccount, error)
	// Creates a transfer job that runs periodically.
	CreateTransferJob(ctx context.Context, in *CreateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Updates a transfer job. Updating a job's transfer spec does not affect
	// transfer operations that are running already.
	//
	// **Note:** The job's [status][google.storagetransfer.v1.TransferJob.status]
	// field can be modified using this RPC (for example, to set a job's status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED],
	// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], or
	// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED]).
	UpdateTransferJob(ctx context.Context, in *UpdateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Gets a transfer job.
	GetTransferJob(ctx context.Context, in *GetTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error)
	// Lists transfer jobs.
	ListTransferJobs(ctx context.Context, in *ListTransferJobsRequest, opts ...grpc.CallOption) (*ListTransferJobsResponse, error)
	// Pauses a transfer operation.
	PauseTransferOperation(ctx context.Context, in *PauseTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Resumes a transfer operation that is paused.
	ResumeTransferOperation(ctx context.Context, in *ResumeTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts a new operation for the specified transfer job.
	// A `TransferJob` has a maximum of one active `TransferOperation`. If this
	// method is called while a `TransferOperation` is active, an error is
	// returned.
	RunTransferJob(ctx context.Context, in *RunTransferJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a transfer job. Deleting a transfer job sets its status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
	DeleteTransferJob(ctx context.Context, in *DeleteTransferJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates an agent pool resource.
	CreateAgentPool(ctx context.Context, in *CreateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error)
	// Updates an existing agent pool resource.
	UpdateAgentPool(ctx context.Context, in *UpdateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error)
	// Gets an agent pool.
	GetAgentPool(ctx context.Context, in *GetAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error)
	// Lists agent pools.
	ListAgentPools(ctx context.Context, in *ListAgentPoolsRequest, opts ...grpc.CallOption) (*ListAgentPoolsResponse, error)
	// Deletes an agent pool.
	DeleteAgentPool(ctx context.Context, in *DeleteAgentPoolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type storageTransferServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageTransferServiceClient(cc grpc.ClientConnInterface) StorageTransferServiceClient {
	return &storageTransferServiceClient{cc}
}

func (c *storageTransferServiceClient) GetGoogleServiceAccount(ctx context.Context, in *GetGoogleServiceAccountRequest, opts ...grpc.CallOption) (*GoogleServiceAccount, error) {
	out := new(GoogleServiceAccount)
	err := c.cc.Invoke(ctx, StorageTransferService_GetGoogleServiceAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) CreateTransferJob(ctx context.Context, in *CreateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := c.cc.Invoke(ctx, StorageTransferService_CreateTransferJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) UpdateTransferJob(ctx context.Context, in *UpdateTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := c.cc.Invoke(ctx, StorageTransferService_UpdateTransferJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) GetTransferJob(ctx context.Context, in *GetTransferJobRequest, opts ...grpc.CallOption) (*TransferJob, error) {
	out := new(TransferJob)
	err := c.cc.Invoke(ctx, StorageTransferService_GetTransferJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ListTransferJobs(ctx context.Context, in *ListTransferJobsRequest, opts ...grpc.CallOption) (*ListTransferJobsResponse, error) {
	out := new(ListTransferJobsResponse)
	err := c.cc.Invoke(ctx, StorageTransferService_ListTransferJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) PauseTransferOperation(ctx context.Context, in *PauseTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, StorageTransferService_PauseTransferOperation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ResumeTransferOperation(ctx context.Context, in *ResumeTransferOperationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, StorageTransferService_ResumeTransferOperation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) RunTransferJob(ctx context.Context, in *RunTransferJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, StorageTransferService_RunTransferJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) DeleteTransferJob(ctx context.Context, in *DeleteTransferJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, StorageTransferService_DeleteTransferJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) CreateAgentPool(ctx context.Context, in *CreateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error) {
	out := new(AgentPool)
	err := c.cc.Invoke(ctx, StorageTransferService_CreateAgentPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) UpdateAgentPool(ctx context.Context, in *UpdateAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error) {
	out := new(AgentPool)
	err := c.cc.Invoke(ctx, StorageTransferService_UpdateAgentPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) GetAgentPool(ctx context.Context, in *GetAgentPoolRequest, opts ...grpc.CallOption) (*AgentPool, error) {
	out := new(AgentPool)
	err := c.cc.Invoke(ctx, StorageTransferService_GetAgentPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) ListAgentPools(ctx context.Context, in *ListAgentPoolsRequest, opts ...grpc.CallOption) (*ListAgentPoolsResponse, error) {
	out := new(ListAgentPoolsResponse)
	err := c.cc.Invoke(ctx, StorageTransferService_ListAgentPools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageTransferServiceClient) DeleteAgentPool(ctx context.Context, in *DeleteAgentPoolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, StorageTransferService_DeleteAgentPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageTransferServiceServer is the server API for StorageTransferService service.
// All implementations should embed UnimplementedStorageTransferServiceServer
// for forward compatibility
type StorageTransferServiceServer interface {
	// Returns the Google service account that is used by Storage Transfer
	// Service to access buckets in the project where transfers
	// run or in other projects. Each Google service account is associated
	// with one Google Cloud project. Users
	// should add this service account to the Google Cloud Storage bucket
	// ACLs to grant access to Storage Transfer Service. This service
	// account is created and owned by Storage Transfer Service and can
	// only be used by Storage Transfer Service.
	GetGoogleServiceAccount(context.Context, *GetGoogleServiceAccountRequest) (*GoogleServiceAccount, error)
	// Creates a transfer job that runs periodically.
	CreateTransferJob(context.Context, *CreateTransferJobRequest) (*TransferJob, error)
	// Updates a transfer job. Updating a job's transfer spec does not affect
	// transfer operations that are running already.
	//
	// **Note:** The job's [status][google.storagetransfer.v1.TransferJob.status]
	// field can be modified using this RPC (for example, to set a job's status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED],
	// [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], or
	// [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED]).
	UpdateTransferJob(context.Context, *UpdateTransferJobRequest) (*TransferJob, error)
	// Gets a transfer job.
	GetTransferJob(context.Context, *GetTransferJobRequest) (*TransferJob, error)
	// Lists transfer jobs.
	ListTransferJobs(context.Context, *ListTransferJobsRequest) (*ListTransferJobsResponse, error)
	// Pauses a transfer operation.
	PauseTransferOperation(context.Context, *PauseTransferOperationRequest) (*emptypb.Empty, error)
	// Resumes a transfer operation that is paused.
	ResumeTransferOperation(context.Context, *ResumeTransferOperationRequest) (*emptypb.Empty, error)
	// Starts a new operation for the specified transfer job.
	// A `TransferJob` has a maximum of one active `TransferOperation`. If this
	// method is called while a `TransferOperation` is active, an error is
	// returned.
	RunTransferJob(context.Context, *RunTransferJobRequest) (*longrunningpb.Operation, error)
	// Deletes a transfer job. Deleting a transfer job sets its status to
	// [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
	DeleteTransferJob(context.Context, *DeleteTransferJobRequest) (*emptypb.Empty, error)
	// Creates an agent pool resource.
	CreateAgentPool(context.Context, *CreateAgentPoolRequest) (*AgentPool, error)
	// Updates an existing agent pool resource.
	UpdateAgentPool(context.Context, *UpdateAgentPoolRequest) (*AgentPool, error)
	// Gets an agent pool.
	GetAgentPool(context.Context, *GetAgentPoolRequest) (*AgentPool, error)
	// Lists agent pools.
	ListAgentPools(context.Context, *ListAgentPoolsRequest) (*ListAgentPoolsResponse, error)
	// Deletes an agent pool.
	DeleteAgentPool(context.Context, *DeleteAgentPoolRequest) (*emptypb.Empty, error)
}

// UnimplementedStorageTransferServiceServer should be embedded to have forward compatible implementations.
type UnimplementedStorageTransferServiceServer struct {
}

func (UnimplementedStorageTransferServiceServer) GetGoogleServiceAccount(context.Context, *GetGoogleServiceAccountRequest) (*GoogleServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleServiceAccount not implemented")
}
func (UnimplementedStorageTransferServiceServer) CreateTransferJob(context.Context, *CreateTransferJobRequest) (*TransferJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTransferJob not implemented")
}
func (UnimplementedStorageTransferServiceServer) UpdateTransferJob(context.Context, *UpdateTransferJobRequest) (*TransferJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTransferJob not implemented")
}
func (UnimplementedStorageTransferServiceServer) GetTransferJob(context.Context, *GetTransferJobRequest) (*TransferJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransferJob not implemented")
}
func (UnimplementedStorageTransferServiceServer) ListTransferJobs(context.Context, *ListTransferJobsRequest) (*ListTransferJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransferJobs not implemented")
}
func (UnimplementedStorageTransferServiceServer) PauseTransferOperation(context.Context, *PauseTransferOperationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseTransferOperation not implemented")
}
func (UnimplementedStorageTransferServiceServer) ResumeTransferOperation(context.Context, *ResumeTransferOperationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeTransferOperation not implemented")
}
func (UnimplementedStorageTransferServiceServer) RunTransferJob(context.Context, *RunTransferJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunTransferJob not implemented")
}
func (UnimplementedStorageTransferServiceServer) DeleteTransferJob(context.Context, *DeleteTransferJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTransferJob not implemented")
}
func (UnimplementedStorageTransferServiceServer) CreateAgentPool(context.Context, *CreateAgentPoolRequest) (*AgentPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAgentPool not implemented")
}
func (UnimplementedStorageTransferServiceServer) UpdateAgentPool(context.Context, *UpdateAgentPoolRequest) (*AgentPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAgentPool not implemented")
}
func (UnimplementedStorageTransferServiceServer) GetAgentPool(context.Context, *GetAgentPoolRequest) (*AgentPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgentPool not implemented")
}
func (UnimplementedStorageTransferServiceServer) ListAgentPools(context.Context, *ListAgentPoolsRequest) (*ListAgentPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAgentPools not implemented")
}
func (UnimplementedStorageTransferServiceServer) DeleteAgentPool(context.Context, *DeleteAgentPoolRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgentPool not implemented")
}

// UnsafeStorageTransferServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageTransferServiceServer will
// result in compilation errors.
type UnsafeStorageTransferServiceServer interface {
	mustEmbedUnimplementedStorageTransferServiceServer()
}

func RegisterStorageTransferServiceServer(s grpc.ServiceRegistrar, srv StorageTransferServiceServer) {
	s.RegisterService(&StorageTransferService_ServiceDesc, srv)
}

func _StorageTransferService_GetGoogleServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetGoogleServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_GetGoogleServiceAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetGoogleServiceAccount(ctx, req.(*GetGoogleServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_CreateTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).CreateTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_CreateTransferJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).CreateTransferJob(ctx, req.(*CreateTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_UpdateTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).UpdateTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_UpdateTransferJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).UpdateTransferJob(ctx, req.(*UpdateTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_GetTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_GetTransferJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetTransferJob(ctx, req.(*GetTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ListTransferJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ListTransferJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_ListTransferJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ListTransferJobs(ctx, req.(*ListTransferJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_PauseTransferOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseTransferOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).PauseTransferOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_PauseTransferOperation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).PauseTransferOperation(ctx, req.(*PauseTransferOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ResumeTransferOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeTransferOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ResumeTransferOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_ResumeTransferOperation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ResumeTransferOperation(ctx, req.(*ResumeTransferOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_RunTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).RunTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_RunTransferJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).RunTransferJob(ctx, req.(*RunTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_DeleteTransferJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).DeleteTransferJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_DeleteTransferJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).DeleteTransferJob(ctx, req.(*DeleteTransferJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_CreateAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).CreateAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_CreateAgentPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).CreateAgentPool(ctx, req.(*CreateAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_UpdateAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).UpdateAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_UpdateAgentPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).UpdateAgentPool(ctx, req.(*UpdateAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_GetAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).GetAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_GetAgentPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).GetAgentPool(ctx, req.(*GetAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_ListAgentPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAgentPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).ListAgentPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_ListAgentPools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).ListAgentPools(ctx, req.(*ListAgentPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageTransferService_DeleteAgentPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageTransferServiceServer).DeleteAgentPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StorageTransferService_DeleteAgentPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageTransferServiceServer).DeleteAgentPool(ctx, req.(*DeleteAgentPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// StorageTransferService_ServiceDesc is the grpc.ServiceDesc for StorageTransferService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StorageTransferService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.storagetransfer.v1.StorageTransferService",
	HandlerType: (*StorageTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGoogleServiceAccount",
			Handler:    _StorageTransferService_GetGoogleServiceAccount_Handler,
		},
		{
			MethodName: "CreateTransferJob",
			Handler:    _StorageTransferService_CreateTransferJob_Handler,
		},
		{
			MethodName: "UpdateTransferJob",
			Handler:    _StorageTransferService_UpdateTransferJob_Handler,
		},
		{
			MethodName: "GetTransferJob",
			Handler:    _StorageTransferService_GetTransferJob_Handler,
		},
		{
			MethodName: "ListTransferJobs",
			Handler:    _StorageTransferService_ListTransferJobs_Handler,
		},
		{
			MethodName: "PauseTransferOperation",
			Handler:    _StorageTransferService_PauseTransferOperation_Handler,
		},
		{
			MethodName: "ResumeTransferOperation",
			Handler:    _StorageTransferService_ResumeTransferOperation_Handler,
		},
		{
			MethodName: "RunTransferJob",
			Handler:    _StorageTransferService_RunTransferJob_Handler,
		},
		{
			MethodName: "DeleteTransferJob",
			Handler:    _StorageTransferService_DeleteTransferJob_Handler,
		},
		{
			MethodName: "CreateAgentPool",
			Handler:    _StorageTransferService_CreateAgentPool_Handler,
		},
		{
			MethodName: "UpdateAgentPool",
			Handler:    _StorageTransferService_UpdateAgentPool_Handler,
		},
		{
			MethodName: "GetAgentPool",
			Handler:    _StorageTransferService_GetAgentPool_Handler,
		},
		{
			MethodName: "ListAgentPools",
			Handler:    _StorageTransferService_ListAgentPools_Handler,
		},
		{
			MethodName: "DeleteAgentPool",
			Handler:    _StorageTransferService_DeleteAgentPool_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/storagetransfer/v1/transfer.proto",
}
