// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

package networkconnectivitypb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PolicyBasedRoutingService_ListPolicyBasedRoutes_FullMethodName  = "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/ListPolicyBasedRoutes"
	PolicyBasedRoutingService_GetPolicyBasedRoute_FullMethodName    = "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/GetPolicyBasedRoute"
	PolicyBasedRoutingService_CreatePolicyBasedRoute_FullMethodName = "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/CreatePolicyBasedRoute"
	PolicyBasedRoutingService_DeletePolicyBasedRoute_FullMethodName = "/google.cloud.networkconnectivity.v1.PolicyBasedRoutingService/DeletePolicyBasedRoute"
)

// PolicyBasedRoutingServiceClient is the client API for PolicyBasedRoutingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PolicyBasedRoutingServiceClient interface {
	// Lists policy-based routes in a given project and location.
	ListPolicyBasedRoutes(ctx context.Context, in *ListPolicyBasedRoutesRequest, opts ...grpc.CallOption) (*ListPolicyBasedRoutesResponse, error)
	// Gets details of a single policy-based route.
	GetPolicyBasedRoute(ctx context.Context, in *GetPolicyBasedRouteRequest, opts ...grpc.CallOption) (*PolicyBasedRoute, error)
	// Creates a new policy-based route in a given project and location.
	CreatePolicyBasedRoute(ctx context.Context, in *CreatePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single policy-based route.
	DeletePolicyBasedRoute(ctx context.Context, in *DeletePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type policyBasedRoutingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyBasedRoutingServiceClient(cc grpc.ClientConnInterface) PolicyBasedRoutingServiceClient {
	return &policyBasedRoutingServiceClient{cc}
}

func (c *policyBasedRoutingServiceClient) ListPolicyBasedRoutes(ctx context.Context, in *ListPolicyBasedRoutesRequest, opts ...grpc.CallOption) (*ListPolicyBasedRoutesResponse, error) {
	out := new(ListPolicyBasedRoutesResponse)
	err := c.cc.Invoke(ctx, PolicyBasedRoutingService_ListPolicyBasedRoutes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBasedRoutingServiceClient) GetPolicyBasedRoute(ctx context.Context, in *GetPolicyBasedRouteRequest, opts ...grpc.CallOption) (*PolicyBasedRoute, error) {
	out := new(PolicyBasedRoute)
	err := c.cc.Invoke(ctx, PolicyBasedRoutingService_GetPolicyBasedRoute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBasedRoutingServiceClient) CreatePolicyBasedRoute(ctx context.Context, in *CreatePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PolicyBasedRoutingService_CreatePolicyBasedRoute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyBasedRoutingServiceClient) DeletePolicyBasedRoute(ctx context.Context, in *DeletePolicyBasedRouteRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PolicyBasedRoutingService_DeletePolicyBasedRoute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyBasedRoutingServiceServer is the server API for PolicyBasedRoutingService service.
// All implementations should embed UnimplementedPolicyBasedRoutingServiceServer
// for forward compatibility
type PolicyBasedRoutingServiceServer interface {
	// Lists policy-based routes in a given project and location.
	ListPolicyBasedRoutes(context.Context, *ListPolicyBasedRoutesRequest) (*ListPolicyBasedRoutesResponse, error)
	// Gets details of a single policy-based route.
	GetPolicyBasedRoute(context.Context, *GetPolicyBasedRouteRequest) (*PolicyBasedRoute, error)
	// Creates a new policy-based route in a given project and location.
	CreatePolicyBasedRoute(context.Context, *CreatePolicyBasedRouteRequest) (*longrunningpb.Operation, error)
	// Deletes a single policy-based route.
	DeletePolicyBasedRoute(context.Context, *DeletePolicyBasedRouteRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPolicyBasedRoutingServiceServer should be embedded to have forward compatible implementations.
type UnimplementedPolicyBasedRoutingServiceServer struct {
}

func (UnimplementedPolicyBasedRoutingServiceServer) ListPolicyBasedRoutes(context.Context, *ListPolicyBasedRoutesRequest) (*ListPolicyBasedRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicyBasedRoutes not implemented")
}
func (UnimplementedPolicyBasedRoutingServiceServer) GetPolicyBasedRoute(context.Context, *GetPolicyBasedRouteRequest) (*PolicyBasedRoute, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicyBasedRoute not implemented")
}
func (UnimplementedPolicyBasedRoutingServiceServer) CreatePolicyBasedRoute(context.Context, *CreatePolicyBasedRouteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicyBasedRoute not implemented")
}
func (UnimplementedPolicyBasedRoutingServiceServer) DeletePolicyBasedRoute(context.Context, *DeletePolicyBasedRouteRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicyBasedRoute not implemented")
}

// UnsafePolicyBasedRoutingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PolicyBasedRoutingServiceServer will
// result in compilation errors.
type UnsafePolicyBasedRoutingServiceServer interface {
	mustEmbedUnimplementedPolicyBasedRoutingServiceServer()
}

func RegisterPolicyBasedRoutingServiceServer(s grpc.ServiceRegistrar, srv PolicyBasedRoutingServiceServer) {
	s.RegisterService(&PolicyBasedRoutingService_ServiceDesc, srv)
}

func _PolicyBasedRoutingService_ListPolicyBasedRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPolicyBasedRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).ListPolicyBasedRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBasedRoutingService_ListPolicyBasedRoutes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).ListPolicyBasedRoutes(ctx, req.(*ListPolicyBasedRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBasedRoutingService_GetPolicyBasedRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyBasedRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).GetPolicyBasedRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBasedRoutingService_GetPolicyBasedRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).GetPolicyBasedRoute(ctx, req.(*GetPolicyBasedRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBasedRoutingService_CreatePolicyBasedRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyBasedRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).CreatePolicyBasedRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBasedRoutingService_CreatePolicyBasedRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).CreatePolicyBasedRoute(ctx, req.(*CreatePolicyBasedRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyBasedRoutingService_DeletePolicyBasedRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyBasedRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyBasedRoutingServiceServer).DeletePolicyBasedRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyBasedRoutingService_DeletePolicyBasedRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyBasedRoutingServiceServer).DeletePolicyBasedRoute(ctx, req.(*DeletePolicyBasedRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PolicyBasedRoutingService_ServiceDesc is the grpc.ServiceDesc for PolicyBasedRoutingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PolicyBasedRoutingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.PolicyBasedRoutingService",
	HandlerType: (*PolicyBasedRoutingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPolicyBasedRoutes",
			Handler:    _PolicyBasedRoutingService_ListPolicyBasedRoutes_Handler,
		},
		{
			MethodName: "GetPolicyBasedRoute",
			Handler:    _PolicyBasedRoutingService_GetPolicyBasedRoute_Handler,
		},
		{
			MethodName: "CreatePolicyBasedRoute",
			Handler:    _PolicyBasedRoutingService_CreatePolicyBasedRoute_Handler,
		},
		{
			MethodName: "DeletePolicyBasedRoute",
			Handler:    _PolicyBasedRoutingService_DeletePolicyBasedRoute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/policy_based_routing.proto",
}
