/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
	"fmt"
)

// CreateNewDataStreamingRequest - struct for CreateNewDataStreamingRequest
type CreateNewDataStreamingRequest struct {
	CustomDataStreamingPostBody *CustomDataStreamingPostBody
	DataStreamingPostBody *DataStreamingPostBody
	StandardDataStreamingPostBody *StandardDataStreamingPostBody
}

// CustomDataStreamingPostBodyAsCreateNewDataStreamingRequest is a convenience function that returns CustomDataStreamingPostBody wrapped in CreateNewDataStreamingRequest
func CustomDataStreamingPostBodyAsCreateNewDataStreamingRequest(v *CustomDataStreamingPostBody) CreateNewDataStreamingRequest {
	return CreateNewDataStreamingRequest{
		CustomDataStreamingPostBody: v,
	}
}

// DataStreamingPostBodyAsCreateNewDataStreamingRequest is a convenience function that returns DataStreamingPostBody wrapped in CreateNewDataStreamingRequest
func DataStreamingPostBodyAsCreateNewDataStreamingRequest(v *DataStreamingPostBody) CreateNewDataStreamingRequest {
	return CreateNewDataStreamingRequest{
		DataStreamingPostBody: v,
	}
}

// StandardDataStreamingPostBodyAsCreateNewDataStreamingRequest is a convenience function that returns StandardDataStreamingPostBody wrapped in CreateNewDataStreamingRequest
func StandardDataStreamingPostBodyAsCreateNewDataStreamingRequest(v *StandardDataStreamingPostBody) CreateNewDataStreamingRequest {
	return CreateNewDataStreamingRequest{
		StandardDataStreamingPostBody: v,
	}
}


// Unmarshal JSON data into one of the pointers in the struct
func (dst *CreateNewDataStreamingRequest) UnmarshalJSON(data []byte) error {
	var err error
	match := 0
	// try to unmarshal data into CustomDataStreamingPostBody
	err = newStrictDecoder(data).Decode(&dst.CustomDataStreamingPostBody)
	if err == nil {
		jsonCustomDataStreamingPostBody, _ := json.Marshal(dst.CustomDataStreamingPostBody)
		if string(jsonCustomDataStreamingPostBody) == "{}" { // empty struct
			dst.CustomDataStreamingPostBody = nil
		} else {
			match++
		}
	} else {
		dst.CustomDataStreamingPostBody = nil
	}

	// try to unmarshal data into DataStreamingPostBody
	err = newStrictDecoder(data).Decode(&dst.DataStreamingPostBody)
	if err == nil {
		jsonDataStreamingPostBody, _ := json.Marshal(dst.DataStreamingPostBody)
		if string(jsonDataStreamingPostBody) == "{}" { // empty struct
			dst.DataStreamingPostBody = nil
		} else {
			match++
		}
	} else {
		dst.DataStreamingPostBody = nil
	}

	// try to unmarshal data into StandardDataStreamingPostBody
	err = newStrictDecoder(data).Decode(&dst.StandardDataStreamingPostBody)
	if err == nil {
		jsonStandardDataStreamingPostBody, _ := json.Marshal(dst.StandardDataStreamingPostBody)
		if string(jsonStandardDataStreamingPostBody) == "{}" { // empty struct
			dst.StandardDataStreamingPostBody = nil
		} else {
			match++
		}
	} else {
		dst.StandardDataStreamingPostBody = nil
	}

	if match > 1 { // more than 1 match
		// reset to nil
		dst.CustomDataStreamingPostBody = nil
		dst.DataStreamingPostBody = nil
		dst.StandardDataStreamingPostBody = nil

		return fmt.Errorf("data matches more than one schema in oneOf(CreateNewDataStreamingRequest)")
	} else if match == 1 {
		return nil // exactly one match
	} else { // no match
		return fmt.Errorf("data failed to match schemas in oneOf(CreateNewDataStreamingRequest)")
	}
}

// Marshal data from the first non-nil pointers in the struct to JSON
func (src CreateNewDataStreamingRequest) MarshalJSON() ([]byte, error) {
	if src.CustomDataStreamingPostBody != nil {
		return json.Marshal(&src.CustomDataStreamingPostBody)
	}

	if src.DataStreamingPostBody != nil {
		return json.Marshal(&src.DataStreamingPostBody)
	}

	if src.StandardDataStreamingPostBody != nil {
		return json.Marshal(&src.StandardDataStreamingPostBody)
	}

	return nil, nil // no data in oneOf schemas
}

// Get the actual instance
func (obj *CreateNewDataStreamingRequest) GetActualInstance() (interface{}) {
	if obj == nil {
		return nil
	}
	if obj.CustomDataStreamingPostBody != nil {
		return obj.CustomDataStreamingPostBody
	}

	if obj.DataStreamingPostBody != nil {
		return obj.DataStreamingPostBody
	}

	if obj.StandardDataStreamingPostBody != nil {
		return obj.StandardDataStreamingPostBody
	}

	// all schemas are nil
	return nil
}

type NullableCreateNewDataStreamingRequest struct {
	value *CreateNewDataStreamingRequest
	isSet bool
}

func (v NullableCreateNewDataStreamingRequest) Get() *CreateNewDataStreamingRequest {
	return v.value
}

func (v *NullableCreateNewDataStreamingRequest) Set(val *CreateNewDataStreamingRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateNewDataStreamingRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateNewDataStreamingRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateNewDataStreamingRequest(val *CreateNewDataStreamingRequest) *NullableCreateNewDataStreamingRequest {
	return &NullableCreateNewDataStreamingRequest{value: val, isSet: true}
}

func (v NullableCreateNewDataStreamingRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateNewDataStreamingRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


