# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_fw_high_availability__ha_groups_ha_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Config container for HA parameters
  """
  __slots__ = ('_path_helper', '_extmethods', '__ha_enabled','__ha_mode','__ha_key','__ha_key_hashed','__ha_msg_encryption','__id','__ha_device_id','__preempt','__priority','__preempt_hold_timer','__hello_interval','__global_health_policy',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ha_enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)
    self.__ha_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)
    self.__ha_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=True)
    self.__ha_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    self.__ha_msg_encryption = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)
    self.__ha_device_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)
    self.__preempt = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)
    self.__preempt_hold_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)
    self.__hello_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)
    self.__global_health_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'config']

  def _get_ha_enabled(self):
    """
    Getter method for ha_enabled, mapped from YANG variable /ha_groups/ha_group/config/ha_enabled (boolean)

    YANG Description: This must be set to 'true' to initiate firewall participation
in a HA cluster. Once set to 'true', this boolean can be
flipped to 'false' to DISABLE HA and put a unit in a
'suspended' state while retaining all other HA settings &
configuration parameters. At the same time the 'ha-state' leaf
under 'ha-parameters-state' must then be updated to
'SUSPENDED'
    """
    return self.__ha_enabled
      
  def _set_ha_enabled(self, v, load=False):
    """
    Setter method for ha_enabled, mapped from YANG variable /ha_groups/ha_group/config/ha_enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_enabled() directly.

    YANG Description: This must be set to 'true' to initiate firewall participation
in a HA cluster. Once set to 'true', this boolean can be
flipped to 'false' to DISABLE HA and put a unit in a
'suspended' state while retaining all other HA settings &
configuration parameters. At the same time the 'ha-state' leaf
under 'ha-parameters-state' must then be updated to
'SUSPENDED'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)""",
        })

    self.__ha_enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_enabled(self):
    self.__ha_enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)


  def _get_ha_mode(self):
    """
    Getter method for ha_mode, mapped from YANG variable /ha_groups/ha_group/config/ha_mode (enumeration)

    YANG Description: Configurable HA modes
    """
    return self.__ha_mode
      
  def _set_ha_mode(self, v, load=False):
    """
    Setter method for ha_mode, mapped from YANG variable /ha_groups/ha_group/config/ha_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_mode() directly.

    YANG Description: Configurable HA modes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)""",
        })

    self.__ha_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_mode(self):
    self.__ha_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)


  def _get_ha_key(self):
    """
    Getter method for ha_key, mapped from YANG variable /ha_groups/ha_group/config/ha_key (string)

    YANG Description: HA key used to encrypt & authenticate HA messages betwen
the peers. This is provided in clear-text by the client &
expected to be hashed by the firewall in the configuration
    """
    return self.__ha_key
      
  def _set_ha_key(self, v, load=False):
    """
    Setter method for ha_key, mapped from YANG variable /ha_groups/ha_group/config/ha_key (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_key() directly.

    YANG Description: HA key used to encrypt & authenticate HA messages betwen
the peers. This is provided in clear-text by the client &
expected to be hashed by the firewall in the configuration
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_key must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=True)""",
        })

    self.__ha_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_key(self):
    self.__ha_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=True)


  def _get_ha_key_hashed(self):
    """
    Getter method for ha_key_hashed, mapped from YANG variable /ha_groups/ha_group/config/ha_key_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: HA key,used to encrypt & authenticate HA messages between
the peers, supplied as a hashed value using the notation
     described in the definition of the crypt-password-type
    """
    return self.__ha_key_hashed
      
  def _set_ha_key_hashed(self, v, load=False):
    """
    Setter method for ha_key_hashed, mapped from YANG variable /ha_groups/ha_group/config/ha_key_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_key_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_key_hashed() directly.

    YANG Description: HA key,used to encrypt & authenticate HA messages between
the peers, supplied as a hashed value using the notation
     described in the definition of the crypt-password-type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_key_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=True)""",
        })

    self.__ha_key_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_key_hashed(self):
    self.__ha_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=True)


  def _get_ha_msg_encryption(self):
    """
    Getter method for ha_msg_encryption, mapped from YANG variable /ha_groups/ha_group/config/ha_msg_encryption (boolean)

    YANG Description: When set to true all traffic between firewall units in a HA
cluster are encrypted. If operator provided encryption key is
supported, that value must be derived from the
ha-key/ha-key-hashed leaf nodes. If that is not supported, the
vendor is expected to derive it's own keying material
    """
    return self.__ha_msg_encryption
      
  def _set_ha_msg_encryption(self, v, load=False):
    """
    Setter method for ha_msg_encryption, mapped from YANG variable /ha_groups/ha_group/config/ha_msg_encryption (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_msg_encryption is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_msg_encryption() directly.

    YANG Description: When set to true all traffic between firewall units in a HA
cluster are encrypted. If operator provided encryption key is
supported, that value must be derived from the
ha-key/ha-key-hashed leaf nodes. If that is not supported, the
vendor is expected to derive it's own keying material
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_msg_encryption must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)""",
        })

    self.__ha_msg_encryption = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_msg_encryption(self):
    self.__ha_msg_encryption = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /ha_groups/ha_group/config/id (uint8)

    YANG Description: The high availbility group id for a unit. This value MUST
match across both units participating in a HA cluster
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /ha_groups/ha_group/config/id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: The high availbility group id for a unit. This value MUST
match across both units participating in a HA cluster
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)


  def _get_ha_device_id(self):
    """
    Getter method for ha_device_id, mapped from YANG variable /ha_groups/ha_group/config/ha_device_id (uint8)

    YANG Description: Specify the device-id to identify the firewall within a HA
group. This value MUST be unique to the local-unit and MUST
NOT clash with the peer within a ha-group
    """
    return self.__ha_device_id
      
  def _set_ha_device_id(self, v, load=False):
    """
    Setter method for ha_device_id, mapped from YANG variable /ha_groups/ha_group/config/ha_device_id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_device_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_device_id() directly.

    YANG Description: Specify the device-id to identify the firewall within a HA
group. This value MUST be unique to the local-unit and MUST
NOT clash with the peer within a ha-group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_device_id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)""",
        })

    self.__ha_device_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_device_id(self):
    self.__ha_device_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)


  def _get_preempt(self):
    """
    Getter method for preempt, mapped from YANG variable /ha_groups/ha_group/config/preempt (boolean)

    YANG Description: When set to true the firewall forces reelection of the active
role after joining the cluster
    """
    return self.__preempt
      
  def _set_preempt(self, v, load=False):
    """
    Setter method for preempt, mapped from YANG variable /ha_groups/ha_group/config/preempt (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_preempt is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_preempt() directly.

    YANG Description: When set to true the firewall forces reelection of the active
role after joining the cluster
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """preempt must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)""",
        })

    self.__preempt = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_preempt(self):
    self.__preempt = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=True)


  def _get_priority(self):
    """
    Getter method for priority, mapped from YANG variable /ha_groups/ha_group/config/priority (uint8)

    YANG Description: Set priority value for the firewall. This value is used
to participate in the election of the active unit in the HA
cluster. Firewall with highest priority is elected as the
ACTIVE unit
    """
    return self.__priority
      
  def _set_priority(self, v, load=False):
    """
    Setter method for priority, mapped from YANG variable /ha_groups/ha_group/config/priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_priority() directly.

    YANG Description: Set priority value for the firewall. This value is used
to participate in the election of the active unit in the HA
cluster. Firewall with highest priority is elected as the
ACTIVE unit
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)""",
        })

    self.__priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_priority(self):
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=True)


  def _get_preempt_hold_timer(self):
    """
    Getter method for preempt_hold_timer, mapped from YANG variable /ha_groups/ha_group/config/preempt_hold_timer (uint32)

    YANG Description: Length of time, from the last received Hello message,
a firewall will wait before taking over the active role in a
HA pair
    """
    return self.__preempt_hold_timer
      
  def _set_preempt_hold_timer(self, v, load=False):
    """
    Setter method for preempt_hold_timer, mapped from YANG variable /ha_groups/ha_group/config/preempt_hold_timer (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_preempt_hold_timer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_preempt_hold_timer() directly.

    YANG Description: Length of time, from the last received Hello message,
a firewall will wait before taking over the active role in a
HA pair
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """preempt_hold_timer must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)""",
        })

    self.__preempt_hold_timer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_preempt_hold_timer(self):
    self.__preempt_hold_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)


  def _get_hello_interval(self):
    """
    Getter method for hello_interval, mapped from YANG variable /ha_groups/ha_group/config/hello_interval (uint32)

    YANG Description: Interval between hello messages exchanged by the HA peers
    """
    return self.__hello_interval
      
  def _set_hello_interval(self, v, load=False):
    """
    Setter method for hello_interval, mapped from YANG variable /ha_groups/ha_group/config/hello_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_interval() directly.

    YANG Description: Interval between hello messages exchanged by the HA peers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)""",
        })

    self.__hello_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_interval(self):
    self.__hello_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=True)


  def _get_global_health_policy(self):
    """
    Getter method for global_health_policy, mapped from YANG variable /ha_groups/ha_group/config/global_health_policy (enumeration)

    YANG Description: Global health values associated with the interface monitoring
state machine
    """
    return self.__global_health_policy
      
  def _set_global_health_policy(self, v, load=False):
    """
    Setter method for global_health_policy, mapped from YANG variable /ha_groups/ha_group/config/global_health_policy (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_global_health_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_global_health_policy() directly.

    YANG Description: Global health values associated with the interface monitoring
state machine
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """global_health_policy must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)""",
        })

    self.__global_health_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_global_health_policy(self):
    self.__global_health_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)

  ha_enabled = __builtin__.property(_get_ha_enabled, _set_ha_enabled)
  ha_mode = __builtin__.property(_get_ha_mode, _set_ha_mode)
  ha_key = __builtin__.property(_get_ha_key, _set_ha_key)
  ha_key_hashed = __builtin__.property(_get_ha_key_hashed, _set_ha_key_hashed)
  ha_msg_encryption = __builtin__.property(_get_ha_msg_encryption, _set_ha_msg_encryption)
  id = __builtin__.property(_get_id, _set_id)
  ha_device_id = __builtin__.property(_get_ha_device_id, _set_ha_device_id)
  preempt = __builtin__.property(_get_preempt, _set_preempt)
  priority = __builtin__.property(_get_priority, _set_priority)
  preempt_hold_timer = __builtin__.property(_get_preempt_hold_timer, _set_preempt_hold_timer)
  hello_interval = __builtin__.property(_get_hello_interval, _set_hello_interval)
  global_health_policy = __builtin__.property(_get_global_health_policy, _set_global_health_policy)


  _pyangbind_elements = OrderedDict([('ha_enabled', ha_enabled), ('ha_mode', ha_mode), ('ha_key', ha_key), ('ha_key_hashed', ha_key_hashed), ('ha_msg_encryption', ha_msg_encryption), ('id', id), ('ha_device_id', ha_device_id), ('preempt', preempt), ('priority', priority), ('preempt_hold_timer', preempt_hold_timer), ('hello_interval', hello_interval), ('global_health_policy', global_health_policy), ])


class yc_state_openconfig_fw_high_availability__ha_groups_ha_group_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for HA parameters
  """
  __slots__ = ('_path_helper', '_extmethods', '__ha_enabled','__ha_mode','__ha_key','__ha_key_hashed','__ha_msg_encryption','__id','__ha_device_id','__preempt','__priority','__preempt_hold_timer','__hello_interval','__global_health_policy','__ha_state','__ha_state_last_change','__ha_config_sync','__ha_session_sync','__ha_mismatched_parameters','__global_health_status',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ha_enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    self.__ha_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    self.__ha_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=False)
    self.__ha_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    self.__ha_msg_encryption = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)
    self.__ha_device_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)
    self.__preempt = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)
    self.__preempt_hold_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)
    self.__hello_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)
    self.__global_health_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    self.__ha_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}, 'DEGRADED': {}, 'SUSPENDED': {}},), is_leaf=True, yang_name="ha-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    self.__ha_state_last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ha-state-last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-types:timeticks64', is_config=False)
    self.__ha_config_sync = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ha-config-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    self.__ha_session_sync = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ha-session-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    self.__ha_mismatched_parameters = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}},)), is_leaf=False, yang_name="ha-mismatched-parameters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='identityref', is_config=False)
    self.__global_health_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="global-health-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'state']

  def _get_ha_enabled(self):
    """
    Getter method for ha_enabled, mapped from YANG variable /ha_groups/ha_group/state/ha_enabled (boolean)

    YANG Description: This must be set to 'true' to initiate firewall participation
in a HA cluster. Once set to 'true', this boolean can be
flipped to 'false' to DISABLE HA and put a unit in a
'suspended' state while retaining all other HA settings &
configuration parameters. At the same time the 'ha-state' leaf
under 'ha-parameters-state' must then be updated to
'SUSPENDED'
    """
    return self.__ha_enabled
      
  def _set_ha_enabled(self, v, load=False):
    """
    Setter method for ha_enabled, mapped from YANG variable /ha_groups/ha_group/state/ha_enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_enabled() directly.

    YANG Description: This must be set to 'true' to initiate firewall participation
in a HA cluster. Once set to 'true', this boolean can be
flipped to 'false' to DISABLE HA and put a unit in a
'suspended' state while retaining all other HA settings &
configuration parameters. At the same time the 'ha-state' leaf
under 'ha-parameters-state' must then be updated to
'SUSPENDED'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)""",
        })

    self.__ha_enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_enabled(self):
    self.__ha_enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)


  def _get_ha_mode(self):
    """
    Getter method for ha_mode, mapped from YANG variable /ha_groups/ha_group/state/ha_mode (enumeration)

    YANG Description: Configurable HA modes
    """
    return self.__ha_mode
      
  def _set_ha_mode(self, v, load=False):
    """
    Setter method for ha_mode, mapped from YANG variable /ha_groups/ha_group/state/ha_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_mode() directly.

    YANG Description: Configurable HA modes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)""",
        })

    self.__ha_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_mode(self):
    self.__ha_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE_PASSIVE': {}},), is_leaf=True, yang_name="ha-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)


  def _get_ha_key(self):
    """
    Getter method for ha_key, mapped from YANG variable /ha_groups/ha_group/state/ha_key (string)

    YANG Description: HA key used to encrypt & authenticate HA messages betwen
the peers. This is provided in clear-text by the client &
expected to be hashed by the firewall in the configuration
    """
    return self.__ha_key
      
  def _set_ha_key(self, v, load=False):
    """
    Setter method for ha_key, mapped from YANG variable /ha_groups/ha_group/state/ha_key (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_key() directly.

    YANG Description: HA key used to encrypt & authenticate HA messages betwen
the peers. This is provided in clear-text by the client &
expected to be hashed by the firewall in the configuration
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_key must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=False)""",
        })

    self.__ha_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_key(self):
    self.__ha_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='string', is_config=False)


  def _get_ha_key_hashed(self):
    """
    Getter method for ha_key_hashed, mapped from YANG variable /ha_groups/ha_group/state/ha_key_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: HA key,used to encrypt & authenticate HA messages between
the peers, supplied as a hashed value using the notation
     described in the definition of the crypt-password-type
    """
    return self.__ha_key_hashed
      
  def _set_ha_key_hashed(self, v, load=False):
    """
    Setter method for ha_key_hashed, mapped from YANG variable /ha_groups/ha_group/state/ha_key_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_key_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_key_hashed() directly.

    YANG Description: HA key,used to encrypt & authenticate HA messages between
the peers, supplied as a hashed value using the notation
     described in the definition of the crypt-password-type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_key_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=False)""",
        })

    self.__ha_key_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_key_hashed(self):
    self.__ha_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ha-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-aaa-types:crypt-password-type', is_config=False)


  def _get_ha_msg_encryption(self):
    """
    Getter method for ha_msg_encryption, mapped from YANG variable /ha_groups/ha_group/state/ha_msg_encryption (boolean)

    YANG Description: When set to true all traffic between firewall units in a HA
cluster are encrypted. If operator provided encryption key is
supported, that value must be derived from the
ha-key/ha-key-hashed leaf nodes. If that is not supported, the
vendor is expected to derive it's own keying material
    """
    return self.__ha_msg_encryption
      
  def _set_ha_msg_encryption(self, v, load=False):
    """
    Setter method for ha_msg_encryption, mapped from YANG variable /ha_groups/ha_group/state/ha_msg_encryption (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_msg_encryption is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_msg_encryption() directly.

    YANG Description: When set to true all traffic between firewall units in a HA
cluster are encrypted. If operator provided encryption key is
supported, that value must be derived from the
ha-key/ha-key-hashed leaf nodes. If that is not supported, the
vendor is expected to derive it's own keying material
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_msg_encryption must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)""",
        })

    self.__ha_msg_encryption = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_msg_encryption(self):
    self.__ha_msg_encryption = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="ha-msg-encryption", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /ha_groups/ha_group/state/id (uint8)

    YANG Description: The high availbility group id for a unit. This value MUST
match across both units participating in a HA cluster
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /ha_groups/ha_group/state/id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: The high availbility group id for a unit. This value MUST
match across both units participating in a HA cluster
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)


  def _get_ha_device_id(self):
    """
    Getter method for ha_device_id, mapped from YANG variable /ha_groups/ha_group/state/ha_device_id (uint8)

    YANG Description: Specify the device-id to identify the firewall within a HA
group. This value MUST be unique to the local-unit and MUST
NOT clash with the peer within a ha-group
    """
    return self.__ha_device_id
      
  def _set_ha_device_id(self, v, load=False):
    """
    Setter method for ha_device_id, mapped from YANG variable /ha_groups/ha_group/state/ha_device_id (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_device_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_device_id() directly.

    YANG Description: Specify the device-id to identify the firewall within a HA
group. This value MUST be unique to the local-unit and MUST
NOT clash with the peer within a ha-group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_device_id must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)""",
        })

    self.__ha_device_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_device_id(self):
    self.__ha_device_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ha-device-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)


  def _get_preempt(self):
    """
    Getter method for preempt, mapped from YANG variable /ha_groups/ha_group/state/preempt (boolean)

    YANG Description: When set to true the firewall forces reelection of the active
role after joining the cluster
    """
    return self.__preempt
      
  def _set_preempt(self, v, load=False):
    """
    Setter method for preempt, mapped from YANG variable /ha_groups/ha_group/state/preempt (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_preempt is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_preempt() directly.

    YANG Description: When set to true the firewall forces reelection of the active
role after joining the cluster
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """preempt must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)""",
        })

    self.__preempt = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_preempt(self):
    self.__preempt = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="preempt", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)


  def _get_priority(self):
    """
    Getter method for priority, mapped from YANG variable /ha_groups/ha_group/state/priority (uint8)

    YANG Description: Set priority value for the firewall. This value is used
to participate in the election of the active unit in the HA
cluster. Firewall with highest priority is elected as the
ACTIVE unit
    """
    return self.__priority
      
  def _set_priority(self, v, load=False):
    """
    Setter method for priority, mapped from YANG variable /ha_groups/ha_group/state/priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_priority() directly.

    YANG Description: Set priority value for the firewall. This value is used
to participate in the election of the active unit in the HA
cluster. Firewall with highest priority is elected as the
ACTIVE unit
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)""",
        })

    self.__priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_priority(self):
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint8', is_config=False)


  def _get_preempt_hold_timer(self):
    """
    Getter method for preempt_hold_timer, mapped from YANG variable /ha_groups/ha_group/state/preempt_hold_timer (uint32)

    YANG Description: Length of time, from the last received Hello message,
a firewall will wait before taking over the active role in a
HA pair
    """
    return self.__preempt_hold_timer
      
  def _set_preempt_hold_timer(self, v, load=False):
    """
    Setter method for preempt_hold_timer, mapped from YANG variable /ha_groups/ha_group/state/preempt_hold_timer (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_preempt_hold_timer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_preempt_hold_timer() directly.

    YANG Description: Length of time, from the last received Hello message,
a firewall will wait before taking over the active role in a
HA pair
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """preempt_hold_timer must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)""",
        })

    self.__preempt_hold_timer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_preempt_hold_timer(self):
    self.__preempt_hold_timer = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="preempt-hold-timer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)


  def _get_hello_interval(self):
    """
    Getter method for hello_interval, mapped from YANG variable /ha_groups/ha_group/state/hello_interval (uint32)

    YANG Description: Interval between hello messages exchanged by the HA peers
    """
    return self.__hello_interval
      
  def _set_hello_interval(self, v, load=False):
    """
    Setter method for hello_interval, mapped from YANG variable /ha_groups/ha_group/state/hello_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_interval() directly.

    YANG Description: Interval between hello messages exchanged by the HA peers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)""",
        })

    self.__hello_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_interval(self):
    self.__hello_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="hello-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='uint32', is_config=False)


  def _get_global_health_policy(self):
    """
    Getter method for global_health_policy, mapped from YANG variable /ha_groups/ha_group/state/global_health_policy (enumeration)

    YANG Description: Global health values associated with the interface monitoring
state machine
    """
    return self.__global_health_policy
      
  def _set_global_health_policy(self, v, load=False):
    """
    Setter method for global_health_policy, mapped from YANG variable /ha_groups/ha_group/state/global_health_policy (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_global_health_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_global_health_policy() directly.

    YANG Description: Global health values associated with the interface monitoring
state machine
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """global_health_policy must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)""",
        })

    self.__global_health_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_global_health_policy(self):
    self.__global_health_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="global-health-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)


  def _get_ha_state(self):
    """
    Getter method for ha_state, mapped from YANG variable /ha_groups/ha_group/state/ha_state (enumeration)

    YANG Description: Firewall's operational ha-state
    """
    return self.__ha_state
      
  def _set_ha_state(self, v, load=False):
    """
    Setter method for ha_state, mapped from YANG variable /ha_groups/ha_group/state/ha_state (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_state() directly.

    YANG Description: Firewall's operational ha-state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}, 'DEGRADED': {}, 'SUSPENDED': {}},), is_leaf=True, yang_name="ha-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_state must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}, 'DEGRADED': {}, 'SUSPENDED': {}},), is_leaf=True, yang_name="ha-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)""",
        })

    self.__ha_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_state(self):
    self.__ha_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ACTIVE': {}, 'PASSIVE': {}, 'DEGRADED': {}, 'SUSPENDED': {}},), is_leaf=True, yang_name="ha-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)


  def _get_ha_state_last_change(self):
    """
    Getter method for ha_state_last_change, mapped from YANG variable /ha_groups/ha_group/state/ha_state_last_change (oc-types:timeticks64)

    YANG Description: Reports the time the firewall entered its current HA
operational state. The value is the timestamp in nanoseconds
relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__ha_state_last_change
      
  def _set_ha_state_last_change(self, v, load=False):
    """
    Setter method for ha_state_last_change, mapped from YANG variable /ha_groups/ha_group/state/ha_state_last_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_state_last_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_state_last_change() directly.

    YANG Description: Reports the time the firewall entered its current HA
operational state. The value is the timestamp in nanoseconds
relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ha-state-last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_state_last_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ha-state-last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__ha_state_last_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_state_last_change(self):
    self.__ha_state_last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ha-state-last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-types:timeticks64', is_config=False)


  def _get_ha_config_sync(self):
    """
    Getter method for ha_config_sync, mapped from YANG variable /ha_groups/ha_group/state/ha_config_sync (boolean)

    YANG Description: Returns 'TRUE' if config sync is operational between HA
peers. Returns 'FALSE' otherwise.
    """
    return self.__ha_config_sync
      
  def _set_ha_config_sync(self, v, load=False):
    """
    Setter method for ha_config_sync, mapped from YANG variable /ha_groups/ha_group/state/ha_config_sync (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_config_sync is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_config_sync() directly.

    YANG Description: Returns 'TRUE' if config sync is operational between HA
peers. Returns 'FALSE' otherwise.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="ha-config-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_config_sync must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ha-config-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)""",
        })

    self.__ha_config_sync = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_config_sync(self):
    self.__ha_config_sync = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ha-config-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)


  def _get_ha_session_sync(self):
    """
    Getter method for ha_session_sync, mapped from YANG variable /ha_groups/ha_group/state/ha_session_sync (boolean)

    YANG Description: Returns 'TRUE' if session sync is operational between HA
peers. Returns 'FALSE' otherwise.
    """
    return self.__ha_session_sync
      
  def _set_ha_session_sync(self, v, load=False):
    """
    Setter method for ha_session_sync, mapped from YANG variable /ha_groups/ha_group/state/ha_session_sync (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_session_sync is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_session_sync() directly.

    YANG Description: Returns 'TRUE' if session sync is operational between HA
peers. Returns 'FALSE' otherwise.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="ha-session-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_session_sync must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ha-session-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)""",
        })

    self.__ha_session_sync = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_session_sync(self):
    self.__ha_session_sync = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="ha-session-sync", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='boolean', is_config=False)


  def _get_ha_mismatched_parameters(self):
    """
    Getter method for ha_mismatched_parameters, mapped from YANG variable /ha_groups/ha_group/state/ha_mismatched_parameters (identityref)

    YANG Description: List of HA parameters that are mismatched between peers. Use
this list to highlight root cause of HA operational issues
that an operator must fix
    """
    return self.__ha_mismatched_parameters
      
  def _set_ha_mismatched_parameters(self, v, load=False):
    """
    Setter method for ha_mismatched_parameters, mapped from YANG variable /ha_groups/ha_group/state/ha_mismatched_parameters (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_mismatched_parameters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_mismatched_parameters() directly.

    YANG Description: List of HA parameters that are mismatched between peers. Use
this list to highlight root cause of HA operational issues
that an operator must fix
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}},)), is_leaf=False, yang_name="ha-mismatched-parameters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_mismatched_parameters must be of a type compatible with identityref""",
          'defined-type': "openconfig-fw-high-availability:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}},)), is_leaf=False, yang_name="ha-mismatched-parameters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='identityref', is_config=False)""",
        })

    self.__ha_mismatched_parameters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_mismatched_parameters(self):
    self.__ha_mismatched_parameters = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:SOFTWARE_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:RUNNING_CONFIG_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:IPS_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}, 'oc-fw-ha:AVC_SIGNATURES_MISMATCH': {'@module': 'openconfig-fw-high-availability', '@namespace': 'http://openconfig.net/yang/oc-fw-ha'}},)), is_leaf=False, yang_name="ha-mismatched-parameters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='identityref', is_config=False)


  def _get_global_health_status(self):
    """
    Getter method for global_health_status, mapped from YANG variable /ha_groups/ha_group/state/global_health_status (enumeration)

    YANG Description: Global interface monitoring status
    """
    return self.__global_health_status
      
  def _set_global_health_status(self, v, load=False):
    """
    Setter method for global_health_status, mapped from YANG variable /ha_groups/ha_group/state/global_health_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_global_health_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_global_health_status() directly.

    YANG Description: Global interface monitoring status
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="global-health-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """global_health_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="global-health-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)""",
        })

    self.__global_health_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_global_health_status(self):
    self.__global_health_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="global-health-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)

  ha_enabled = __builtin__.property(_get_ha_enabled)
  ha_mode = __builtin__.property(_get_ha_mode)
  ha_key = __builtin__.property(_get_ha_key)
  ha_key_hashed = __builtin__.property(_get_ha_key_hashed)
  ha_msg_encryption = __builtin__.property(_get_ha_msg_encryption)
  id = __builtin__.property(_get_id)
  ha_device_id = __builtin__.property(_get_ha_device_id)
  preempt = __builtin__.property(_get_preempt)
  priority = __builtin__.property(_get_priority)
  preempt_hold_timer = __builtin__.property(_get_preempt_hold_timer)
  hello_interval = __builtin__.property(_get_hello_interval)
  global_health_policy = __builtin__.property(_get_global_health_policy)
  ha_state = __builtin__.property(_get_ha_state)
  ha_state_last_change = __builtin__.property(_get_ha_state_last_change)
  ha_config_sync = __builtin__.property(_get_ha_config_sync)
  ha_session_sync = __builtin__.property(_get_ha_session_sync)
  ha_mismatched_parameters = __builtin__.property(_get_ha_mismatched_parameters)
  global_health_status = __builtin__.property(_get_global_health_status)


  _pyangbind_elements = OrderedDict([('ha_enabled', ha_enabled), ('ha_mode', ha_mode), ('ha_key', ha_key), ('ha_key_hashed', ha_key_hashed), ('ha_msg_encryption', ha_msg_encryption), ('id', id), ('ha_device_id', ha_device_id), ('preempt', preempt), ('priority', priority), ('preempt_hold_timer', preempt_hold_timer), ('hello_interval', hello_interval), ('global_health_policy', global_health_policy), ('ha_state', ha_state), ('ha_state_last_change', ha_state_last_change), ('ha_config_sync', ha_config_sync), ('ha_session_sync', ha_session_sync), ('ha_mismatched_parameters', ha_mismatched_parameters), ('global_health_status', global_health_status), ])


class yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/control-link/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters related to primary HA control
link
  """
  __slots__ = ('_path_helper', '_extmethods', '__control_link_interface','__control_link_port','__control_link_ipv4','__control_link_gateway','__control_link_ipv6','__control_link_ipv6_gateway','__control_link_peer_ipv4','__control_link_peer_ipv6',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'control-link', 'config']

  def _get_control_link_interface(self):
    """
    Getter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    return self.__control_link_interface
      
  def _set_control_link_interface(self, v, load=False):
    """
    Setter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_interface() directly.

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__control_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_interface(self):
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_control_link_port(self):
    """
    Getter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    return self.__control_link_port
      
  def _set_control_link_port(self, v, load=False):
    """
    Setter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__control_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_port(self):
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)


  def _get_control_link_ipv4(self):
    """
    Getter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    return self.__control_link_ipv4
      
  def _set_control_link_ipv4(self, v, load=False):
    """
    Setter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv4() directly.

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__control_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv4(self):
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_control_link_gateway(self):
    """
    Getter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    return self.__control_link_gateway
      
  def _set_control_link_gateway(self, v, load=False):
    """
    Setter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_gateway() directly.

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)""",
        })

    self.__control_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_gateway(self):
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)


  def _get_control_link_ipv6(self):
    """
    Getter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    return self.__control_link_ipv6
      
  def _set_control_link_ipv6(self, v, load=False):
    """
    Setter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6() directly.

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__control_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6(self):
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_control_link_ipv6_gateway(self):
    """
    Getter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__control_link_ipv6_gateway
      
  def _set_control_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6_gateway() directly.

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)""",
        })

    self.__control_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6_gateway(self):
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)


  def _get_control_link_peer_ipv4(self):
    """
    Getter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv4
      
  def _set_control_link_peer_ipv4(self, v, load=False):
    """
    Setter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv4() directly.

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__control_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv4(self):
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_control_link_peer_ipv6(self):
    """
    Getter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv6
      
  def _set_control_link_peer_ipv6(self, v, load=False):
    """
    Setter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/config/control_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv6() directly.

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__control_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv6(self):
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

  control_link_interface = __builtin__.property(_get_control_link_interface, _set_control_link_interface)
  control_link_port = __builtin__.property(_get_control_link_port, _set_control_link_port)
  control_link_ipv4 = __builtin__.property(_get_control_link_ipv4, _set_control_link_ipv4)
  control_link_gateway = __builtin__.property(_get_control_link_gateway, _set_control_link_gateway)
  control_link_ipv6 = __builtin__.property(_get_control_link_ipv6, _set_control_link_ipv6)
  control_link_ipv6_gateway = __builtin__.property(_get_control_link_ipv6_gateway, _set_control_link_ipv6_gateway)
  control_link_peer_ipv4 = __builtin__.property(_get_control_link_peer_ipv4, _set_control_link_peer_ipv4)
  control_link_peer_ipv6 = __builtin__.property(_get_control_link_peer_ipv6, _set_control_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('control_link_interface', control_link_interface), ('control_link_port', control_link_port), ('control_link_ipv4', control_link_ipv4), ('control_link_gateway', control_link_gateway), ('control_link_ipv6', control_link_ipv6), ('control_link_ipv6_gateway', control_link_ipv6_gateway), ('control_link_peer_ipv4', control_link_peer_ipv4), ('control_link_peer_ipv6', control_link_peer_ipv6), ])


class yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/control-link/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data related to primary HA control link
  """
  __slots__ = ('_path_helper', '_extmethods', '__control_link_interface','__control_link_port','__control_link_ipv4','__control_link_gateway','__control_link_ipv6','__control_link_ipv6_gateway','__control_link_peer_ipv4','__control_link_peer_ipv6',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'control-link', 'state']

  def _get_control_link_interface(self):
    """
    Getter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    return self.__control_link_interface
      
  def _set_control_link_interface(self, v, load=False):
    """
    Setter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_interface() directly.

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__control_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_interface(self):
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_control_link_port(self):
    """
    Getter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    return self.__control_link_port
      
  def _set_control_link_port(self, v, load=False):
    """
    Setter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__control_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_port(self):
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)


  def _get_control_link_ipv4(self):
    """
    Getter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    return self.__control_link_ipv4
      
  def _set_control_link_ipv4(self, v, load=False):
    """
    Setter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv4() directly.

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__control_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv4(self):
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_control_link_gateway(self):
    """
    Getter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    return self.__control_link_gateway
      
  def _set_control_link_gateway(self, v, load=False):
    """
    Setter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_gateway() directly.

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__control_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_gateway(self):
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_control_link_ipv6(self):
    """
    Getter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    return self.__control_link_ipv6
      
  def _set_control_link_ipv6(self, v, load=False):
    """
    Setter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6() directly.

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__control_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6(self):
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_control_link_ipv6_gateway(self):
    """
    Getter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__control_link_ipv6_gateway
      
  def _set_control_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6_gateway() directly.

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__control_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6_gateway(self):
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_control_link_peer_ipv4(self):
    """
    Getter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv4
      
  def _set_control_link_peer_ipv4(self, v, load=False):
    """
    Setter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv4() directly.

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__control_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv4(self):
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_control_link_peer_ipv6(self):
    """
    Getter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv6
      
  def _set_control_link_peer_ipv6(self, v, load=False):
    """
    Setter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/state/control_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv6() directly.

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__control_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv6(self):
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

  control_link_interface = __builtin__.property(_get_control_link_interface)
  control_link_port = __builtin__.property(_get_control_link_port)
  control_link_ipv4 = __builtin__.property(_get_control_link_ipv4)
  control_link_gateway = __builtin__.property(_get_control_link_gateway)
  control_link_ipv6 = __builtin__.property(_get_control_link_ipv6)
  control_link_ipv6_gateway = __builtin__.property(_get_control_link_ipv6_gateway)
  control_link_peer_ipv4 = __builtin__.property(_get_control_link_peer_ipv4)
  control_link_peer_ipv6 = __builtin__.property(_get_control_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('control_link_interface', control_link_interface), ('control_link_port', control_link_port), ('control_link_ipv4', control_link_ipv4), ('control_link_gateway', control_link_gateway), ('control_link_ipv6', control_link_ipv6), ('control_link_ipv6_gateway', control_link_ipv6_gateway), ('control_link_peer_ipv4', control_link_peer_ipv4), ('control_link_peer_ipv6', control_link_peer_ipv6), ])


class yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/control-link/backup/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data related to backup HA control link
  """
  __slots__ = ('_path_helper', '_extmethods', '__control_link_interface','__control_link_port','__control_link_ipv4','__control_link_gateway','__control_link_ipv6','__control_link_ipv6_gateway','__control_link_peer_ipv4','__control_link_peer_ipv6',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'control-link', 'backup', 'config']

  def _get_control_link_interface(self):
    """
    Getter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    return self.__control_link_interface
      
  def _set_control_link_interface(self, v, load=False):
    """
    Setter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_interface() directly.

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__control_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_interface(self):
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_control_link_port(self):
    """
    Getter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    return self.__control_link_port
      
  def _set_control_link_port(self, v, load=False):
    """
    Setter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__control_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_port(self):
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)


  def _get_control_link_ipv4(self):
    """
    Getter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    return self.__control_link_ipv4
      
  def _set_control_link_ipv4(self, v, load=False):
    """
    Setter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv4() directly.

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__control_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv4(self):
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_control_link_gateway(self):
    """
    Getter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    return self.__control_link_gateway
      
  def _set_control_link_gateway(self, v, load=False):
    """
    Setter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_gateway() directly.

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)""",
        })

    self.__control_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_gateway(self):
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)


  def _get_control_link_ipv6(self):
    """
    Getter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    return self.__control_link_ipv6
      
  def _set_control_link_ipv6(self, v, load=False):
    """
    Setter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6() directly.

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__control_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6(self):
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_control_link_ipv6_gateway(self):
    """
    Getter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__control_link_ipv6_gateway
      
  def _set_control_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6_gateway() directly.

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)""",
        })

    self.__control_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6_gateway(self):
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)


  def _get_control_link_peer_ipv4(self):
    """
    Getter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv4
      
  def _set_control_link_peer_ipv4(self, v, load=False):
    """
    Setter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv4() directly.

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__control_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv4(self):
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_control_link_peer_ipv6(self):
    """
    Getter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv6
      
  def _set_control_link_peer_ipv6(self, v, load=False):
    """
    Setter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config/control_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv6() directly.

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__control_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv6(self):
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

  control_link_interface = __builtin__.property(_get_control_link_interface, _set_control_link_interface)
  control_link_port = __builtin__.property(_get_control_link_port, _set_control_link_port)
  control_link_ipv4 = __builtin__.property(_get_control_link_ipv4, _set_control_link_ipv4)
  control_link_gateway = __builtin__.property(_get_control_link_gateway, _set_control_link_gateway)
  control_link_ipv6 = __builtin__.property(_get_control_link_ipv6, _set_control_link_ipv6)
  control_link_ipv6_gateway = __builtin__.property(_get_control_link_ipv6_gateway, _set_control_link_ipv6_gateway)
  control_link_peer_ipv4 = __builtin__.property(_get_control_link_peer_ipv4, _set_control_link_peer_ipv4)
  control_link_peer_ipv6 = __builtin__.property(_get_control_link_peer_ipv6, _set_control_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('control_link_interface', control_link_interface), ('control_link_port', control_link_port), ('control_link_ipv4', control_link_ipv4), ('control_link_gateway', control_link_gateway), ('control_link_ipv6', control_link_ipv6), ('control_link_ipv6_gateway', control_link_ipv6_gateway), ('control_link_peer_ipv4', control_link_peer_ipv4), ('control_link_peer_ipv6', control_link_peer_ipv6), ])


class yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/control-link/backup/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data related to backup HA control link
  """
  __slots__ = ('_path_helper', '_extmethods', '__control_link_interface','__control_link_port','__control_link_ipv4','__control_link_gateway','__control_link_ipv6','__control_link_ipv6_gateway','__control_link_peer_ipv4','__control_link_peer_ipv6',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'control-link', 'backup', 'state']

  def _get_control_link_interface(self):
    """
    Getter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    return self.__control_link_interface
      
  def _set_control_link_interface(self, v, load=False):
    """
    Setter method for control_link_interface, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_interface() directly.

    YANG Description: Specify which interface will be used to exchange HA control
messages between peers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__control_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_interface(self):
    self.__control_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="control-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_control_link_port(self):
    """
    Getter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    return self.__control_link_port
      
  def _set_control_link_port(self, v, load=False):
    """
    Setter method for control_link_port, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange control
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__control_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_port(self):
    self.__control_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="control-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)


  def _get_control_link_ipv4(self):
    """
    Getter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    return self.__control_link_ipv4
      
  def _set_control_link_ipv4(self, v, load=False):
    """
    Setter method for control_link_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv4() directly.

    YANG Description: Specify the ipv4 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__control_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv4(self):
    self.__control_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_control_link_gateway(self):
    """
    Getter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    return self.__control_link_gateway
      
  def _set_control_link_gateway(self, v, load=False):
    """
    Setter method for control_link_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_gateway() directly.

    YANG Description: If peer control ipv4 is in a different subnet, specify the
gateway ipv4 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__control_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_gateway(self):
    self.__control_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="control-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_control_link_ipv6(self):
    """
    Getter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    return self.__control_link_ipv6
      
  def _set_control_link_ipv6(self, v, load=False):
    """
    Setter method for control_link_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6() directly.

    YANG Description: Specify the ipv6 address used by the fw for the control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__control_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6(self):
    self.__control_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_control_link_ipv6_gateway(self):
    """
    Getter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__control_link_ipv6_gateway
      
  def _set_control_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for control_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_ipv6_gateway() directly.

    YANG Description: If peer control ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__control_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_ipv6_gateway(self):
    self.__control_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="control-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_control_link_peer_ipv4(self):
    """
    Getter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv4
      
  def _set_control_link_peer_ipv4(self, v, load=False):
    """
    Setter method for control_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv4() directly.

    YANG Description: Specify the peer ipv4 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__control_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv4(self):
    self.__control_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="control-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_control_link_peer_ipv6(self):
    """
    Getter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    return self.__control_link_peer_ipv6
      
  def _set_control_link_peer_ipv6(self, v, load=False):
    """
    Setter method for control_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state/control_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link_peer_ipv6() directly.

    YANG Description: Specify the peer ipv6 address, if control link is utilizing
Layer 3
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__control_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link_peer_ipv6(self):
    self.__control_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="control-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

  control_link_interface = __builtin__.property(_get_control_link_interface)
  control_link_port = __builtin__.property(_get_control_link_port)
  control_link_ipv4 = __builtin__.property(_get_control_link_ipv4)
  control_link_gateway = __builtin__.property(_get_control_link_gateway)
  control_link_ipv6 = __builtin__.property(_get_control_link_ipv6)
  control_link_ipv6_gateway = __builtin__.property(_get_control_link_ipv6_gateway)
  control_link_peer_ipv4 = __builtin__.property(_get_control_link_peer_ipv4)
  control_link_peer_ipv6 = __builtin__.property(_get_control_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('control_link_interface', control_link_interface), ('control_link_port', control_link_port), ('control_link_ipv4', control_link_ipv4), ('control_link_gateway', control_link_gateway), ('control_link_ipv6', control_link_ipv6), ('control_link_ipv6_gateway', control_link_ipv6_gateway), ('control_link_peer_ipv4', control_link_peer_ipv4), ('control_link_peer_ipv6', control_link_peer_ipv6), ])


class yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/control-link/backup. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data related to backup HA control link
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'backup'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'control-link', 'backup']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config (container)

    YANG Description: Configuration data related to backup HA control link
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /ha_groups/ha_group/control_link/backup/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data related to backup HA control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state (container)

    YANG Description: Operational state data related to backup HA control link
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /ha_groups/ha_group/control_link/backup/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data related to backup HA control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_control_link_openconfig_fw_high_availability__ha_groups_ha_group_control_link(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/control-link. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for HA control link
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__backup',)

  _yang_name = 'control-link'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__backup = YANGDynClass(base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'control-link']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /ha_groups/ha_group/control_link/config (container)

    YANG Description: Configuration parameters related to primary HA control
link
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /ha_groups/ha_group/control_link/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters related to primary HA control
link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_control_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /ha_groups/ha_group/control_link/state (container)

    YANG Description: Operational state data related to primary HA control link
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /ha_groups/ha_group/control_link/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data related to primary HA control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_control_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_backup(self):
    """
    Getter method for backup, mapped from YANG variable /ha_groups/ha_group/control_link/backup (container)

    YANG Description: Data related to backup HA control link
    """
    return self.__backup
      
  def _set_backup(self, v, load=False):
    """
    Setter method for backup, mapped from YANG variable /ha_groups/ha_group/control_link/backup (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_backup is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_backup() directly.

    YANG Description: Data related to backup HA control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """backup must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__backup = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_backup(self):
    self.__backup = YANGDynClass(base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_control_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  backup = __builtin__.property(_get_backup, _set_backup)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('backup', backup), ])


class yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/data-link/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters related to primary HA data link
  """
  __slots__ = ('_path_helper', '_extmethods', '__data_link_interface','__data_link_port','__data_link_ipv4','__data_link_gateway','__data_link_ipv6','__data_link_ipv6_gateway','__data_link_peer_ipv4','__data_link_peer_ipv6',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'data-link', 'config']

  def _get_data_link_interface(self):
    """
    Getter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    return self.__data_link_interface
      
  def _set_data_link_interface(self, v, load=False):
    """
    Setter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_interface() directly.

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__data_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_interface(self):
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_data_link_port(self):
    """
    Getter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    return self.__data_link_port
      
  def _set_data_link_port(self, v, load=False):
    """
    Setter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__data_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_port(self):
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)


  def _get_data_link_ipv4(self):
    """
    Getter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    return self.__data_link_ipv4
      
  def _set_data_link_ipv4(self, v, load=False):
    """
    Setter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv4() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__data_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv4(self):
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_data_link_gateway(self):
    """
    Getter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    return self.__data_link_gateway
      
  def _set_data_link_gateway(self, v, load=False):
    """
    Setter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_gateway() directly.

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)""",
        })

    self.__data_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_gateway(self):
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)


  def _get_data_link_ipv6(self):
    """
    Getter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    return self.__data_link_ipv6
      
  def _set_data_link_ipv6(self, v, load=False):
    """
    Setter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__data_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6(self):
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_data_link_ipv6_gateway(self):
    """
    Getter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__data_link_ipv6_gateway
      
  def _set_data_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6_gateway() directly.

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)""",
        })

    self.__data_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6_gateway(self):
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)


  def _get_data_link_peer_ipv4(self):
    """
    Getter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    return self.__data_link_peer_ipv4
      
  def _set_data_link_peer_ipv4(self, v, load=False):
    """
    Setter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv4() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__data_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv4(self):
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_data_link_peer_ipv6(self):
    """
    Getter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    return self.__data_link_peer_ipv6
      
  def _set_data_link_peer_ipv6(self, v, load=False):
    """
    Setter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/config/data_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv6() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__data_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv6(self):
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

  data_link_interface = __builtin__.property(_get_data_link_interface, _set_data_link_interface)
  data_link_port = __builtin__.property(_get_data_link_port, _set_data_link_port)
  data_link_ipv4 = __builtin__.property(_get_data_link_ipv4, _set_data_link_ipv4)
  data_link_gateway = __builtin__.property(_get_data_link_gateway, _set_data_link_gateway)
  data_link_ipv6 = __builtin__.property(_get_data_link_ipv6, _set_data_link_ipv6)
  data_link_ipv6_gateway = __builtin__.property(_get_data_link_ipv6_gateway, _set_data_link_ipv6_gateway)
  data_link_peer_ipv4 = __builtin__.property(_get_data_link_peer_ipv4, _set_data_link_peer_ipv4)
  data_link_peer_ipv6 = __builtin__.property(_get_data_link_peer_ipv6, _set_data_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('data_link_interface', data_link_interface), ('data_link_port', data_link_port), ('data_link_ipv4', data_link_ipv4), ('data_link_gateway', data_link_gateway), ('data_link_ipv6', data_link_ipv6), ('data_link_ipv6_gateway', data_link_ipv6_gateway), ('data_link_peer_ipv4', data_link_peer_ipv4), ('data_link_peer_ipv6', data_link_peer_ipv6), ])


class yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/data-link/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters related to primary HA data
link
  """
  __slots__ = ('_path_helper', '_extmethods', '__data_link_interface','__data_link_port','__data_link_ipv4','__data_link_gateway','__data_link_ipv6','__data_link_ipv6_gateway','__data_link_peer_ipv4','__data_link_peer_ipv6',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'data-link', 'state']

  def _get_data_link_interface(self):
    """
    Getter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    return self.__data_link_interface
      
  def _set_data_link_interface(self, v, load=False):
    """
    Setter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_interface() directly.

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__data_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_interface(self):
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_data_link_port(self):
    """
    Getter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    return self.__data_link_port
      
  def _set_data_link_port(self, v, load=False):
    """
    Setter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__data_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_port(self):
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)


  def _get_data_link_ipv4(self):
    """
    Getter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    return self.__data_link_ipv4
      
  def _set_data_link_ipv4(self, v, load=False):
    """
    Setter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv4() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__data_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv4(self):
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_data_link_gateway(self):
    """
    Getter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    return self.__data_link_gateway
      
  def _set_data_link_gateway(self, v, load=False):
    """
    Setter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_gateway() directly.

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__data_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_gateway(self):
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_data_link_ipv6(self):
    """
    Getter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    return self.__data_link_ipv6
      
  def _set_data_link_ipv6(self, v, load=False):
    """
    Setter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__data_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6(self):
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_data_link_ipv6_gateway(self):
    """
    Getter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__data_link_ipv6_gateway
      
  def _set_data_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6_gateway() directly.

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__data_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6_gateway(self):
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_data_link_peer_ipv4(self):
    """
    Getter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    return self.__data_link_peer_ipv4
      
  def _set_data_link_peer_ipv4(self, v, load=False):
    """
    Setter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv4() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__data_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv4(self):
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_data_link_peer_ipv6(self):
    """
    Getter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    return self.__data_link_peer_ipv6
      
  def _set_data_link_peer_ipv6(self, v, load=False):
    """
    Setter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/state/data_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv6() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__data_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv6(self):
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

  data_link_interface = __builtin__.property(_get_data_link_interface)
  data_link_port = __builtin__.property(_get_data_link_port)
  data_link_ipv4 = __builtin__.property(_get_data_link_ipv4)
  data_link_gateway = __builtin__.property(_get_data_link_gateway)
  data_link_ipv6 = __builtin__.property(_get_data_link_ipv6)
  data_link_ipv6_gateway = __builtin__.property(_get_data_link_ipv6_gateway)
  data_link_peer_ipv4 = __builtin__.property(_get_data_link_peer_ipv4)
  data_link_peer_ipv6 = __builtin__.property(_get_data_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('data_link_interface', data_link_interface), ('data_link_port', data_link_port), ('data_link_ipv4', data_link_ipv4), ('data_link_gateway', data_link_gateway), ('data_link_ipv6', data_link_ipv6), ('data_link_ipv6_gateway', data_link_ipv6_gateway), ('data_link_peer_ipv4', data_link_peer_ipv4), ('data_link_peer_ipv6', data_link_peer_ipv6), ])


class yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/data-link/backup/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters related to backup HA data link
  """
  __slots__ = ('_path_helper', '_extmethods', '__data_link_interface','__data_link_port','__data_link_ipv4','__data_link_gateway','__data_link_ipv6','__data_link_ipv6_gateway','__data_link_peer_ipv4','__data_link_peer_ipv6',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'data-link', 'backup', 'config']

  def _get_data_link_interface(self):
    """
    Getter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    return self.__data_link_interface
      
  def _set_data_link_interface(self, v, load=False):
    """
    Setter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_interface() directly.

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__data_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_interface(self):
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_data_link_port(self):
    """
    Getter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    return self.__data_link_port
      
  def _set_data_link_port(self, v, load=False):
    """
    Setter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__data_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_port(self):
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=True)


  def _get_data_link_ipv4(self):
    """
    Getter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    return self.__data_link_ipv4
      
  def _set_data_link_ipv4(self, v, load=False):
    """
    Setter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv4() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__data_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv4(self):
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_data_link_gateway(self):
    """
    Getter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    return self.__data_link_gateway
      
  def _set_data_link_gateway(self, v, load=False):
    """
    Setter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_gateway() directly.

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)""",
        })

    self.__data_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_gateway(self):
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=True)


  def _get_data_link_ipv6(self):
    """
    Getter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    return self.__data_link_ipv6
      
  def _set_data_link_ipv6(self, v, load=False):
    """
    Setter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__data_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6(self):
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_data_link_ipv6_gateway(self):
    """
    Getter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__data_link_ipv6_gateway
      
  def _set_data_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6_gateway() directly.

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)""",
        })

    self.__data_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6_gateway(self):
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=True)


  def _get_data_link_peer_ipv4(self):
    """
    Getter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    return self.__data_link_peer_ipv4
      
  def _set_data_link_peer_ipv4(self, v, load=False):
    """
    Setter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv4() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__data_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv4(self):
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_data_link_peer_ipv6(self):
    """
    Getter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    return self.__data_link_peer_ipv6
      
  def _set_data_link_peer_ipv6(self, v, load=False):
    """
    Setter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config/data_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv6() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__data_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv6(self):
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=True)

  data_link_interface = __builtin__.property(_get_data_link_interface, _set_data_link_interface)
  data_link_port = __builtin__.property(_get_data_link_port, _set_data_link_port)
  data_link_ipv4 = __builtin__.property(_get_data_link_ipv4, _set_data_link_ipv4)
  data_link_gateway = __builtin__.property(_get_data_link_gateway, _set_data_link_gateway)
  data_link_ipv6 = __builtin__.property(_get_data_link_ipv6, _set_data_link_ipv6)
  data_link_ipv6_gateway = __builtin__.property(_get_data_link_ipv6_gateway, _set_data_link_ipv6_gateway)
  data_link_peer_ipv4 = __builtin__.property(_get_data_link_peer_ipv4, _set_data_link_peer_ipv4)
  data_link_peer_ipv6 = __builtin__.property(_get_data_link_peer_ipv6, _set_data_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('data_link_interface', data_link_interface), ('data_link_port', data_link_port), ('data_link_ipv4', data_link_ipv4), ('data_link_gateway', data_link_gateway), ('data_link_ipv6', data_link_ipv6), ('data_link_ipv6_gateway', data_link_ipv6_gateway), ('data_link_peer_ipv4', data_link_peer_ipv4), ('data_link_peer_ipv6', data_link_peer_ipv6), ])


class yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/data-link/backup/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters related to backup HA data
link
  """
  __slots__ = ('_path_helper', '_extmethods', '__data_link_interface','__data_link_port','__data_link_ipv4','__data_link_gateway','__data_link_ipv6','__data_link_ipv6_gateway','__data_link_peer_ipv4','__data_link_peer_ipv6',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'data-link', 'backup', 'state']

  def _get_data_link_interface(self):
    """
    Getter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_interface (oc-if:base-interface-ref)

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    return self.__data_link_interface
      
  def _set_data_link_interface(self, v, load=False):
    """
    Setter method for data_link_interface, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_interface() directly.

    YANG Description: Specify which interface will be used to sync session tables,
forwarding tables, ARP tables, IPSEC SAs and any other
messages that MUST be exchanged to facilitate seamless traffic
handling during a failover event
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__data_link_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_interface(self):
    self.__data_link_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="data-link-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_data_link_port(self):
    """
    Getter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_port (oc-inet:port-number)

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    return self.__data_link_port
      
  def _set_data_link_port(self, v, load=False):
    """
    Setter method for data_link_port, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_port() directly.

    YANG Description: Specify which TCP/UDP port will be used to exchange data link
messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__data_link_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_port(self):
    self.__data_link_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="data-link-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:port-number', is_config=False)


  def _get_data_link_ipv4(self):
    """
    Getter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    return self.__data_link_ipv4
      
  def _set_data_link_ipv4(self, v, load=False):
    """
    Setter method for data_link_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv4() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv4
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__data_link_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv4(self):
    self.__data_link_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_data_link_gateway(self):
    """
    Getter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_gateway (oc-inet:ipv4-address)

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    return self.__data_link_gateway
      
  def _set_data_link_gateway(self, v, load=False):
    """
    Setter method for data_link_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_gateway (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_gateway() directly.

    YANG Description: If peer data ip is in a different subnet, specify the gateway
ip here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_gateway must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__data_link_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_gateway(self):
    self.__data_link_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="data-link-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_data_link_ipv6(self):
    """
    Getter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    return self.__data_link_ipv6
      
  def _set_data_link_ipv6(self, v, load=False):
    """
    Setter method for data_link_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6() directly.

    YANG Description: If data link is layer 3, specify the local unit's ipv6
address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__data_link_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6(self):
    self.__data_link_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_data_link_ipv6_gateway(self):
    """
    Getter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_ipv6_gateway (oc-inet:ipv6-address)

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    return self.__data_link_ipv6_gateway
      
  def _set_data_link_ipv6_gateway(self, v, load=False):
    """
    Setter method for data_link_ipv6_gateway, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_ipv6_gateway (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_ipv6_gateway is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_ipv6_gateway() directly.

    YANG Description: If peer data ipv6 is in a different subnet, specify the
gateway ipv6 here to provide reachability
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_ipv6_gateway must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__data_link_ipv6_gateway = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_ipv6_gateway(self):
    self.__data_link_ipv6_gateway = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="data-link-ipv6-gateway", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_data_link_peer_ipv4(self):
    """
    Getter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_peer_ipv4 (oc-inet:ipv4-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    return self.__data_link_peer_ipv4
      
  def _set_data_link_peer_ipv4(self, v, load=False):
    """
    Setter method for data_link_peer_ipv4, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_peer_ipv4 (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv4() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv4 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv4 must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__data_link_peer_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv4(self):
    self.__data_link_peer_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="data-link-peer-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_data_link_peer_ipv6(self):
    """
    Getter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_peer_ipv6 (oc-inet:ipv6-prefix)

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    return self.__data_link_peer_ipv6
      
  def _set_data_link_peer_ipv6(self, v, load=False):
    """
    Setter method for data_link_peer_ipv6, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state/data_link_peer_ipv6 (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_peer_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_peer_ipv6() directly.

    YANG Description: If data link is layer 3, specify the peer's ipv6 address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_peer_ipv6 must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__data_link_peer_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_peer_ipv6(self):
    self.__data_link_peer_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="data-link-peer-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-inet:ipv6-prefix', is_config=False)

  data_link_interface = __builtin__.property(_get_data_link_interface)
  data_link_port = __builtin__.property(_get_data_link_port)
  data_link_ipv4 = __builtin__.property(_get_data_link_ipv4)
  data_link_gateway = __builtin__.property(_get_data_link_gateway)
  data_link_ipv6 = __builtin__.property(_get_data_link_ipv6)
  data_link_ipv6_gateway = __builtin__.property(_get_data_link_ipv6_gateway)
  data_link_peer_ipv4 = __builtin__.property(_get_data_link_peer_ipv4)
  data_link_peer_ipv6 = __builtin__.property(_get_data_link_peer_ipv6)


  _pyangbind_elements = OrderedDict([('data_link_interface', data_link_interface), ('data_link_port', data_link_port), ('data_link_ipv4', data_link_ipv4), ('data_link_gateway', data_link_gateway), ('data_link_ipv6', data_link_ipv6), ('data_link_ipv6_gateway', data_link_ipv6_gateway), ('data_link_peer_ipv4', data_link_peer_ipv4), ('data_link_peer_ipv6', data_link_peer_ipv6), ])


class yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/data-link/backup. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Parameters related to backup HA data link
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'backup'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'data-link', 'backup']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config (container)

    YANG Description: Configuration parameters related to backup HA data link
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /ha_groups/ha_group/data_link/backup/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters related to backup HA data link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state (container)

    YANG Description: Operational state parameters related to backup HA data
link
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /ha_groups/ha_group/data_link/backup/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters related to backup HA data
link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_data_link_openconfig_fw_high_availability__ha_groups_ha_group_data_link(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/data-link. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for HA data link
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__backup',)

  _yang_name = 'data-link'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__backup = YANGDynClass(base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'data-link']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /ha_groups/ha_group/data_link/config (container)

    YANG Description: Configuration parameters related to primary HA data link
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /ha_groups/ha_group/data_link/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters related to primary HA data link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_data_link_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /ha_groups/ha_group/data_link/state (container)

    YANG Description: Operational state parameters related to primary HA data
link
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /ha_groups/ha_group/data_link/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters related to primary HA data
link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_data_link_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_backup(self):
    """
    Getter method for backup, mapped from YANG variable /ha_groups/ha_group/data_link/backup (container)

    YANG Description: Parameters related to backup HA data link
    """
    return self.__backup
      
  def _set_backup(self, v, load=False):
    """
    Setter method for backup, mapped from YANG variable /ha_groups/ha_group/data_link/backup (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_backup is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_backup() directly.

    YANG Description: Parameters related to backup HA data link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """backup must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__backup = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_backup(self):
    self.__backup = YANGDynClass(base=yc_backup_openconfig_fw_high_availability__ha_groups_ha_group_data_link_backup, is_container='container', yang_name="backup", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  backup = __builtin__.property(_get_backup, _set_backup)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('backup', backup), ])


class yc_config_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/interface-groups/interface-group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the interface-groups
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__monitored_interfaces','__group_policy',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=True)
    self.__monitored_interfaces = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__group_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'interface-groups', 'interface-group', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config/id (union)

    YANG Description: Assign a unique id to an interface group
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config/id (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Assign a unique id to an interface group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with union""",
          'defined-type': "openconfig-fw-high-availability:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=True)


  def _get_monitored_interfaces(self):
    """
    Getter method for monitored_interfaces, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config/monitored_interfaces (oc-if:base-interface-ref)

    YANG Description: Interface being monitored
    """
    return self.__monitored_interfaces
      
  def _set_monitored_interfaces(self, v, load=False):
    """
    Setter method for monitored_interfaces, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config/monitored_interfaces (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_monitored_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_monitored_interfaces() directly.

    YANG Description: Interface being monitored
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """monitored_interfaces must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__monitored_interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_monitored_interfaces(self):
    self.__monitored_interfaces = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_group_policy(self):
    """
    Getter method for group_policy, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config/group_policy (enumeration)

    YANG Description: Determines how the State of monitored-interfaces is used to
determine the State of the group they are a member of
    """
    return self.__group_policy
      
  def _set_group_policy(self, v, load=False):
    """
    Setter method for group_policy, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config/group_policy (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_policy() directly.

    YANG Description: Determines how the State of monitored-interfaces is used to
determine the State of the group they are a member of
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_policy must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)""",
        })

    self.__group_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_policy(self):
    self.__group_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  monitored_interfaces = __builtin__.property(_get_monitored_interfaces, _set_monitored_interfaces)
  group_policy = __builtin__.property(_get_group_policy, _set_group_policy)


  _pyangbind_elements = OrderedDict([('id', id), ('monitored_interfaces', monitored_interfaces), ('group_policy', group_policy), ])


class yc_state_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/interface-groups/interface-group/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for monitored interface-groups.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__monitored_interfaces','__group_policy','__group_status',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=False)
    self.__monitored_interfaces = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__group_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    self.__group_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="group-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'interface-groups', 'interface-group', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/id (union)

    YANG Description: Assign a unique id to an interface group
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/id (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Assign a unique id to an interface group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with union""",
          'defined-type': "openconfig-fw-high-availability:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=[RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8),six.text_type,], is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='union', is_config=False)


  def _get_monitored_interfaces(self):
    """
    Getter method for monitored_interfaces, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/monitored_interfaces (oc-if:base-interface-ref)

    YANG Description: Interface being monitored
    """
    return self.__monitored_interfaces
      
  def _set_monitored_interfaces(self, v, load=False):
    """
    Setter method for monitored_interfaces, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/monitored_interfaces (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_monitored_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_monitored_interfaces() directly.

    YANG Description: Interface being monitored
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """monitored_interfaces must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__monitored_interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_monitored_interfaces(self):
    self.__monitored_interfaces = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="monitored-interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_group_policy(self):
    """
    Getter method for group_policy, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/group_policy (enumeration)

    YANG Description: Determines how the State of monitored-interfaces is used to
determine the State of the group they are a member of
    """
    return self.__group_policy
      
  def _set_group_policy(self, v, load=False):
    """
    Setter method for group_policy, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/group_policy (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_policy() directly.

    YANG Description: Determines how the State of monitored-interfaces is used to
determine the State of the group they are a member of
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_policy must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)""",
        })

    self.__group_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_policy(self):
    self.__group_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="group-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)


  def _get_group_status(self):
    """
    Getter method for group_status, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/group_status (enumeration)

    YANG Description: The status of this interface group
    """
    return self.__group_status
      
  def _set_group_status(self, v, load=False):
    """
    Setter method for group_status, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state/group_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_status() directly.

    YANG Description: The status of this interface group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="group-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-fw-high-availability:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="group-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)""",
        })

    self.__group_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_status(self):
    self.__group_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}},), is_leaf=True, yang_name="group-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='enumeration', is_config=False)

  id = __builtin__.property(_get_id)
  monitored_interfaces = __builtin__.property(_get_monitored_interfaces)
  group_policy = __builtin__.property(_get_group_policy)
  group_status = __builtin__.property(_get_group_status)


  _pyangbind_elements = OrderedDict([('id', id), ('monitored_interfaces', monitored_interfaces), ('group_policy', group_policy), ('group_status', group_status), ])


class yc_interface_group_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/interface-groups/interface-group. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interface groups being monitored
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__config','__state',)

  _yang_name = 'interface-group'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'interface-groups', 'interface-group']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/id (leafref)

    YANG Description: Reference to the interface-group key used to bundle
interfaces in a logical group
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to the interface-group key used to bundle
interfaces in a logical group
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config (container)

    YANG Description: Configuration parameters for the interface-groups
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for the interface-groups
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state (container)

    YANG Description: State container for monitored interface-groups.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for monitored interface-groups.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('id', id), ('config', config), ('state', state), ])


class yc_interface_groups_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group/interface-groups. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for monitored interface groups
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_group',)

  _yang_name = 'interface-groups'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_group = YANGDynClass(base=YANGListType("id",yc_interface_group_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group, yang_name="interface-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group', 'interface-groups']

  def _get_interface_group(self):
    """
    Getter method for interface_group, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group (list)

    YANG Description: List of interface groups being monitored
    """
    return self.__interface_group
      
  def _set_interface_group(self, v, load=False):
    """
    Setter method for interface_group, mapped from YANG variable /ha_groups/ha_group/interface_groups/interface_group (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_group() directly.

    YANG Description: List of interface groups being monitored
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_interface_group_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group, yang_name="interface-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_group must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_interface_group_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group, yang_name="interface-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)""",
        })

    self.__interface_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_group(self):
    self.__interface_group = YANGDynClass(base=YANGListType("id",yc_interface_group_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups_interface_group, yang_name="interface-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)

  interface_group = __builtin__.property(_get_interface_group, _set_interface_group)


  _pyangbind_elements = OrderedDict([('interface_group', interface_group), ])


class yc_ha_group_openconfig_fw_high_availability__ha_groups_ha_group(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups/ha-group. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: HA group id used to create a logical HA group
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__config','__state','__control_link','__data_link','__interface_groups',)

  _yang_name = 'ha-group'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__control_link = YANGDynClass(base=yc_control_link_openconfig_fw_high_availability__ha_groups_ha_group_control_link, is_container='container', yang_name="control-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__data_link = YANGDynClass(base=yc_data_link_openconfig_fw_high_availability__ha_groups_ha_group_data_link, is_container='container', yang_name="data-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    self.__interface_groups = YANGDynClass(base=yc_interface_groups_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups, is_container='container', yang_name="interface-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups', 'ha-group']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /ha_groups/ha_group/id (leafref)

    YANG Description: References the group id key.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /ha_groups/ha_group/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: References the group id key.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /ha_groups/ha_group/config (container)

    YANG Description: Config container for HA parameters
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /ha_groups/ha_group/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Config container for HA parameters
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_fw_high_availability__ha_groups_ha_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /ha_groups/ha_group/state (container)

    YANG Description: State container for HA parameters
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /ha_groups/ha_group/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for HA parameters
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_fw_high_availability__ha_groups_ha_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_control_link(self):
    """
    Getter method for control_link, mapped from YANG variable /ha_groups/ha_group/control_link (container)

    YANG Description: Top-level container for HA control link
    """
    return self.__control_link
      
  def _set_control_link(self, v, load=False):
    """
    Setter method for control_link, mapped from YANG variable /ha_groups/ha_group/control_link (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_link is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_link() directly.

    YANG Description: Top-level container for HA control link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_control_link_openconfig_fw_high_availability__ha_groups_ha_group_control_link, is_container='container', yang_name="control-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_link must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_control_link_openconfig_fw_high_availability__ha_groups_ha_group_control_link, is_container='container', yang_name="control-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__control_link = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_link(self):
    self.__control_link = YANGDynClass(base=yc_control_link_openconfig_fw_high_availability__ha_groups_ha_group_control_link, is_container='container', yang_name="control-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_data_link(self):
    """
    Getter method for data_link, mapped from YANG variable /ha_groups/ha_group/data_link (container)

    YANG Description: Top-level container for HA data link
    """
    return self.__data_link
      
  def _set_data_link(self, v, load=False):
    """
    Setter method for data_link, mapped from YANG variable /ha_groups/ha_group/data_link (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link() directly.

    YANG Description: Top-level container for HA data link
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_data_link_openconfig_fw_high_availability__ha_groups_ha_group_data_link, is_container='container', yang_name="data-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_data_link_openconfig_fw_high_availability__ha_groups_ha_group_data_link, is_container='container', yang_name="data-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__data_link = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link(self):
    self.__data_link = YANGDynClass(base=yc_data_link_openconfig_fw_high_availability__ha_groups_ha_group_data_link, is_container='container', yang_name="data-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)


  def _get_interface_groups(self):
    """
    Getter method for interface_groups, mapped from YANG variable /ha_groups/ha_group/interface_groups (container)

    YANG Description: Top level container for monitored interface groups
    """
    return self.__interface_groups
      
  def _set_interface_groups(self, v, load=False):
    """
    Setter method for interface_groups, mapped from YANG variable /ha_groups/ha_group/interface_groups (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_groups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_groups() directly.

    YANG Description: Top level container for monitored interface groups
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_groups_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups, is_container='container', yang_name="interface-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_groups must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_groups_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups, is_container='container', yang_name="interface-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__interface_groups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_groups(self):
    self.__interface_groups = YANGDynClass(base=yc_interface_groups_openconfig_fw_high_availability__ha_groups_ha_group_interface_groups, is_container='container', yang_name="interface-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  control_link = __builtin__.property(_get_control_link, _set_control_link)
  data_link = __builtin__.property(_get_data_link, _set_data_link)
  interface_groups = __builtin__.property(_get_interface_groups, _set_interface_groups)


  _pyangbind_elements = OrderedDict([('id', id), ('config', config), ('state', state), ('control_link', control_link), ('data_link', data_link), ('interface_groups', interface_groups), ])


class yc_ha_groups_openconfig_fw_high_availability__ha_groups(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /ha-groups. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for HA groups
  """
  __slots__ = ('_path_helper', '_extmethods', '__ha_group',)

  _yang_name = 'ha-groups'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ha_group = YANGDynClass(base=YANGListType("id",yc_ha_group_openconfig_fw_high_availability__ha_groups_ha_group, yang_name="ha-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="ha-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['ha-groups']

  def _get_ha_group(self):
    """
    Getter method for ha_group, mapped from YANG variable /ha_groups/ha_group (list)

    YANG Description: HA group id used to create a logical HA group
    """
    return self.__ha_group
      
  def _set_ha_group(self, v, load=False):
    """
    Setter method for ha_group, mapped from YANG variable /ha_groups/ha_group (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_group() directly.

    YANG Description: HA group id used to create a logical HA group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_ha_group_openconfig_fw_high_availability__ha_groups_ha_group, yang_name="ha-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="ha-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_group must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_ha_group_openconfig_fw_high_availability__ha_groups_ha_group, yang_name="ha-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="ha-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)""",
        })

    self.__ha_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_group(self):
    self.__ha_group = YANGDynClass(base=YANGListType("id",yc_ha_group_openconfig_fw_high_availability__ha_groups_ha_group, yang_name="ha-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="ha-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='list', is_config=True)

  ha_group = __builtin__.property(_get_ha_group, _set_ha_group)


  _pyangbind_elements = OrderedDict([('ha_group', ha_group), ])


class openconfig_fw_high_availability(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-high-availability - based on the path /openconfig-fw-high-availability. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Model used to configure & monitor firewall High Availability(HA).
The model is comprised primarily of the following sections -
- Various global config parameters
(such as ha-group-id, ha-mode etc.)
- Control link configuration parameters
(control link is used to exchange HA control msgs)
- Data link configuration parameters
(data link is used to exchange information for seamless failover)
- HA timers

This model also imports/uses the link-monitoring module, to
determine  health of firewall cluster based on the status of the
interfaces being  monitored. Please see that module description
for additional details
  """
  __slots__ = ('_path_helper', '_extmethods', '__ha_groups',)

  _yang_name = 'openconfig-fw-high-availability'
  _yang_namespace = 'http://openconfig.net/yang/oc-fw-ha'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ha_groups = YANGDynClass(base=yc_ha_groups_openconfig_fw_high_availability__ha_groups, is_container='container', yang_name="ha-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_ha_groups(self):
    """
    Getter method for ha_groups, mapped from YANG variable /ha_groups (container)

    YANG Description: Top level container for HA groups
    """
    return self.__ha_groups
      
  def _set_ha_groups(self, v, load=False):
    """
    Setter method for ha_groups, mapped from YANG variable /ha_groups (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ha_groups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ha_groups() directly.

    YANG Description: Top level container for HA groups
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ha_groups_openconfig_fw_high_availability__ha_groups, is_container='container', yang_name="ha-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ha_groups must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ha_groups_openconfig_fw_high_availability__ha_groups, is_container='container', yang_name="ha-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)""",
        })

    self.__ha_groups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ha_groups(self):
    self.__ha_groups = YANGDynClass(base=yc_ha_groups_openconfig_fw_high_availability__ha_groups, is_container='container', yang_name="ha-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/oc-fw-ha', defining_module='openconfig-fw-high-availability', yang_type='container', is_config=True)

  ha_groups = __builtin__.property(_get_ha_groups, _set_ha_groups)


  _pyangbind_elements = OrderedDict([('ha_groups', ha_groups), ])


class openconfig_fw_link_monitoring(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-fw-link-monitoring - based on the path /openconfig-fw-link-monitoring. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This model defines interface groups and corresponding monitoring
policies for firewall HA groups.  It also provides modeling for a
global health monitoring policy for the HA group.
  """
  _pyangbind_elements = {}

  

