# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_ate_intf(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-intf - based on the path /openconfig-ate-intf. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines augments to the OpenConfig tree specifically for
automated test equipment (ATE) devices. These parameters are not widely
supported by non-ATE devices.
  """
  _pyangbind_elements = {}

  

class yc_counters_openconfig_ate_flow__flows_flow_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters that correspond to the individual flow.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__out_octets','__out_pkts',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /flows/flow/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of bytes received by the target for the flow.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /flows/flow/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of bytes received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /flows/flow/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received by the target for the flow.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /flows/flow/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /flows/flow/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /flows/flow/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /flows/flow/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /flows/flow/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('out_octets', out_octets), ('out_pkts', out_pkts), ])


class yc_state_openconfig_ate_flow__flows_flow_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state of the individual flow.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__src_port','__dst_port','__mpls_label','__src_ipv4','__dst_ipv4','__src_ipv6','__dst_ipv6','__vlan_id','__filter','__loss_pct','__out_frame_rate','__in_frame_rate','__out_rate','__in_rate','__first_packet_latency','__convergence_time','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__src_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__dst_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__mpls_label = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)
    self.__src_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__dst_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__src_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__dst_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /flows/flow/state/name (string)

    YANG Description: An arbitary name used for the flow tracked by the system. This
name must be unique for the flows tracked and exported by the target.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /flows/flow/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: An arbitary name used for the flow tracked by the system. This
name must be unique for the flows tracked and exported by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_src_port(self):
    """
    Getter method for src_port, mapped from YANG variable /flows/flow/state/src_port (string)

    YANG Description: Value of the source port for ingress tracking.
    """
    return self.__src_port
      
  def _set_src_port(self, v, load=False):
    """
    Setter method for src_port, mapped from YANG variable /flows/flow/state/src_port (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_port() directly.

    YANG Description: Value of the source port for ingress tracking.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_port must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__src_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_port(self):
    self.__src_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_dst_port(self):
    """
    Getter method for dst_port, mapped from YANG variable /flows/flow/state/dst_port (string)

    YANG Description: Value of the destination port for ingress tracking.
    """
    return self.__dst_port
      
  def _set_dst_port(self, v, load=False):
    """
    Setter method for dst_port, mapped from YANG variable /flows/flow/state/dst_port (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_port() directly.

    YANG Description: Value of the destination port for ingress tracking.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_port must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__dst_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_port(self):
    self.__dst_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_mpls_label(self):
    """
    Getter method for mpls_label, mapped from YANG variable /flows/flow/state/mpls_label (oc-mplst:mpls-label)

    YANG Description: Value of the MPLS label for ingress tracking.
    """
    return self.__mpls_label
      
  def _set_mpls_label(self, v, load=False):
    """
    Setter method for mpls_label, mapped from YANG variable /flows/flow/state/mpls_label (oc-mplst:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mpls_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mpls_label() directly.

    YANG Description: Value of the MPLS label for ingress tracking.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mpls_label must be of a type compatible with oc-mplst:mpls-label""",
          'defined-type': "oc-mplst:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)""",
        })

    self.__mpls_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mpls_label(self):
    self.__mpls_label = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)


  def _get_src_ipv4(self):
    """
    Getter method for src_ipv4, mapped from YANG variable /flows/flow/state/src_ipv4 (oc-inet:ipv4-address)

    YANG Description: The source IPv4 value of the traffic header.
    """
    return self.__src_ipv4
      
  def _set_src_ipv4(self, v, load=False):
    """
    Setter method for src_ipv4, mapped from YANG variable /flows/flow/state/src_ipv4 (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_ipv4() directly.

    YANG Description: The source IPv4 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_ipv4 must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__src_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_ipv4(self):
    self.__src_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_dst_ipv4(self):
    """
    Getter method for dst_ipv4, mapped from YANG variable /flows/flow/state/dst_ipv4 (oc-inet:ipv4-address)

    YANG Description: The destination IPv4 value of the traffic header.
    """
    return self.__dst_ipv4
      
  def _set_dst_ipv4(self, v, load=False):
    """
    Setter method for dst_ipv4, mapped from YANG variable /flows/flow/state/dst_ipv4 (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_ipv4() directly.

    YANG Description: The destination IPv4 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_ipv4 must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__dst_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_ipv4(self):
    self.__dst_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_src_ipv6(self):
    """
    Getter method for src_ipv6, mapped from YANG variable /flows/flow/state/src_ipv6 (oc-inet:ipv6-address)

    YANG Description: The source IPv6 value of the traffic header.
    """
    return self.__src_ipv6
      
  def _set_src_ipv6(self, v, load=False):
    """
    Setter method for src_ipv6, mapped from YANG variable /flows/flow/state/src_ipv6 (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_ipv6() directly.

    YANG Description: The source IPv6 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_ipv6 must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__src_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_ipv6(self):
    self.__src_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_dst_ipv6(self):
    """
    Getter method for dst_ipv6, mapped from YANG variable /flows/flow/state/dst_ipv6 (oc-inet:ipv6-address)

    YANG Description: The destination IPv6 value of the traffic header.
    """
    return self.__dst_ipv6
      
  def _set_dst_ipv6(self, v, load=False):
    """
    Setter method for dst_ipv6, mapped from YANG variable /flows/flow/state/dst_ipv6 (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_ipv6() directly.

    YANG Description: The destination IPv6 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_ipv6 must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__dst_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_ipv6(self):
    self.__dst_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /flows/flow/state/vlan_id (oc-vlan:vlan-id)

    YANG Description: The VLAN ID of the traffic header.
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /flows/flow/state/vlan_id (oc-vlan:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: The VLAN ID of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with oc-vlan:vlan-id""",
          'defined-type': "oc-vlan:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)


  def _get_filter(self):
    """
    Getter method for filter, mapped from YANG variable /flows/flow/state/filter (string)

    YANG Description: Name of the filter on which the egress stats are tracked
    """
    return self.__filter
      
  def _set_filter(self, v, load=False):
    """
    Setter method for filter, mapped from YANG variable /flows/flow/state/filter (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_filter() directly.

    YANG Description: Name of the filter on which the egress stats are tracked
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """filter must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_filter(self):
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_loss_pct(self):
    """
    Getter method for loss_pct, mapped from YANG variable /flows/flow/state/loss_pct (oc-types:ieeefloat32)

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    return self.__loss_pct
      
  def _set_loss_pct(self, v, load=False):
    """
    Setter method for loss_pct, mapped from YANG variable /flows/flow/state/loss_pct (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loss_pct is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loss_pct() directly.

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loss_pct must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__loss_pct = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loss_pct(self):
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_frame_rate(self):
    """
    Getter method for out_frame_rate, mapped from YANG variable /flows/flow/state/out_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    return self.__out_frame_rate
      
  def _set_out_frame_rate(self, v, load=False):
    """
    Setter method for out_frame_rate, mapped from YANG variable /flows/flow/state/out_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_frame_rate(self):
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_frame_rate(self):
    """
    Getter method for in_frame_rate, mapped from YANG variable /flows/flow/state/in_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    return self.__in_frame_rate
      
  def _set_in_frame_rate(self, v, load=False):
    """
    Setter method for in_frame_rate, mapped from YANG variable /flows/flow/state/in_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_frame_rate(self):
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_rate(self):
    """
    Getter method for out_rate, mapped from YANG variable /flows/flow/state/out_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    return self.__out_rate
      
  def _set_out_rate(self, v, load=False):
    """
    Setter method for out_rate, mapped from YANG variable /flows/flow/state/out_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_rate(self):
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_rate(self):
    """
    Getter method for in_rate, mapped from YANG variable /flows/flow/state/in_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    return self.__in_rate
      
  def _set_in_rate(self, v, load=False):
    """
    Setter method for in_rate, mapped from YANG variable /flows/flow/state/in_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_rate(self):
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_first_packet_latency(self):
    """
    Getter method for first_packet_latency, mapped from YANG variable /flows/flow/state/first_packet_latency (oc-types:timeticks64)

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    return self.__first_packet_latency
      
  def _set_first_packet_latency(self, v, load=False):
    """
    Setter method for first_packet_latency, mapped from YANG variable /flows/flow/state/first_packet_latency (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_first_packet_latency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_first_packet_latency() directly.

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """first_packet_latency must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__first_packet_latency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_first_packet_latency(self):
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_convergence_time(self):
    """
    Getter method for convergence_time, mapped from YANG variable /flows/flow/state/convergence_time (oc-types:timeticks64)

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    return self.__convergence_time
      
  def _set_convergence_time(self, v, load=False):
    """
    Setter method for convergence_time, mapped from YANG variable /flows/flow/state/convergence_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_convergence_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_convergence_time() directly.

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """convergence_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__convergence_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_convergence_time(self):
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /flows/flow/state/counters (container)

    YANG Description: Counters that correspond to the individual flow.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /flows/flow/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters that correspond to the individual flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_ate_flow__flows_flow_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  src_port = __builtin__.property(_get_src_port)
  dst_port = __builtin__.property(_get_dst_port)
  mpls_label = __builtin__.property(_get_mpls_label)
  src_ipv4 = __builtin__.property(_get_src_ipv4)
  dst_ipv4 = __builtin__.property(_get_dst_ipv4)
  src_ipv6 = __builtin__.property(_get_src_ipv6)
  dst_ipv6 = __builtin__.property(_get_dst_ipv6)
  vlan_id = __builtin__.property(_get_vlan_id)
  filter = __builtin__.property(_get_filter)
  loss_pct = __builtin__.property(_get_loss_pct)
  out_frame_rate = __builtin__.property(_get_out_frame_rate)
  in_frame_rate = __builtin__.property(_get_in_frame_rate)
  out_rate = __builtin__.property(_get_out_rate)
  in_rate = __builtin__.property(_get_in_rate)
  first_packet_latency = __builtin__.property(_get_first_packet_latency)
  convergence_time = __builtin__.property(_get_convergence_time)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('src_port', src_port), ('dst_port', dst_port), ('mpls_label', mpls_label), ('src_ipv4', src_ipv4), ('dst_ipv4', dst_ipv4), ('src_ipv6', src_ipv6), ('dst_ipv6', dst_ipv6), ('vlan_id', vlan_id), ('filter', filter), ('loss_pct', loss_pct), ('out_frame_rate', out_frame_rate), ('in_frame_rate', in_frame_rate), ('out_rate', out_rate), ('in_rate', in_rate), ('first_packet_latency', first_packet_latency), ('convergence_time', convergence_time), ('counters', counters), ])


class yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking/ingress-tracking/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters that correspond to the flow by ingress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__out_octets','__out_pkts',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking', 'ingress-tracking', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of bytes received by the target for the flow.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of bytes received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received by the target for the flow.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('out_octets', out_octets), ('out_pkts', out_pkts), ])


class yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking/ingress-tracking/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state of the flow by ingress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__src_port','__dst_port','__mpls_label','__src_ipv4','__dst_ipv4','__src_ipv6','__dst_ipv6','__vlan_id','__filter','__loss_pct','__out_frame_rate','__in_frame_rate','__out_rate','__in_rate','__first_packet_latency','__convergence_time','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__src_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__dst_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__mpls_label = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)
    self.__src_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__dst_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    self.__src_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__dst_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking', 'ingress-tracking', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/name (string)

    YANG Description: An arbitary name used for the flow tracked by the system. This
name must be unique for the flows tracked and exported by the target.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: An arbitary name used for the flow tracked by the system. This
name must be unique for the flows tracked and exported by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_src_port(self):
    """
    Getter method for src_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/src_port (string)

    YANG Description: Value of the source port for ingress tracking.
    """
    return self.__src_port
      
  def _set_src_port(self, v, load=False):
    """
    Setter method for src_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/src_port (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_port() directly.

    YANG Description: Value of the source port for ingress tracking.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_port must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__src_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_port(self):
    self.__src_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_dst_port(self):
    """
    Getter method for dst_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/dst_port (string)

    YANG Description: Value of the destination port for ingress tracking.
    """
    return self.__dst_port
      
  def _set_dst_port(self, v, load=False):
    """
    Setter method for dst_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/dst_port (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_port() directly.

    YANG Description: Value of the destination port for ingress tracking.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_port must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__dst_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_port(self):
    self.__dst_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_mpls_label(self):
    """
    Getter method for mpls_label, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/mpls_label (oc-mplst:mpls-label)

    YANG Description: Value of the MPLS label for ingress tracking.
    """
    return self.__mpls_label
      
  def _set_mpls_label(self, v, load=False):
    """
    Setter method for mpls_label, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/mpls_label (oc-mplst:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mpls_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mpls_label() directly.

    YANG Description: Value of the MPLS label for ingress tracking.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mpls_label must be of a type compatible with oc-mplst:mpls-label""",
          'defined-type': "oc-mplst:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)""",
        })

    self.__mpls_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mpls_label(self):
    self.__mpls_label = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-mplst:mpls-label', is_config=False)


  def _get_src_ipv4(self):
    """
    Getter method for src_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/src_ipv4 (oc-inet:ipv4-address)

    YANG Description: The source IPv4 value of the traffic header.
    """
    return self.__src_ipv4
      
  def _set_src_ipv4(self, v, load=False):
    """
    Setter method for src_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/src_ipv4 (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_ipv4() directly.

    YANG Description: The source IPv4 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_ipv4 must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__src_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_ipv4(self):
    self.__src_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_dst_ipv4(self):
    """
    Getter method for dst_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/dst_ipv4 (oc-inet:ipv4-address)

    YANG Description: The destination IPv4 value of the traffic header.
    """
    return self.__dst_ipv4
      
  def _set_dst_ipv4(self, v, load=False):
    """
    Setter method for dst_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/dst_ipv4 (oc-inet:ipv4-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_ipv4() directly.

    YANG Description: The destination IPv4 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_ipv4 must be of a type compatible with oc-inet:ipv4-address""",
          'defined-type': "oc-inet:ipv4-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)""",
        })

    self.__dst_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_ipv4(self):
    self.__dst_ipv4 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv4-address', is_config=False)


  def _get_src_ipv6(self):
    """
    Getter method for src_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/src_ipv6 (oc-inet:ipv6-address)

    YANG Description: The source IPv6 value of the traffic header.
    """
    return self.__src_ipv6
      
  def _set_src_ipv6(self, v, load=False):
    """
    Setter method for src_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/src_ipv6 (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_ipv6() directly.

    YANG Description: The source IPv6 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_ipv6 must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__src_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_ipv6(self):
    self.__src_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_dst_ipv6(self):
    """
    Getter method for dst_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/dst_ipv6 (oc-inet:ipv6-address)

    YANG Description: The destination IPv6 value of the traffic header.
    """
    return self.__dst_ipv6
      
  def _set_dst_ipv6(self, v, load=False):
    """
    Setter method for dst_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/dst_ipv6 (oc-inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_ipv6() directly.

    YANG Description: The destination IPv6 value of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_ipv6 must be of a type compatible with oc-inet:ipv6-address""",
          'defined-type': "oc-inet:ipv6-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)""",
        })

    self.__dst_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_ipv6(self):
    self.__dst_ipv6 = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}), is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-inet:ipv6-address', is_config=False)


  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/vlan_id (oc-vlan:vlan-id)

    YANG Description: The VLAN ID of the traffic header.
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/vlan_id (oc-vlan:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: The VLAN ID of the traffic header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with oc-vlan:vlan-id""",
          'defined-type': "oc-vlan:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-vlan:vlan-id', is_config=False)


  def _get_filter(self):
    """
    Getter method for filter, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/filter (string)

    YANG Description: Name of the filter on which the egress stats are tracked
    """
    return self.__filter
      
  def _set_filter(self, v, load=False):
    """
    Setter method for filter, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/filter (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_filter() directly.

    YANG Description: Name of the filter on which the egress stats are tracked
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """filter must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_filter(self):
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_loss_pct(self):
    """
    Getter method for loss_pct, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/loss_pct (oc-types:ieeefloat32)

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    return self.__loss_pct
      
  def _set_loss_pct(self, v, load=False):
    """
    Setter method for loss_pct, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/loss_pct (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loss_pct is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loss_pct() directly.

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loss_pct must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__loss_pct = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loss_pct(self):
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_frame_rate(self):
    """
    Getter method for out_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/out_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    return self.__out_frame_rate
      
  def _set_out_frame_rate(self, v, load=False):
    """
    Setter method for out_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/out_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_frame_rate(self):
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_frame_rate(self):
    """
    Getter method for in_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/in_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    return self.__in_frame_rate
      
  def _set_in_frame_rate(self, v, load=False):
    """
    Setter method for in_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/in_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_frame_rate(self):
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_rate(self):
    """
    Getter method for out_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/out_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    return self.__out_rate
      
  def _set_out_rate(self, v, load=False):
    """
    Setter method for out_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/out_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_rate(self):
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_rate(self):
    """
    Getter method for in_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/in_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    return self.__in_rate
      
  def _set_in_rate(self, v, load=False):
    """
    Setter method for in_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/in_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_rate(self):
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_first_packet_latency(self):
    """
    Getter method for first_packet_latency, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/first_packet_latency (oc-types:timeticks64)

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    return self.__first_packet_latency
      
  def _set_first_packet_latency(self, v, load=False):
    """
    Setter method for first_packet_latency, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/first_packet_latency (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_first_packet_latency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_first_packet_latency() directly.

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """first_packet_latency must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__first_packet_latency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_first_packet_latency(self):
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_convergence_time(self):
    """
    Getter method for convergence_time, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/convergence_time (oc-types:timeticks64)

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    return self.__convergence_time
      
  def _set_convergence_time(self, v, load=False):
    """
    Setter method for convergence_time, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/convergence_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_convergence_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_convergence_time() directly.

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """convergence_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__convergence_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_convergence_time(self):
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters (container)

    YANG Description: Counters that correspond to the flow by ingress tracking filter.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters that correspond to the flow by ingress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  src_port = __builtin__.property(_get_src_port)
  dst_port = __builtin__.property(_get_dst_port)
  mpls_label = __builtin__.property(_get_mpls_label)
  src_ipv4 = __builtin__.property(_get_src_ipv4)
  dst_ipv4 = __builtin__.property(_get_dst_ipv4)
  src_ipv6 = __builtin__.property(_get_src_ipv6)
  dst_ipv6 = __builtin__.property(_get_dst_ipv6)
  vlan_id = __builtin__.property(_get_vlan_id)
  filter = __builtin__.property(_get_filter)
  loss_pct = __builtin__.property(_get_loss_pct)
  out_frame_rate = __builtin__.property(_get_out_frame_rate)
  in_frame_rate = __builtin__.property(_get_in_frame_rate)
  out_rate = __builtin__.property(_get_out_rate)
  in_rate = __builtin__.property(_get_in_rate)
  first_packet_latency = __builtin__.property(_get_first_packet_latency)
  convergence_time = __builtin__.property(_get_convergence_time)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('src_port', src_port), ('dst_port', dst_port), ('mpls_label', mpls_label), ('src_ipv4', src_ipv4), ('dst_ipv4', dst_ipv4), ('src_ipv6', src_ipv6), ('dst_ipv6', dst_ipv6), ('vlan_id', vlan_id), ('filter', filter), ('loss_pct', loss_pct), ('out_frame_rate', out_frame_rate), ('in_frame_rate', in_frame_rate), ('out_rate', out_rate), ('in_rate', in_rate), ('first_packet_latency', first_packet_latency), ('convergence_time', convergence_time), ('counters', counters), ])


class yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking/ingress-tracking/egress-tracking/egress-tracking/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters that correspond to the flow by egress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__out_octets','__out_pkts',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking', 'ingress-tracking', 'egress-tracking', 'egress-tracking', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of bytes received by the target for the flow.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of bytes received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received by the target for the flow.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('out_octets', out_octets), ('out_pkts', out_pkts), ])


class yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking/ingress-tracking/egress-tracking/egress-tracking/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state of the flow by egress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__filter','__loss_pct','__out_frame_rate','__in_frame_rate','__out_rate','__in_rate','__first_packet_latency','__convergence_time','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking', 'ingress-tracking', 'egress-tracking', 'egress-tracking', 'state']

  def _get_filter(self):
    """
    Getter method for filter, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/filter (string)

    YANG Description: Value of the filter on which the egress stats are tracked
    """
    return self.__filter
      
  def _set_filter(self, v, load=False):
    """
    Setter method for filter, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/filter (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_filter() directly.

    YANG Description: Value of the filter on which the egress stats are tracked
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """filter must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_filter(self):
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_loss_pct(self):
    """
    Getter method for loss_pct, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/loss_pct (oc-types:ieeefloat32)

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    return self.__loss_pct
      
  def _set_loss_pct(self, v, load=False):
    """
    Setter method for loss_pct, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/loss_pct (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loss_pct is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loss_pct() directly.

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loss_pct must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__loss_pct = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loss_pct(self):
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_frame_rate(self):
    """
    Getter method for out_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/out_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    return self.__out_frame_rate
      
  def _set_out_frame_rate(self, v, load=False):
    """
    Setter method for out_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/out_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_frame_rate(self):
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_frame_rate(self):
    """
    Getter method for in_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/in_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    return self.__in_frame_rate
      
  def _set_in_frame_rate(self, v, load=False):
    """
    Setter method for in_frame_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/in_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_frame_rate(self):
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_rate(self):
    """
    Getter method for out_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/out_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    return self.__out_rate
      
  def _set_out_rate(self, v, load=False):
    """
    Setter method for out_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/out_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_rate(self):
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_rate(self):
    """
    Getter method for in_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/in_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    return self.__in_rate
      
  def _set_in_rate(self, v, load=False):
    """
    Setter method for in_rate, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/in_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_rate(self):
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_first_packet_latency(self):
    """
    Getter method for first_packet_latency, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/first_packet_latency (oc-types:timeticks64)

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    return self.__first_packet_latency
      
  def _set_first_packet_latency(self, v, load=False):
    """
    Setter method for first_packet_latency, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/first_packet_latency (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_first_packet_latency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_first_packet_latency() directly.

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """first_packet_latency must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__first_packet_latency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_first_packet_latency(self):
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_convergence_time(self):
    """
    Getter method for convergence_time, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/convergence_time (oc-types:timeticks64)

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    return self.__convergence_time
      
  def _set_convergence_time(self, v, load=False):
    """
    Setter method for convergence_time, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/convergence_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_convergence_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_convergence_time() directly.

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """convergence_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__convergence_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_convergence_time(self):
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters (container)

    YANG Description: Counters that correspond to the flow by egress tracking filter.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters that correspond to the flow by egress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  filter = __builtin__.property(_get_filter)
  loss_pct = __builtin__.property(_get_loss_pct)
  out_frame_rate = __builtin__.property(_get_out_frame_rate)
  in_frame_rate = __builtin__.property(_get_in_frame_rate)
  out_rate = __builtin__.property(_get_out_rate)
  in_rate = __builtin__.property(_get_in_rate)
  first_packet_latency = __builtin__.property(_get_first_packet_latency)
  convergence_time = __builtin__.property(_get_convergence_time)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('filter', filter), ('loss_pct', loss_pct), ('out_frame_rate', out_frame_rate), ('in_frame_rate', in_frame_rate), ('out_rate', out_rate), ('in_rate', in_rate), ('first_packet_latency', first_packet_latency), ('convergence_time', convergence_time), ('counters', counters), ])


class yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking/ingress-tracking/egress-tracking/egress-tracking. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: If the ATE is configured to track outgoing frames by a header field,
this list will map values of that header field to the flow statistics
specific to frames that match that value.
  """
  __slots__ = ('_path_helper', '_extmethods', '__filter','__state',)

  _yang_name = 'egress-tracking'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking', 'ingress-tracking', 'egress-tracking', 'egress-tracking']

  def _get_filter(self):
    """
    Getter method for filter, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/filter (leafref)

    YANG Description: The filter value of the egress tracking configuration.
    """
    return self.__filter
      
  def _set_filter(self, v, load=False):
    """
    Setter method for filter, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/filter (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_filter() directly.

    YANG Description: The filter value of the egress tracking configuration.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """filter must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_filter(self):
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state (container)

    YANG Description: Operational state of the flow by egress tracking filter.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state of the flow by egress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  filter = __builtin__.property(_get_filter)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('filter', filter), ('state', state), ])


class yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking/ingress-tracking/egress-tracking. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Flow statistics grouped by egress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__egress_tracking',)

  _yang_name = 'egress-tracking'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__egress_tracking = YANGDynClass(base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking', 'ingress-tracking', 'egress-tracking']

  def _get_egress_tracking(self):
    """
    Getter method for egress_tracking, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking (list)

    YANG Description: If the ATE is configured to track outgoing frames by a header field,
this list will map values of that header field to the flow statistics
specific to frames that match that value.
    """
    return self.__egress_tracking
      
  def _set_egress_tracking(self, v, load=False):
    """
    Setter method for egress_tracking, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking/egress_tracking (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_tracking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_tracking() directly.

    YANG Description: If the ATE is configured to track outgoing frames by a header field,
this list will map values of that header field to the flow statistics
specific to frames that match that value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_tracking must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)""",
        })

    self.__egress_tracking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_tracking(self):
    self.__egress_tracking = YANGDynClass(base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)

  egress_tracking = __builtin__.property(_get_egress_tracking)


  _pyangbind_elements = OrderedDict([('egress_tracking', egress_tracking), ])


class yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking/ingress-tracking. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: If the ATE is configured to track incoming frames by their header
fields, this list will map combinations of values of those header
fields to the flow statistics specific to frames that match that
combination.
  """
  __slots__ = ('_path_helper', '_extmethods', '__src_port','__dst_port','__mpls_label','__src_ipv4','__dst_ipv4','__src_ipv6','__dst_ipv6','__vlan_id','__state','__egress_tracking',)

  _yang_name = 'ingress-tracking'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__src_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__dst_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__mpls_label = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__src_ipv4 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__dst_ipv4 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__src_ipv6 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__dst_ipv6 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__vlan_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    self.__egress_tracking = YANGDynClass(base=yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking', 'ingress-tracking']

  def _get_src_port(self):
    """
    Getter method for src_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/src_port (leafref)

    YANG Description: Value of the source port for ingress tracking.
    """
    return self.__src_port
      
  def _set_src_port(self, v, load=False):
    """
    Setter method for src_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/src_port (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_port() directly.

    YANG Description: Value of the source port for ingress tracking.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_port must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__src_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_port(self):
    self.__src_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_dst_port(self):
    """
    Getter method for dst_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/dst_port (leafref)

    YANG Description: Value of the destination port for ingress tracking.
    """
    return self.__dst_port
      
  def _set_dst_port(self, v, load=False):
    """
    Setter method for dst_port, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/dst_port (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_port() directly.

    YANG Description: Value of the destination port for ingress tracking.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_port must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__dst_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_port(self):
    self.__dst_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_mpls_label(self):
    """
    Getter method for mpls_label, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/mpls_label (leafref)

    YANG Description: The MPLS label value of the traffic header.
    """
    return self.__mpls_label
      
  def _set_mpls_label(self, v, load=False):
    """
    Setter method for mpls_label, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/mpls_label (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mpls_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mpls_label() directly.

    YANG Description: The MPLS label value of the traffic header.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mpls_label must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__mpls_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mpls_label(self):
    self.__mpls_label = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mpls-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_src_ipv4(self):
    """
    Getter method for src_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/src_ipv4 (leafref)

    YANG Description: The src IPv4 value of the traffic header.
    """
    return self.__src_ipv4
      
  def _set_src_ipv4(self, v, load=False):
    """
    Setter method for src_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/src_ipv4 (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_ipv4() directly.

    YANG Description: The src IPv4 value of the traffic header.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_ipv4 must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__src_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_ipv4(self):
    self.__src_ipv4 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_dst_ipv4(self):
    """
    Getter method for dst_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/dst_ipv4 (leafref)

    YANG Description: The dst IPv4 value of the traffic header.
    """
    return self.__dst_ipv4
      
  def _set_dst_ipv4(self, v, load=False):
    """
    Setter method for dst_ipv4, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/dst_ipv4 (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_ipv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_ipv4() directly.

    YANG Description: The dst IPv4 value of the traffic header.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_ipv4 must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__dst_ipv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_ipv4(self):
    self.__dst_ipv4 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-ipv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_src_ipv6(self):
    """
    Getter method for src_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/src_ipv6 (leafref)

    YANG Description: The src IPv6 value of the traffic header.
    """
    return self.__src_ipv6
      
  def _set_src_ipv6(self, v, load=False):
    """
    Setter method for src_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/src_ipv6 (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_src_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_src_ipv6() directly.

    YANG Description: The src IPv6 value of the traffic header.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """src_ipv6 must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__src_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_src_ipv6(self):
    self.__src_ipv6 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="src-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_dst_ipv6(self):
    """
    Getter method for dst_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/dst_ipv6 (leafref)

    YANG Description: The dst IPv6 value of the traffic header.
    """
    return self.__dst_ipv6
      
  def _set_dst_ipv6(self, v, load=False):
    """
    Setter method for dst_ipv6, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/dst_ipv6 (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dst_ipv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dst_ipv6() directly.

    YANG Description: The dst IPv6 value of the traffic header.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dst_ipv6 must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__dst_ipv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dst_ipv6(self):
    self.__dst_ipv6 = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="dst-ipv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/vlan_id (leafref)

    YANG Description: The VLAN ID value of the traffic header.
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/vlan_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: The VLAN ID value of the traffic header.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state (container)

    YANG Description: Operational state of the flow by ingress tracking filter.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state of the flow by ingress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)


  def _get_egress_tracking(self):
    """
    Getter method for egress_tracking, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking (container)

    YANG Description: Flow statistics grouped by egress tracking filter.
    """
    return self.__egress_tracking
      
  def _set_egress_tracking(self, v, load=False):
    """
    Setter method for egress_tracking, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking/egress_tracking (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_tracking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_tracking() directly.

    YANG Description: Flow statistics grouped by egress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_tracking must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__egress_tracking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_tracking(self):
    self.__egress_tracking = YANGDynClass(base=yc_egress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  src_port = __builtin__.property(_get_src_port)
  dst_port = __builtin__.property(_get_dst_port)
  mpls_label = __builtin__.property(_get_mpls_label)
  src_ipv4 = __builtin__.property(_get_src_ipv4)
  dst_ipv4 = __builtin__.property(_get_dst_ipv4)
  src_ipv6 = __builtin__.property(_get_src_ipv6)
  dst_ipv6 = __builtin__.property(_get_dst_ipv6)
  vlan_id = __builtin__.property(_get_vlan_id)
  state = __builtin__.property(_get_state)
  egress_tracking = __builtin__.property(_get_egress_tracking)


  _pyangbind_elements = OrderedDict([('src_port', src_port), ('dst_port', dst_port), ('mpls_label', mpls_label), ('src_ipv4', src_ipv4), ('dst_ipv4', dst_ipv4), ('src_ipv6', src_ipv6), ('dst_ipv6', dst_ipv6), ('vlan_id', vlan_id), ('state', state), ('egress_tracking', egress_tracking), ])


class yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/ingress-tracking. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Flow statistics grouped by ingress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__ingress_tracking',)

  _yang_name = 'ingress-tracking'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ingress_tracking = YANGDynClass(base=YANGListType("src_port dst_port mpls_label src_ipv4 dst_ipv4 src_ipv6 dst_ipv6 vlan_id",yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking, yang_name="ingress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='src-port dst-port mpls-label src-ipv4 dst-ipv4 src-ipv6 dst-ipv6 vlan-id', extensions=None), is_container='list', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'ingress-tracking']

  def _get_ingress_tracking(self):
    """
    Getter method for ingress_tracking, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking (list)

    YANG Description: If the ATE is configured to track incoming frames by their header
fields, this list will map combinations of values of those header
fields to the flow statistics specific to frames that match that
combination.
    """
    return self.__ingress_tracking
      
  def _set_ingress_tracking(self, v, load=False):
    """
    Setter method for ingress_tracking, mapped from YANG variable /flows/flow/ingress_tracking/ingress_tracking (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress_tracking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress_tracking() directly.

    YANG Description: If the ATE is configured to track incoming frames by their header
fields, this list will map combinations of values of those header
fields to the flow statistics specific to frames that match that
combination.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("src_port dst_port mpls_label src_ipv4 dst_ipv4 src_ipv6 dst_ipv6 vlan_id",yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking, yang_name="ingress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='src-port dst-port mpls-label src-ipv4 dst-ipv4 src-ipv6 dst-ipv6 vlan-id', extensions=None), is_container='list', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress_tracking must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("src_port dst_port mpls_label src_ipv4 dst_ipv4 src_ipv6 dst_ipv6 vlan_id",yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking, yang_name="ingress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='src-port dst-port mpls-label src-ipv4 dst-ipv4 src-ipv6 dst-ipv6 vlan-id', extensions=None), is_container='list', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)""",
        })

    self.__ingress_tracking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress_tracking(self):
    self.__ingress_tracking = YANGDynClass(base=YANGListType("src_port dst_port mpls_label src_ipv4 dst_ipv4 src_ipv6 dst_ipv6 vlan_id",yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking_ingress_tracking, yang_name="ingress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='src-port dst-port mpls-label src-ipv4 dst-ipv4 src-ipv6 dst-ipv6 vlan-id', extensions=None), is_container='list', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)

  ingress_tracking = __builtin__.property(_get_ingress_tracking)


  _pyangbind_elements = OrderedDict([('ingress_tracking', ingress_tracking), ])


class yc_counters_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/egress-tracking/egress-tracking/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters that correspond to the flow by egress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__out_octets','__out_pkts',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'egress-tracking', 'egress-tracking', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of bytes received by the target for the flow.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of bytes received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received by the target for the flow.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received by the target for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of bytes sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets sent by the target for the flow. These
packets may be generated or forwarded by the target.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-yang:counter64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('out_octets', out_octets), ('out_pkts', out_pkts), ])


class yc_state_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/egress-tracking/egress-tracking/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state of the flow by egress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__filter','__loss_pct','__out_frame_rate','__in_frame_rate','__out_rate','__in_rate','__first_packet_latency','__convergence_time','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'egress-tracking', 'egress-tracking', 'state']

  def _get_filter(self):
    """
    Getter method for filter, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/filter (string)

    YANG Description: Value of the filter on which the egress stats are tracked
    """
    return self.__filter
      
  def _set_filter(self, v, load=False):
    """
    Setter method for filter, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/filter (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_filter() directly.

    YANG Description: Value of the filter on which the egress stats are tracked
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """filter must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)""",
        })

    self.__filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_filter(self):
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='string', is_config=False)


  def _get_loss_pct(self):
    """
    Getter method for loss_pct, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/loss_pct (oc-types:ieeefloat32)

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    return self.__loss_pct
      
  def _set_loss_pct(self, v, load=False):
    """
    Setter method for loss_pct, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/loss_pct (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loss_pct is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loss_pct() directly.

    YANG Description: The percentage of transmitted packets that were not received by the
destinations of the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loss_pct must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__loss_pct = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loss_pct(self):
    self.__loss_pct = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="loss-pct", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_frame_rate(self):
    """
    Getter method for out_frame_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/out_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    return self.__out_frame_rate
      
  def _set_out_frame_rate(self, v, load=False):
    """
    Setter method for out_frame_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/out_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
transmitted for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_frame_rate(self):
    self.__out_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_frame_rate(self):
    """
    Getter method for in_frame_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/in_frame_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    return self.__in_frame_rate
      
  def _set_in_frame_rate(self, v, load=False):
    """
    Setter method for in_frame_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/in_frame_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_frame_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_frame_rate() directly.

    YANG Description: The rate, measured in frames per second, at which frames are being
received for the flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_frame_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_frame_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_frame_rate(self):
    self.__in_frame_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-frame-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_out_rate(self):
    """
    Getter method for out_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/out_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    return self.__out_rate
      
  def _set_out_rate(self, v, load=False):
    """
    Setter method for out_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/out_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
transmitted.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__out_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_rate(self):
    self.__out_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="out-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_in_rate(self):
    """
    Getter method for in_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/in_rate (oc-types:ieeefloat32)

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    return self.__in_rate
      
  def _set_in_rate(self, v, load=False):
    """
    Setter method for in_rate, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/in_rate (oc-types:ieeefloat32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_rate() directly.

    YANG Description: The rate, measured in bits per second, at which the flow is being
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_rate must be of a type compatible with oc-types:ieeefloat32""",
          'defined-type': "oc-types:ieeefloat32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)""",
        })

    self.__in_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_rate(self):
    self.__in_rate = YANGDynClass(base=RestrictedClassType(base_type=bitarray, restriction_dict={'length': ['4']}), is_leaf=True, yang_name="in-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:ieeefloat32', is_config=False)


  def _get_first_packet_latency(self):
    """
    Getter method for first_packet_latency, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/first_packet_latency (oc-types:timeticks64)

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    return self.__first_packet_latency
      
  def _set_first_packet_latency(self, v, load=False):
    """
    Setter method for first_packet_latency, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/first_packet_latency (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_first_packet_latency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_first_packet_latency() directly.

    YANG Description: The time from when the flow was started to when the first packet was
received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """first_packet_latency must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__first_packet_latency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_first_packet_latency(self):
    self.__first_packet_latency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="first-packet-latency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_convergence_time(self):
    """
    Getter method for convergence_time, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/convergence_time (oc-types:timeticks64)

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    return self.__convergence_time
      
  def _set_convergence_time(self, v, load=False):
    """
    Setter method for convergence_time, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/convergence_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_convergence_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_convergence_time() directly.

    YANG Description: The time from when the first packet was received to when traffic
loss dropped below a minimal threshold value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """convergence_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__convergence_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_convergence_time(self):
    self.__convergence_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="convergence-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='oc-types:timeticks64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters (container)

    YANG Description: Counters that correspond to the flow by egress tracking filter.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters that correspond to the flow by egress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  filter = __builtin__.property(_get_filter)
  loss_pct = __builtin__.property(_get_loss_pct)
  out_frame_rate = __builtin__.property(_get_out_frame_rate)
  in_frame_rate = __builtin__.property(_get_in_frame_rate)
  out_rate = __builtin__.property(_get_out_rate)
  in_rate = __builtin__.property(_get_in_rate)
  first_packet_latency = __builtin__.property(_get_first_packet_latency)
  convergence_time = __builtin__.property(_get_convergence_time)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('filter', filter), ('loss_pct', loss_pct), ('out_frame_rate', out_frame_rate), ('in_frame_rate', in_frame_rate), ('out_rate', out_rate), ('in_rate', in_rate), ('first_packet_latency', first_packet_latency), ('convergence_time', convergence_time), ('counters', counters), ])


class yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/egress-tracking/egress-tracking. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: If the ATE is configured to track outgoing frames by a header field,
this list will map values of that header field to the flow statistics
specific to frames that match that value.
  """
  __slots__ = ('_path_helper', '_extmethods', '__filter','__state',)

  _yang_name = 'egress-tracking'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'egress-tracking', 'egress-tracking']

  def _get_filter(self):
    """
    Getter method for filter, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/filter (leafref)

    YANG Description: The filter value of the egress tracking configuration.
    """
    return self.__filter
      
  def _set_filter(self, v, load=False):
    """
    Setter method for filter, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/filter (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_filter() directly.

    YANG Description: The filter value of the egress tracking configuration.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """filter must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_filter(self):
    self.__filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state (container)

    YANG Description: Operational state of the flow by egress tracking filter.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state of the flow by egress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  filter = __builtin__.property(_get_filter)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('filter', filter), ('state', state), ])


class yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow/egress-tracking. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Flow statistics grouped by egress tracking filter.
  """
  __slots__ = ('_path_helper', '_extmethods', '__egress_tracking',)

  _yang_name = 'egress-tracking'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__egress_tracking = YANGDynClass(base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow', 'egress-tracking']

  def _get_egress_tracking(self):
    """
    Getter method for egress_tracking, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking (list)

    YANG Description: If the ATE is configured to track outgoing frames by a header field,
this list will map values of that header field to the flow statistics
specific to frames that match that value.
    """
    return self.__egress_tracking
      
  def _set_egress_tracking(self, v, load=False):
    """
    Setter method for egress_tracking, mapped from YANG variable /flows/flow/egress_tracking/egress_tracking (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_tracking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_tracking() directly.

    YANG Description: If the ATE is configured to track outgoing frames by a header field,
this list will map values of that header field to the flow statistics
specific to frames that match that value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_tracking must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)""",
        })

    self.__egress_tracking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_tracking(self):
    self.__egress_tracking = YANGDynClass(base=YANGListType("filter",yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking_egress_tracking, yang_name="egress-tracking", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='filter', extensions=None), is_container='list', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=False)

  egress_tracking = __builtin__.property(_get_egress_tracking)


  _pyangbind_elements = OrderedDict([('egress_tracking', egress_tracking), ])


class yc_flow_openconfig_ate_flow__flows_flow(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows/flow. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A flow of packets between one or more internal and external sources
and one or more internal and external destinations that the target
is able to track and report statistics on. Each flow is identified by
an arbitrary string identifier.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__state','__ingress_tracking','__egress_tracking',)

  _yang_name = 'flow'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    self.__ingress_tracking = YANGDynClass(base=yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking, is_container='container', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    self.__egress_tracking = YANGDynClass(base=yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows', 'flow']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /flows/flow/name (leafref)

    YANG Description: Reference to the flow's name, acting as a key of the flow list.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /flows/flow/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the flow's name, acting as a key of the flow list.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /flows/flow/state (container)

    YANG Description: Operational state of the individual flow.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /flows/flow/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state of the individual flow.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_ate_flow__flows_flow_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_ate_flow__flows_flow_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)


  def _get_ingress_tracking(self):
    """
    Getter method for ingress_tracking, mapped from YANG variable /flows/flow/ingress_tracking (container)

    YANG Description: Flow statistics grouped by ingress tracking filter.
    """
    return self.__ingress_tracking
      
  def _set_ingress_tracking(self, v, load=False):
    """
    Setter method for ingress_tracking, mapped from YANG variable /flows/flow/ingress_tracking (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress_tracking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress_tracking() directly.

    YANG Description: Flow statistics grouped by ingress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking, is_container='container', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress_tracking must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking, is_container='container', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__ingress_tracking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress_tracking(self):
    self.__ingress_tracking = YANGDynClass(base=yc_ingress_tracking_openconfig_ate_flow__flows_flow_ingress_tracking, is_container='container', yang_name="ingress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)


  def _get_egress_tracking(self):
    """
    Getter method for egress_tracking, mapped from YANG variable /flows/flow/egress_tracking (container)

    YANG Description: Flow statistics grouped by egress tracking filter.
    """
    return self.__egress_tracking
      
  def _set_egress_tracking(self, v, load=False):
    """
    Setter method for egress_tracking, mapped from YANG variable /flows/flow/egress_tracking (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_tracking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_tracking() directly.

    YANG Description: Flow statistics grouped by egress tracking filter.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_tracking must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)""",
        })

    self.__egress_tracking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_tracking(self):
    self.__egress_tracking = YANGDynClass(base=yc_egress_tracking_openconfig_ate_flow__flows_flow_egress_tracking, is_container='container', yang_name="egress-tracking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  state = __builtin__.property(_get_state)
  ingress_tracking = __builtin__.property(_get_ingress_tracking)
  egress_tracking = __builtin__.property(_get_egress_tracking)


  _pyangbind_elements = OrderedDict([('name', name), ('state', state), ('ingress_tracking', ingress_tracking), ('egress_tracking', egress_tracking), ])


class yc_flows_openconfig_ate_flow__flows(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /flows. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Flow statistics collected by the network device. A flow is defined to
be an arbitrary stream of packets whose definition is outside of the
context of the module.
  """
  __slots__ = ('_path_helper', '_extmethods', '__flow',)

  _yang_name = 'flows'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__flow = YANGDynClass(base=YANGListType("name",yc_flow_openconfig_ate_flow__flows_flow, yang_name="flow", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="flow", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['flows']

  def _get_flow(self):
    """
    Getter method for flow, mapped from YANG variable /flows/flow (list)

    YANG Description: A flow of packets between one or more internal and external sources
and one or more internal and external destinations that the target
is able to track and report statistics on. Each flow is identified by
an arbitrary string identifier.
    """
    return self.__flow
      
  def _set_flow(self, v, load=False):
    """
    Setter method for flow, mapped from YANG variable /flows/flow (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flow is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flow() directly.

    YANG Description: A flow of packets between one or more internal and external sources
and one or more internal and external destinations that the target
is able to track and report statistics on. Each flow is identified by
an arbitrary string identifier.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_flow_openconfig_ate_flow__flows_flow, yang_name="flow", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="flow", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flow must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_flow_openconfig_ate_flow__flows_flow, yang_name="flow", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="flow", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=True)""",
        })

    self.__flow = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flow(self):
    self.__flow = YANGDynClass(base=YANGListType("name",yc_flow_openconfig_ate_flow__flows_flow, yang_name="flow", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="flow", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='list', is_config=True)

  flow = __builtin__.property(_get_flow, _set_flow)


  _pyangbind_elements = OrderedDict([('flow', flow), ])


class openconfig_ate_flow(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-ate-flow - based on the path /openconfig-ate-flow. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines telemetry that relates to flows that are tracked
by a network device, or automated test equipment. A flow is an arbitrary
stream of packets whose definition is outside of the context of this
module.
  """
  __slots__ = ('_path_helper', '_extmethods', '__flows',)

  _yang_name = 'openconfig-ate-flow'
  _yang_namespace = 'http://openconfig.net/yang/ate-flow'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__flows = YANGDynClass(base=yc_flows_openconfig_ate_flow__flows, is_container='container', yang_name="flows", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_flows(self):
    """
    Getter method for flows, mapped from YANG variable /flows (container)

    YANG Description: Flow statistics collected by the network device. A flow is defined to
be an arbitrary stream of packets whose definition is outside of the
context of the module.
    """
    return self.__flows
      
  def _set_flows(self, v, load=False):
    """
    Setter method for flows, mapped from YANG variable /flows (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flows is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flows() directly.

    YANG Description: Flow statistics collected by the network device. A flow is defined to
be an arbitrary stream of packets whose definition is outside of the
context of the module.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_flows_openconfig_ate_flow__flows, is_container='container', yang_name="flows", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flows must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_flows_openconfig_ate_flow__flows, is_container='container', yang_name="flows", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=True)""",
        })

    self.__flows = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flows(self):
    self.__flows = YANGDynClass(base=yc_flows_openconfig_ate_flow__flows, is_container='container', yang_name="flows", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/ate-flow', defining_module='openconfig-ate-flow', yang_type='container', is_config=True)

  flows = __builtin__.property(_get_flows, _set_flows)


  _pyangbind_elements = OrderedDict([('flows', flows), ])


