// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogramDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewHistogramDataPoint()
				CopyHistogramDataPoint(dest, src)
				assert.Equal(t, src, dest)
				CopyHistogramDataPoint(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyHistogramDataPointSlice(t *testing.T) {
	src := []HistogramDataPoint{}
	dest := []HistogramDataPoint{}
	// Test CopyTo empty
	dest = CopyHistogramDataPointSlice(dest, src)
	assert.Equal(t, []HistogramDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestHistogramDataPointSlice()
	dest = CopyHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenTestHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenTestHistogramDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyHistogramDataPointSlice(dest, []HistogramDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenTestHistogramDataPointSlice(), dest)
}

func TestCopyHistogramDataPointPtrSlice(t *testing.T) {
	src := []*HistogramDataPoint{}
	dest := []*HistogramDataPoint{}
	// Test CopyTo empty
	dest = CopyHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, []*HistogramDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestHistogramDataPointPtrSlice()
	dest = CopyHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestHistogramDataPointPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestHistogramDataPointPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyHistogramDataPointPtrSlice(dest, []*HistogramDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestHistogramDataPointPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONHistogramDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewHistogramDataPoint()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewHistogramDataPoint(), dest)
}

func TestMarshalAndUnmarshalJSONHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogramDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewHistogramDataPoint()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteHistogramDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoHistogramDataPointFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			dest := NewHistogramDataPoint()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoHistogramDataPointUnknown(t *testing.T) {
	dest := NewHistogramDataPoint()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewHistogramDataPoint(), dest)
}

func TestMarshalAndUnmarshalProtoHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogramDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewHistogramDataPoint()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteHistogramDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.HistogramDataPoint{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewHistogramDataPoint()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesHistogramDataPoint() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                     {0x02},
		"Attributes/wrong_wire_type":        {0x4c},
		"Attributes/missing_value":          {0x4a},
		"StartTimeUnixNano/wrong_wire_type": {0x14},
		"StartTimeUnixNano/missing_value":   {0x11},
		"TimeUnixNano/wrong_wire_type":      {0x1c},
		"TimeUnixNano/missing_value":        {0x19},
		"Count/wrong_wire_type":             {0x24},
		"Count/missing_value":               {0x21},
		"Sum/wrong_wire_type":               {0x2c},
		"Sum/missing_value":                 {0x29},
		"BucketCounts/wrong_wire_type":      {0x34},
		"BucketCounts/missing_value":        {0x32},
		"ExplicitBounds/wrong_wire_type":    {0x3c},
		"ExplicitBounds/missing_value":      {0x3a},
		"Exemplars/wrong_wire_type":         {0x44},
		"Exemplars/missing_value":           {0x42},
		"Flags/wrong_wire_type":             {0x54},
		"Flags/missing_value":               {0x50},
		"Min/wrong_wire_type":               {0x5c},
		"Min/missing_value":                 {0x59},
		"Max/wrong_wire_type":               {0x64},
		"Max/missing_value":                 {0x61},
	}
}

func genTestEncodingValuesHistogramDataPoint() map[string]*HistogramDataPoint {
	return map[string]*HistogramDataPoint{
		"empty":                  NewHistogramDataPoint(),
		"Attributes/test":        {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"StartTimeUnixNano/test": {StartTimeUnixNano: uint64(13)},
		"TimeUnixNano/test":      {TimeUnixNano: uint64(13)},
		"Count/test":             {Count: uint64(13)}, "Sum/default": {Sum_: &HistogramDataPoint_Sum{Sum: float64(0)}},
		"Sum/test":            {Sum_: &HistogramDataPoint_Sum{Sum: float64(3.1415926)}},
		"BucketCounts/test":   {BucketCounts: []uint64{uint64(0), uint64(13)}},
		"ExplicitBounds/test": {ExplicitBounds: []float64{float64(0), float64(3.1415926)}},
		"Exemplars/test":      {Exemplars: []Exemplar{{}, *GenTestExemplar()}},
		"Flags/test":          {Flags: uint32(13)}, "Min/default": {Min_: &HistogramDataPoint_Min{Min: float64(0)}},
		"Min/test": {Min_: &HistogramDataPoint_Min{Min: float64(3.1415926)}}, "Max/default": {Max_: &HistogramDataPoint_Max{Max: float64(0)}},
		"Max/test": {Max_: &HistogramDataPoint_Max{Max: float64(3.1415926)}},
	}
}
