// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pcommon

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestResource_MoveTo(t *testing.T) {
	ms := generateTestResource()
	dest := NewResource()
	ms.MoveTo(dest)
	assert.Equal(t, NewResource(), ms)
	assert.Equal(t, generateTestResource(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestResource(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newResource(internal.NewResource(), sharedState)) })
	assert.Panics(t, func() { newResource(internal.NewResource(), sharedState).MoveTo(dest) })
}

func TestResource_CopyTo(t *testing.T) {
	ms := NewResource()
	orig := NewResource()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestResource()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newResource(internal.NewResource(), sharedState)) })
}

func TestResource_Attributes(t *testing.T) {
	ms := NewResource()
	assert.Equal(t, NewMap(), ms.Attributes())
	ms.getOrig().Attributes = internal.GenTestKeyValueSlice()
	assert.Equal(t, Map(internal.GenTestMapWrapper()), ms.Attributes())
}

func TestResource_DroppedAttributesCount(t *testing.T) {
	ms := NewResource()
	assert.Equal(t, uint32(0), ms.DroppedAttributesCount())
	ms.SetDroppedAttributesCount(uint32(13))
	assert.Equal(t, uint32(13), ms.DroppedAttributesCount())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newResource(internal.NewResource(), sharedState).SetDroppedAttributesCount(uint32(13)) })
}

func generateTestResource() Resource {
	return newResource(internal.GenTestResource(), internal.NewState())
}
