// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySum(t *testing.T) {
	for name, src := range genTestEncodingValuesSum() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSum()
				CopySum(dest, src)
				assert.Equal(t, src, dest)
				CopySum(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySumSlice(t *testing.T) {
	src := []Sum{}
	dest := []Sum{}
	// Test CopyTo empty
	dest = CopySumSlice(dest, src)
	assert.Equal(t, []Sum{}, dest)

	// Test CopyTo larger slice
	src = GenTestSumSlice()
	dest = CopySumSlice(dest, src)
	assert.Equal(t, GenTestSumSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySumSlice(dest, src)
	assert.Equal(t, GenTestSumSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySumSlice(dest, []Sum{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySumSlice(dest, src)
	assert.Equal(t, GenTestSumSlice(), dest)
}

func TestCopySumPtrSlice(t *testing.T) {
	src := []*Sum{}
	dest := []*Sum{}
	// Test CopyTo empty
	dest = CopySumPtrSlice(dest, src)
	assert.Equal(t, []*Sum{}, dest)

	// Test CopyTo larger slice
	src = GenTestSumPtrSlice()
	dest = CopySumPtrSlice(dest, src)
	assert.Equal(t, GenTestSumPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySumPtrSlice(dest, src)
	assert.Equal(t, GenTestSumPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySumPtrSlice(dest, []*Sum{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySumPtrSlice(dest, src)
	assert.Equal(t, GenTestSumPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSumUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSum()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSum(), dest)
}

func TestMarshalAndUnmarshalJSONSum(t *testing.T) {
	for name, src := range genTestEncodingValuesSum() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSum()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSum(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSumFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSum() {
		t.Run(name, func(t *testing.T) {
			dest := NewSum()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSumUnknown(t *testing.T) {
	dest := NewSum()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSum(), dest)
}

func TestMarshalAndUnmarshalProtoSum(t *testing.T) {
	for name, src := range genTestEncodingValuesSum() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSum()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSum(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSum(t *testing.T) {
	for name, src := range genTestEncodingValuesSum() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Sum{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSum()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSum() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"DataPoints/wrong_wire_type":             {0xc},
		"DataPoints/missing_value":               {0xa},
		"AggregationTemporality/wrong_wire_type": {0x14},
		"AggregationTemporality/missing_value":   {0x10},
		"IsMonotonic/wrong_wire_type":            {0x1c},
		"IsMonotonic/missing_value":              {0x18},
	}
}

func genTestEncodingValuesSum() map[string]*Sum {
	return map[string]*Sum{
		"empty":                       NewSum(),
		"DataPoints/test":             {DataPoints: []*NumberDataPoint{{}, GenTestNumberDataPoint()}},
		"AggregationTemporality/test": {AggregationTemporality: AggregationTemporality(13)},
		"IsMonotonic/test":            {IsMonotonic: true},
	}
}
