/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfListTable
extends RtfElement
implements RtfExtendedElement {
    protected static final byte[] LIST_NUMBER = "\\ls".getBytes();
    private static final byte[] LIST_TABLE = "\\*\\listtable".getBytes();
    private static final byte[] LIST = "\\list".getBytes();
    private static final byte[] LIST_TEMPLATE_ID = "\\listtemplateid".getBytes();
    private static final byte[] LIST_HYBRID = "\\hybrid".getBytes();
    private static final byte[] LIST_ID = "\\listid".getBytes();
    private static final byte[] LIST_OVERRIDE_TABLE = "\\*\\listoverridetable".getBytes();
    private static final byte[] LIST_OVERRIDE = "\\listoverride".getBytes();
    private static final byte[] LIST_OVERRIDE_COUNT = "\\listoverridecount".getBytes();
    private ArrayList lists = new ArrayList();

    public RtfListTable(RtfDocument doc) {
        super(doc);
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int[] listIds = new int[this.lists.size()];
        try {
            int i;
            result.write(OPEN_GROUP);
            result.write(LIST_TABLE);
            result.write("\n".getBytes());
            for (i = 0; i < this.lists.size(); ++i) {
                result.write(OPEN_GROUP);
                result.write(LIST);
                result.write(LIST_TEMPLATE_ID);
                result.write(this.intToByteArray(this.document.getRandomInt()));
                result.write(LIST_HYBRID);
                result.write("\n".getBytes());
                result.write(((RtfList)this.lists.get(i)).writeDefinition());
                result.write(LIST_ID);
                listIds[i] = this.document.getRandomInt();
                result.write(this.intToByteArray(listIds[i]));
                result.write(CLOSE_GROUP);
                result.write("\n".getBytes());
            }
            result.write(CLOSE_GROUP);
            result.write("\n".getBytes());
            result.write(OPEN_GROUP);
            result.write(LIST_OVERRIDE_TABLE);
            result.write("\n".getBytes());
            for (i = 0; i < this.lists.size(); ++i) {
                result.write(OPEN_GROUP);
                result.write(LIST_OVERRIDE);
                result.write(LIST_ID);
                result.write(this.intToByteArray(listIds[i]));
                result.write(LIST_OVERRIDE_COUNT);
                result.write(this.intToByteArray(0));
                result.write(LIST_NUMBER);
                result.write(this.intToByteArray(((RtfList)this.lists.get(i)).getListNumber()));
                result.write(CLOSE_GROUP);
                result.write("\n".getBytes());
            }
            result.write(CLOSE_GROUP);
            result.write("\n".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getListNumber(RtfList list) {
        if (this.lists.contains(list)) {
            return this.lists.indexOf(list);
        }
        this.lists.add(list);
        return this.lists.size();
    }

    public void freeListNumber(RtfList list) {
        int i = this.lists.indexOf(list);
        if (i >= 0) {
            this.lists.remove(i);
        }
    }
}

