/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;

public class CacheManagerEventListenerRegistry
implements CacheManagerEventListener {
    private Status status = Status.STATUS_UNINITIALISED;
    private Set listeners = new HashSet();

    public final boolean registerListener(CacheManagerEventListener cacheManagerEventListener) {
        if (cacheManagerEventListener == null) {
            return false;
        }
        return this.listeners.add(cacheManagerEventListener);
    }

    public final boolean unregisterListener(CacheManagerEventListener cacheManagerEventListener) {
        return this.listeners.remove(cacheManagerEventListener);
    }

    public boolean hasRegisteredListeners() {
        return this.listeners.size() > 0;
    }

    public Set getRegisteredListeners() {
        return this.listeners;
    }

    public void init() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CacheManagerEventListener cacheManagerEventListener = (CacheManagerEventListener)iterator.next();
            cacheManagerEventListener.init();
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void dispose() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CacheManagerEventListener cacheManagerEventListener = (CacheManagerEventListener)iterator.next();
            cacheManagerEventListener.dispose();
        }
        this.listeners.clear();
    }

    public void notifyCacheAdded(String cacheName) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CacheManagerEventListener cacheManagerEventListener = (CacheManagerEventListener)iterator.next();
            cacheManagerEventListener.notifyCacheAdded(cacheName);
        }
    }

    public void notifyCacheRemoved(String cacheName) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CacheManagerEventListener cacheManagerEventListener = (CacheManagerEventListener)iterator.next();
            cacheManagerEventListener.notifyCacheRemoved(cacheName);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" cacheManagerEventListeners: ");
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            CacheManagerEventListener cacheManagerEventListener = (CacheManagerEventListener)iterator.next();
            stringBuffer.append(cacheManagerEventListener.getClass().getName()).append(" ");
        }
        return stringBuffer.toString();
    }
}

