/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.versioning;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.versioning.DependencyInformation;
import org.pentaho.reporting.libraries.base.versioning.VersionHelper;

public abstract class ProjectInformation
extends DependencyInformation {
    private String copyright;
    private String bootClass;
    private ArrayList libraries;
    private ArrayList optionalLibraries;
    private VersionHelper versionHelper;
    private String internalName;

    protected ProjectInformation(String name) {
        this(name, name);
    }

    protected ProjectInformation(String internalName, String publicName) {
        super(publicName);
        this.internalName = internalName == null ? publicName : internalName;
        this.libraries = new ArrayList();
        this.optionalLibraries = new ArrayList();
    }

    private synchronized VersionHelper getVersionHelper() {
        if (this.versionHelper == null) {
            this.versionHelper = new VersionHelper(this);
        }
        return this.versionHelper;
    }

    public String getCopyright() {
        return this.copyright;
    }

    protected void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getBootClass() {
        return this.bootClass;
    }

    protected void setBootClass(String bootClass) {
        this.bootClass = bootClass;
    }

    public DependencyInformation[] getLibraries() {
        return this.libraries.toArray(new DependencyInformation[this.libraries.size()]);
    }

    public void addLibrary(DependencyInformation library) {
        if (library == null) {
            throw new NullPointerException();
        }
        if (this.libraries.contains(library)) {
            throw new NullPointerException();
        }
        this.libraries.add(library);
    }

    public DependencyInformation[] getOptionalLibraries() {
        return this.optionalLibraries.toArray(new DependencyInformation[this.optionalLibraries.size()]);
    }

    protected void addOptionalLibrary(String libraryClass) {
        if (libraryClass == null) {
            throw new NullPointerException("Library classname must be given.");
        }
        DependencyInformation depInfo = this.loadLibrary(libraryClass);
        if (depInfo != null) {
            this.optionalLibraries.add(depInfo);
        }
    }

    private DependencyInformation loadLibrary(String classname) {
        if (classname == null) {
            return null;
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(this.getClass());
            Class<?> c = Class.forName(classname, false, loader);
            try {
                Method m = c.getMethod("getInstance", null);
                return (DependencyInformation)m.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                return (DependencyInformation)c.newInstance();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void addOptionalLibrary(DependencyInformation library) {
        if (library == null) {
            throw new NullPointerException("Library must be given.");
        }
        this.optionalLibraries.add(library);
    }

    public String getVersion() {
        return this.getVersionHelper().getVersion();
    }

    public String getProductId() {
        return this.getVersionHelper().getProductId();
    }

    public String getReleaseMilestone() {
        return this.getVersionHelper().getReleaseMilestone();
    }

    public String getReleaseMinor() {
        return this.getVersionHelper().getReleaseMinor();
    }

    public String getReleaseMajor() {
        return this.getVersionHelper().getReleaseMajor();
    }

    public String getReleaseCandidateToken() {
        return this.getVersionHelper().getReleaseCandidateToken();
    }

    public String getReleaseNumber() {
        return this.getVersionHelper().getReleaseNumber();
    }

    public String getReleaseBuildNumber() {
        return this.versionHelper.getReleaseBuildNumber();
    }
}

