/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.computations;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.PseudoRandomFunction;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.computations.KeyExchangeComputations;
import de.rub.nds.tlsattacker.core.util.StaticTicketCrypto;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.tls.TlsUtils;

public class PWDComputations
extends KeyExchangeComputations {
    private static final Logger LOGGER = LogManager.getLogger();
    private Point passwordElement;
    private BigInteger privateKeyScalar;

    public static Point computePasswordElement(Chooser chooser, EllipticCurve curve) throws CryptoException {
        int lsbY;
        byte[] base;
        MacAlgorithm randomFunction = PWDComputations.getMacAlgorithm(chooser.getSelectedCipherSuite());
        BigInteger prime = curve.getModulus();
        byte[] salt = chooser.getServerPWDSalt();
        if (salt == null && chooser.getSelectedProtocolVersion() != ProtocolVersion.TLS13) {
            salt = chooser.getConfig().getDefaultServerPWDSalt();
        }
        if (salt == null) {
            Digest digest = TlsUtils.createHash((short)4);
            base = new byte[digest.getDigestSize()];
            byte[] usernamePW = (chooser.getClientPWDUsername() + chooser.getPWDPassword()).getBytes();
            digest.update(usernamePW, 0, usernamePW.length);
            digest.doFinal(base, 0);
        } else {
            base = StaticTicketCrypto.generateHMAC(MacAlgorithm.HMAC_SHA256, (chooser.getClientPWDUsername() + chooser.getPWDPassword()).getBytes(), salt);
        }
        boolean found = false;
        int counter = 0;
        int n = (curve.getModulus().bitLength() + 64) / 8;
        byte[] context = chooser.getSelectedProtocolVersion().isTLS13() ? chooser.getClientRandom() : ArrayConverter.concatenate((byte[][])new byte[][]{chooser.getClientRandom(), chooser.getServerRandom()});
        Point createdPoint = null;
        byte[] savedSeed = null;
        do {
            byte[] seedInput = ArrayConverter.concatenate((byte[][])new byte[][]{base, ArrayConverter.intToBytes((int)(++counter), (int)1), ArrayConverter.bigIntegerToByteArray((BigInteger)prime)});
            byte[] seed = StaticTicketCrypto.generateHMAC(randomFunction, seedInput, new byte[4]);
            byte[] tmp = PWDComputations.prf(chooser, seed, context, n);
            BigInteger tmpX = new BigInteger(1, tmp).mod(prime.subtract(BigInteger.ONE)).add(BigInteger.ONE);
            Point tempPoint = curve.createAPointOnCurve(tmpX);
            if (!found && curve.isOnCurve(tempPoint)) {
                createdPoint = tempPoint;
                savedSeed = (byte[])seed.clone();
                found = true;
                chooser.getContext().getBadSecureRandom().nextBytes(base);
            }
            if (counter <= 1000) continue;
            savedSeed = (byte[])seed.clone();
            createdPoint = tempPoint;
            LOGGER.warn("Could not find a useful pwd point");
            break;
        } while (!found || counter < chooser.getConfig().getDefaultPWDIterations());
        int lsbSeed = savedSeed[0] & 1;
        int n2 = lsbY = createdPoint.getY().getData().getLowestSetBit() == 0 ? 1 : 0;
        if (lsbSeed == lsbY) {
            createdPoint = curve.inverse(createdPoint);
        }
        return createdPoint;
    }

    protected static MacAlgorithm getMacAlgorithm(CipherSuite suite) {
        if (suite.isSHA256()) {
            return MacAlgorithm.HMAC_SHA256;
        }
        if (suite.isSHA384()) {
            return MacAlgorithm.HMAC_SHA384;
        }
        if (suite.name().endsWith("SHA")) {
            return MacAlgorithm.HMAC_SHA1;
        }
        throw new PreparationException("Unsupported Mac Algorithm for suite " + suite.toString());
    }

    protected static byte[] prf(Chooser chooser, byte[] seed, byte[] context, int outlen) throws CryptoException {
        if (chooser.getSelectedProtocolVersion().isTLS13()) {
            HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(chooser.getSelectedCipherSuite());
            DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
            MessageDigest hashFunction = null;
            try {
                hashFunction = MessageDigest.getInstance(digestAlgo.getJavaName());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CryptoException("Could not initialize HKDF", ex);
            }
            hashFunction.update(context);
            byte[] hashValue = hashFunction.digest();
            return HKDFunction.expandLabel(hkdfAlgortihm, seed, "TLS-PWD Hunting And Pecking", hashValue, outlen);
        }
        PRFAlgorithm prf = AlgorithmResolver.getPRFAlgorithm(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
        if (prf != null) {
            return PseudoRandomFunction.compute(prf, seed, "TLS-PWD Hunting And Pecking", context, outlen);
        }
        LOGGER.warn("Could not select prf for " + (Object)((Object)chooser.getSelectedProtocolVersion()) + " and " + (Object)((Object)chooser.getSelectedCipherSuite()));
        return new byte[outlen];
    }

    public static PWDKeyMaterial generateKeyMaterial(EllipticCurve curve, Point passwordElement, Chooser chooser) {
        BigInteger mask;
        PWDKeyMaterial keyMaterial = new PWDKeyMaterial();
        if (chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            mask = new BigInteger(1, chooser.getConfig().getDefaultClientPWDMask()).mod(curve.getBasePointOrder());
            keyMaterial.privateKeyScalar = new BigInteger(1, chooser.getConfig().getDefaultClientPWDPrivate()).mod(curve.getBasePointOrder());
        } else {
            mask = new BigInteger(1, chooser.getConfig().getDefaultServerPWDMask()).mod(curve.getBasePointOrder());
            keyMaterial.privateKeyScalar = new BigInteger(1, chooser.getConfig().getDefaultServerPWDPrivate()).mod(curve.getBasePointOrder());
        }
        keyMaterial.scalar = mask.add(keyMaterial.privateKeyScalar).mod(curve.getBasePointOrder());
        keyMaterial.element = curve.inverse(curve.mult(mask, passwordElement));
        return keyMaterial;
    }

    @Override
    public void setSecretsInConfig(Config config) {
    }

    public Point getPasswordElement() {
        return this.passwordElement;
    }

    public void setPasswordElement(Point passwordElement) {
        this.passwordElement = passwordElement;
    }

    public BigInteger getPrivateKeyScalar() {
        return this.privateKeyScalar;
    }

    public void setPrivateKeyScalar(BigInteger privateKeyScalar) {
        this.privateKeyScalar = privateKeyScalar;
    }

    public static class PWDKeyMaterial {
        public BigInteger privateKeyScalar;
        public BigInteger scalar;
        public Point element;
    }
}

