/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ServerKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpServerKeyExchangeSerializer
extends ServerKeyExchangeSerializer<SrpServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SrpServerKeyExchangeMessage msg;

    public SrpServerKeyExchangeSerializer(SrpServerKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing SRPServerKeyExchangeMessage");
        this.writeModulusLength(this.msg);
        this.writeModulus(this.msg);
        this.writeGeneratorLength(this.msg);
        this.writeGenerator(this.msg);
        this.writeSaltLength(this.msg);
        this.writeSalt(this.msg);
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        if (this.isTLS12() || this.isDTLS12()) {
            this.writeSignatureAndHashAlgorithm(this.msg);
        }
        this.writeSignatureLength(this.msg);
        this.writeSignature(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeModulusLength(SrpServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getModulusLength().getValue(), 2);
        LOGGER.debug("pLength: " + msg.getModulusLength().getValue());
    }

    private void writeModulus(SrpServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getModulus().getValue());
        LOGGER.debug("P: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getModulus().getValue())));
    }

    private void writeSaltLength(SrpServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getSaltLength().getValue(), 1);
        LOGGER.debug("saltLength: " + msg.getSaltLength().getValue());
    }

    private void writeSalt(SrpServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getSalt().getValue());
        LOGGER.debug("Salt: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSalt().getValue())));
    }

    private void writeGeneratorLength(SrpServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getGeneratorLength().getValue(), 2);
        LOGGER.debug("gLength: " + msg.getGeneratorLength().getValue());
    }

    private void writeGenerator(SrpServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getGenerator().getValue());
        LOGGER.debug("G: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getGenerator().getValue())));
    }

    private void writeSerializedPublicKeyLength(SrpServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getPublicKeyLength().getValue(), 2);
        LOGGER.debug("SerializedPublicKeyLength: " + msg.getPublicKeyLength().getValue());
    }

    private void writeSerializedPublicKey(SrpServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getPublicKey().getValue());
        LOGGER.debug("SerializedPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }

    private void writeSignatureAndHashAlgorithm(SrpServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getSignatureAndHashAlgorithm().getValue());
        LOGGER.debug("SignatureAndHaslAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureAndHashAlgorithm().getValue())));
    }

    private boolean isTLS12() {
        return this.version == ProtocolVersion.TLS12;
    }

    private boolean isDTLS12() {
        return this.version == ProtocolVersion.DTLS12;
    }

    private void writeSignatureLength(SrpServerKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getSignatureLength().getValue(), 2);
        LOGGER.debug("SignatureLength: " + msg.getSignatureLength().getValue());
    }

    private void writeSignature(SrpServerKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getSignature().getValue());
        LOGGER.debug("Signature: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignature().getValue())));
    }
}

