/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.padding.vector;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.padding.vector.PaddingVector;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.record.Record;
import java.util.Objects;

public class TrippleVector
extends PaddingVector {
    private final VariableModification cleanModification;
    private final VariableModification macModification;
    private final VariableModification paddingModification;

    public TrippleVector(String name, String identifier, VariableModification cleanModification, VariableModification macModification, VariableModification paddingModification) {
        super(name, identifier);
        this.cleanModification = cleanModification;
        this.macModification = macModification;
        this.paddingModification = paddingModification;
    }

    public VariableModification getPaddingModification() {
        return this.paddingModification;
    }

    public VariableModification getCleanModification() {
        return this.cleanModification;
    }

    public VariableModification getMacModification() {
        return this.macModification;
    }

    @Override
    public Record createRecord() {
        Record r = new Record();
        r.prepareComputations();
        ModifiableByteArray byteArray = new ModifiableByteArray();
        byteArray.setModification(this.paddingModification);
        r.getComputations().setPadding(byteArray);
        byteArray = new ModifiableByteArray();
        byteArray.setModification(this.cleanModification);
        r.setCleanProtocolMessageBytes(byteArray);
        byteArray = new ModifiableByteArray();
        byteArray.setModification(this.macModification);
        r.getComputations().setMac(byteArray);
        return r;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.cleanModification);
        hash = 37 * hash + Objects.hashCode(this.macModification);
        hash = 37 * hash + Objects.hashCode(this.paddingModification);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrippleVector other = (TrippleVector)obj;
        if (!Objects.equals(this.cleanModification, other.cleanModification)) {
            return false;
        }
        if (!Objects.equals(this.macModification, other.macModification)) {
            return false;
        }
        return Objects.equals(this.paddingModification, other.paddingModification);
    }

    public String toString() {
        return "" + this.name + "{cleanModification=" + this.cleanModification + ", macModification=" + this.macModification + ", paddingModification=" + this.paddingModification + '}';
    }

    @Override
    public int getRecordLength(CipherSuite testedSuite, ProtocolVersion testedVersion, int appDataLength) {
        Record r = this.createRecord();
        int macLength = AlgorithmResolver.getMacAlgorithm(testedVersion, testedSuite).getSize();
        r.setCleanProtocolMessageBytes(new byte[appDataLength]);
        r.getComputations().setMac(new byte[macLength]);
        int paddingLength = AlgorithmResolver.getCipher(testedSuite).getBlocksize() - (((byte[])r.getCleanProtocolMessageBytes().getValue()).length + ((byte[])r.getComputations().getMac().getValue()).length) % AlgorithmResolver.getCipher(testedSuite).getBlocksize();
        r.getComputations().setPadding(new byte[paddingLength]);
        return ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])r.getCleanProtocolMessageBytes().getValue(), (byte[])r.getComputations().getMac().getValue(), (byte[])r.getComputations().getPadding().getValue()}).length;
    }
}

