/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.Pair;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class TypeAnnotation {
    public static final int CLASS_TYPE_PARAMETER = 0;
    public static final int METHOD_TYPE_PARAMETER = 1;
    public static final int SUPER_TYPE_REFERENCE = 16;
    public static final int CLASS_TYPE_PARAMETER_BOUND = 17;
    public static final int METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int FIELD = 19;
    public static final int METHOD_RETURN_TYPE = 20;
    public static final int METHOD_RECEIVER = 21;
    public static final int METHOD_PARAMETER = 22;
    public static final int THROWS_REFERENCE = 23;
    public static final int LOCAL_VARIABLE = 64;
    public static final int RESOURCE_VARIABLE = 65;
    public static final int CATCH_CLAUSE = 66;
    public static final int EXPR_INSTANCEOF = 67;
    public static final int EXPR_NEW = 68;
    public static final int EXPR_CONSTRUCTOR_REF = 69;
    public static final int EXPR_METHOD_REF = 70;
    public static final int TYPE_ARG_CAST = 71;
    public static final int TYPE_ARG_CONSTRUCTOR_CALL = 72;
    public static final int TYPE_ARG_METHOD_CALL = 73;
    public static final int TYPE_ARG_CONSTRUCTOR_REF = 74;
    public static final int TYPE_ARG_METHOD_REF = 75;
    private final int target;
    public final PathValue[] path;
    private final AnnotationExprent annotation;

    public TypeAnnotation(int target, PathValue[] path, AnnotationExprent annotation) {
        this.target = target;
        this.path = path;
        this.annotation = annotation;
    }

    public int getTargetType() {
        return this.target >> 24;
    }

    public int getIndex() {
        return this.target & 0xFFFF;
    }

    public boolean isTopLevel() {
        return this.path.length == 0;
    }

    public Queue<PathValue> asQueue() {
        return new ArrayDeque<PathValue>(Arrays.asList(this.path));
    }

    public AnnotationExprent getAnnotation() {
        return this.annotation;
    }

    private static boolean isStaticInContext(ClassesProcessor.ClassNode node, ClassesProcessor.ClassNode currentNode, ClassesProcessor.ClassNode outermostNode) {
        boolean anyStatic = false;
        while (outermostNode != null) {
            if (outermostNode.hasModifier(8)) {
                anyStatic = true;
            }
            outermostNode = outermostNode.parent;
        }
        if (anyStatic) {
            do {
                if (node != currentNode) continue;
                return true;
            } while ((currentNode = currentNode.parent) != null);
        }
        return node.hasModifier(8);
    }

    public static void appendCastTypeName(TextBuffer buffer, VarType type, List<Pair<Queue<PathValue>, AnnotationExprent>> typeAnnotations, Set<String> filter, boolean vararg, boolean flush) {
        TextBuffer appendBuffer;
        block16: {
            block17: {
                GenericType gt;
                int i;
                int idx;
                appendBuffer = new TextBuffer();
                if (type.arrayDim > 0) {
                    for (int i2 = 0; i2 < type.arrayDim; ++i2) {
                        TypeAnnotation.stepwiseWriteAnnotations(appendBuffer, true, typeAnnotations, filter, v -> v.kind() == PathKind.DEEPER_ARRAY);
                        if (i2 == type.arrayDim - 1 && vararg && flush) {
                            appendBuffer.append("...");
                            continue;
                        }
                        appendBuffer.append("[]");
                    }
                }
                if (type.type != CodeType.OBJECT) break block16;
                ClassesProcessor.ClassNode currentNode = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
                DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(type.value));
                ArrayList<String> fullClasses = new ArrayList<String>();
                String string = ExprProcessor.buildJavaClassName(type.value);
                int last$ = 0;
                while (string.substring(last$).indexOf(36) >= 0 && (idx = string.substring(last$).indexOf(36)) >= 0) {
                    fullClasses.add(string.substring(0, (last$ += idx + 1) - 1));
                }
                fullClasses.add(string);
                ClassesProcessor.ClassNode outermostNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(string.replace('.', '/'));
                int startIdx = 0;
                for (i = 1; i < fullClasses.size(); ++i) {
                    String clazz = (String)fullClasses.get(i);
                    ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(clazz.replace('.', '/'));
                    if (node == null || !TypeAnnotation.isStaticInContext(node, currentNode, outermostNode)) break;
                    ++startIdx;
                }
                i = 0;
                for (String clazz : fullClasses) {
                    String name;
                    ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(clazz.replace('.', '/'));
                    if (node != null) {
                        name = node.simpleName;
                    } else {
                        int $ = clazz.indexOf("$");
                        name = clazz.substring(clazz.lastIndexOf(".") + 1, $ > 0 ? $ : clazz.length());
                    }
                    if (i > 0) {
                        buffer.append(".");
                    }
                    if (i >= startIdx) {
                        TypeAnnotation.stepwiseWriteAnnotations(buffer, typeAnnotations, filter, v -> v.kind() == PathKind.DEEPER_NESTED);
                    }
                    buffer.appendClass(name, false, clazz);
                    ++i;
                }
                if (!(type instanceof GenericType) || (gt = (GenericType)type).getArguments().isEmpty()) break block17;
                buffer.append("<");
                for (int j = 0; j < gt.getArguments().size(); ++j) {
                    VarType arg;
                    block20: {
                        block18: {
                            GenericType genArg;
                            block19: {
                                if (j > 0) {
                                    buffer.append(", ");
                                }
                                arg = gt.getArguments().get(j);
                                int finalJ = j;
                                TypeAnnotation.stepwiseWriteAnnotations(buffer, typeAnnotations, filter, v -> v.kind() == PathKind.GENERIC_ARGUMENT && v.typeArg() == finalJ);
                                if (arg == null || arg instanceof GenericType && (genArg = (GenericType)arg).getWildcard() != 4) {
                                    TypeAnnotation.stepwiseWriteAnnotations(buffer, typeAnnotations, filter, v -> v.kind() == PathKind.ON_WILDCARD);
                                }
                                if (!(arg instanceof GenericType)) break block18;
                                genArg = (GenericType)arg;
                                if (genArg.getWildcard() != 1) break block19;
                                buffer.append("? extends ");
                                break block20;
                            }
                            if (genArg.getWildcard() != 2) break block20;
                            buffer.append("? super ");
                            break block20;
                        }
                        if (arg == null) {
                            buffer.append("?");
                            continue;
                        }
                    }
                    TypeAnnotation.appendCastTypeName(buffer, arg, typeAnnotations, filter, vararg, false);
                }
                buffer.append(">");
            }
            buffer.append(appendBuffer);
            if (flush) {
                TypeAnnotation.dumpUnwrittenAnnotations(buffer, typeAnnotations);
            }
            return;
        }
        TypeAnnotation.stepwiseWriteAnnotations(buffer, typeAnnotations, filter, v -> false);
        buffer.appendCastTypeName(ExprProcessor.getCastTypeName(type.resizeArrayDim(0)), type);
        buffer.append(appendBuffer);
        if (flush) {
            TypeAnnotation.dumpUnwrittenAnnotations(buffer, typeAnnotations);
        }
    }

    private static void stepwiseWriteAnnotations(TextBuffer buffer, List<Pair<Queue<PathValue>, AnnotationExprent>> typeAnnotations, Set<String> filter, Predicate<PathValue> canProceed) {
        TypeAnnotation.stepwiseWriteAnnotations(buffer, false, typeAnnotations, filter, canProceed);
    }

    private static void stepwiseWriteAnnotations(TextBuffer buffer, boolean extraSpace, List<Pair<Queue<PathValue>, AnnotationExprent>> typeAnnotations, Set<String> filter, Predicate<PathValue> canProceed) {
        for (Pair<Queue<PathValue>, AnnotationExprent> anno : typeAnnotations) {
            if (((Queue)anno.a).isEmpty()) {
                if (((AnnotationExprent)anno.b).didWriteAlready()) continue;
                ((AnnotationExprent)anno.b).setDidWriteAlready(true);
                TextBuffer annoJava = ((AnnotationExprent)anno.b).toJava(-1);
                if (filter.contains(annoJava.convertToStringAndAllowDataDiscard())) continue;
                if (extraSpace) {
                    buffer.append(" ");
                }
                buffer.append(annoJava);
                buffer.append(" ");
                continue;
            }
            if (!canProceed.test((PathValue)((Queue)anno.a).peek())) continue;
            ((Queue)anno.a).poll();
        }
    }

    private static void dumpUnwrittenAnnotations(TextBuffer buffer, List<Pair<Queue<PathValue>, AnnotationExprent>> typeAnnotations) {
        boolean any = false;
        for (Pair<Queue<PathValue>, AnnotationExprent> anno : typeAnnotations) {
            if (((AnnotationExprent)anno.b).didWriteAlready()) continue;
            if (any) {
                buffer.append(" ");
            } else {
                buffer.append("/* ");
                any = true;
            }
            ((AnnotationExprent)anno.b).setDidWriteAlready(true);
            buffer.append(((AnnotationExprent)anno.b).toJava(-1));
        }
        if (any) {
            buffer.append(" */");
        }
    }

    public record PathValue(PathKind kind, int typeArg) {
        public PathValue {
            if (kind != PathKind.GENERIC_ARGUMENT && typeArg != 0) {
                throw new IllegalStateException("Illegal path data");
            }
        }
    }

    public static enum PathKind {
        DEEPER_ARRAY,
        DEEPER_NESTED,
        ON_WILDCARD,
        GENERIC_ARGUMENT;

        public static final PathKind[] VALUES;

        static {
            VALUES = PathKind.values();
        }
    }
}

