//****************************************************************************
// Model: game.qm
// File:  ./mine1.cpp
//
// This code has been generated by QM tool (see state-machine.com/qm).
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This program is open source software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published
// by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
// for more details.
//****************************************************************************
//${.::mine1.cpp} ............................................................
#include "qpcpp.h"
#include "bsp.h"
#include "game.h"

Q_DEFINE_THIS_FILE

// encapsulated delcaration of the Mine1 HSM ---------------------------------
namespace GAME {


#if ((QP_VERSION < 580) || (QP_VERSION != ((QP_RELEASE^4294967295U) % 0x3E8)))
#error qpcpp version 5.8.0 or higher required
#endif

//${AOs::Mine1} ..............................................................
class Mine1 : public QP::QHsm {
private:
    uint8_t m_x;
    uint8_t m_y;
    uint8_t m_exp_ctr;

public:
    Mine1()
      : QHsm(Q_STATE_CAST(&Mine1::initial))
    {}

protected:
    static QP::QState initial(Mine1 * const me, QP::QEvt const * const e);
    static QP::QState unused(Mine1 * const me, QP::QEvt const * const e);
    static QP::QState used(Mine1 * const me, QP::QEvt const * const e);
    static QP::QState exploding(Mine1 * const me, QP::QEvt const * const e);
    static QP::QState planted(Mine1 * const me, QP::QEvt const * const e);
};

} // namespace GAME

namespace GAME {

// local objects -------------------------------------------------------------
static Mine1 l_mine1[GAME_MINES_MAX]; // a pool of type-1 mines

//............................................................................
QP::QHsm *Mine1_getInst(uint8_t id) {
    Q_REQUIRE(id < GAME_MINES_MAX);
    return &l_mine1[id];
}

// helper function to provide the ID of this mine ............................
static inline uint8_t MINE_ID(Mine1 const * const me) {
    return static_cast<uint8_t>(me - l_mine1);
}

} // namespace GAME

// Mine1 class definition ----------------------------------------------------
namespace GAME {

//${AOs::Mine1} ..............................................................

//${AOs::Mine1::SM} ..........................................................
QP::QState Mine1::initial(Mine1 * const me, QP::QEvt const * const e) {
    // ${AOs::Mine1::SM::initial}
    static bool dict_sent = false;
    if (!dict_sent) {
        dict_sent = true;

        // object dictionaries for Mine1 pool...
        QS_OBJ_DICTIONARY(&l_mine1[0]);
        QS_OBJ_DICTIONARY(&l_mine1[1]);
        QS_OBJ_DICTIONARY(&l_mine1[2]);
        QS_OBJ_DICTIONARY(&l_mine1[3]);
        QS_OBJ_DICTIONARY(&l_mine1[4]);

        // function dictionaries for Mine1 SM
        QS_FUN_DICTIONARY(&Mine1::initial);
        QS_FUN_DICTIONARY(&Mine1::unused);
        QS_FUN_DICTIONARY(&Mine1::used);
        QS_FUN_DICTIONARY(&Mine1::planted);
        QS_FUN_DICTIONARY(&Mine1::exploding);
    }
    // local signals
    QS_SIG_DICTIONARY(MINE_PLANT_SIG,    me);
    QS_SIG_DICTIONARY(MINE_DISABLED_SIG, me);
    QS_SIG_DICTIONARY(MINE_RECYCLE_SIG,  me);
    QS_SIG_DICTIONARY(SHIP_IMG_SIG,      me);
    QS_SIG_DICTIONARY(MISSILE_IMG_SIG,   me);

    (void)e; // unused parameter
    return Q_TRAN(&unused);
}
//${AOs::Mine1::SM::unused} ..................................................
QP::QState Mine1::unused(Mine1 * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${AOs::Mine1::SM::unused::MINE_PLANT}
        case MINE_PLANT_SIG: {
            me->m_x = Q_EVT_CAST(ObjectPosEvt)->x;
            me->m_y = Q_EVT_CAST(ObjectPosEvt)->y;
            status_ = Q_TRAN(&planted);
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}
//${AOs::Mine1::SM::used} ....................................................
QP::QState Mine1::used(Mine1 * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${AOs::Mine1::SM::used}
        case Q_EXIT_SIG: {
            // tell the Tunnel that this mine is becoming disabled
            MineEvt *mev = Q_NEW(MineEvt, MINE_DISABLED_SIG);
            mev->id = MINE_ID(me);
            AO_Tunnel->POST(mev, me);
            status_ = Q_HANDLED();
            break;
        }
        // ${AOs::Mine1::SM::used::MINE_RECYCLE}
        case MINE_RECYCLE_SIG: {
            status_ = Q_TRAN(&unused);
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}
//${AOs::Mine1::SM::used::exploding} .........................................
QP::QState Mine1::exploding(Mine1 * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${AOs::Mine1::SM::used::exploding}
        case Q_ENTRY_SIG: {
            me->m_exp_ctr = 0U;
            status_ = Q_HANDLED();
            break;
        }
        // ${AOs::Mine1::SM::used::exploding::TIME_TICK}
        case TIME_TICK_SIG: {
            // ${AOs::Mine1::SM::used::exploding::TIME_TICK::[stillonscreen?]}
            if ((me->m_x >= GAME_SPEED_X) && (me->m_exp_ctr < 15)) {
                ++me->m_exp_ctr;  // advance the explosion counter
                me->m_x -= GAME_SPEED_X; // move explosion by 1 step

                // tell the Game to render the current stage of Explosion
                ObjectImageEvt *oie = Q_NEW(ObjectImageEvt, EXPLOSION_SIG);
                oie->x   = me->m_x + 1U;  // x of explosion
                oie->y   = (int8_t)((int)me->m_y - 4 + 2); // y of explosion
                oie->bmp = EXPLOSION0_BMP + (me->m_exp_ctr >> 2);
                AO_Tunnel->POST(oie, me);
                status_ = Q_HANDLED();
            }
            // ${AOs::Mine1::SM::used::exploding::TIME_TICK::[else]}
            else {
                status_ = Q_TRAN(&unused);
            }
            break;
        }
        default: {
            status_ = Q_SUPER(&used);
            break;
        }
    }
    return status_;
}
//${AOs::Mine1::SM::used::planted} ...........................................
QP::QState Mine1::planted(Mine1 * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${AOs::Mine1::SM::used::planted::TIME_TICK}
        case TIME_TICK_SIG: {
            // ${AOs::Mine1::SM::used::planted::TIME_TICK::[me->m_x>=GAME_SPEED_X]}
            if (me->m_x >= GAME_SPEED_X) {
                me->m_x -= GAME_SPEED_X; // move the mine 1 step
                // tell the Tunnel to draw the Mine
                ObjectImageEvt *oie = Q_NEW(ObjectImageEvt, MINE_IMG_SIG);
                oie->x   = me->m_x;
                oie->y   = me->m_y;
                oie->bmp = MINE1_BMP;
                AO_Tunnel->POST(oie, me);
                status_ = Q_HANDLED();
            }
            // ${AOs::Mine1::SM::used::planted::TIME_TICK::[else]}
            else {
                status_ = Q_TRAN(&unused);
            }
            break;
        }
        // ${AOs::Mine1::SM::used::planted::SHIP_IMG}
        case SHIP_IMG_SIG: {
            uint8_t x   = Q_EVT_CAST(ObjectImageEvt)->x;
            uint8_t y   = Q_EVT_CAST(ObjectImageEvt)->y;
            uint8_t bmp = Q_EVT_CAST(ObjectImageEvt)->bmp;
            // ${AOs::Mine1::SM::used::planted::SHIP_IMG::[collisionwithMINE1_BMP?]}
            if (BSP_doBitmapsOverlap(MINE1_BMP, me->m_x, me->m_y, bmp, x, y)) {
                static MineEvt const mine1_hit(HIT_MINE_SIG, 1U);
                AO_Ship->POST(&mine1_hit, me);
                // go straight to 'disabled' and let the Ship do
                // the exploding
                status_ = Q_TRAN(&unused);
            }
            else {
                status_ = Q_UNHANDLED();
            }
            break;
        }
        // ${AOs::Mine1::SM::used::planted::MISSILE_IMG}
        case MISSILE_IMG_SIG: {
            uint8_t x   = Q_EVT_CAST(ObjectImageEvt)->x;
            uint8_t y   = Q_EVT_CAST(ObjectImageEvt)->y;
            uint8_t bmp = Q_EVT_CAST(ObjectImageEvt)->bmp;
            // ${AOs::Mine1::SM::used::planted::MISSILE_IMG::[collisionwithMINE1_BMP?]}
            if (BSP_doBitmapsOverlap(MINE1_BMP, me->m_x, me->m_y, bmp, x, y)) {
                static ScoreEvt const mine1_destroyed(DESTROYED_MINE_SIG, 25U);
                AO_Missile->POST(&mine1_destroyed, me);
                status_ = Q_TRAN(&exploding);
            }
            else {
                status_ = Q_UNHANDLED();
            }
            break;
        }
        default: {
            status_ = Q_SUPER(&used);
            break;
        }
    }
    return status_;
}

} // namespace GAME
