// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/fleetengine/v1/vehicle_api.proto

package fleetenginepb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VehicleService_CreateVehicle_FullMethodName           = "/maps.fleetengine.v1.VehicleService/CreateVehicle"
	VehicleService_GetVehicle_FullMethodName              = "/maps.fleetengine.v1.VehicleService/GetVehicle"
	VehicleService_DeleteVehicle_FullMethodName           = "/maps.fleetengine.v1.VehicleService/DeleteVehicle"
	VehicleService_UpdateVehicle_FullMethodName           = "/maps.fleetengine.v1.VehicleService/UpdateVehicle"
	VehicleService_UpdateVehicleAttributes_FullMethodName = "/maps.fleetengine.v1.VehicleService/UpdateVehicleAttributes"
	VehicleService_ListVehicles_FullMethodName            = "/maps.fleetengine.v1.VehicleService/ListVehicles"
	VehicleService_SearchVehicles_FullMethodName          = "/maps.fleetengine.v1.VehicleService/SearchVehicles"
)

// VehicleServiceClient is the client API for VehicleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VehicleServiceClient interface {
	// Instantiates a new vehicle associated with an on-demand rideshare or
	// deliveries provider. Each `Vehicle` must have a unique vehicle ID.
	//
	// The following `Vehicle` fields are required when creating a `Vehicle`:
	//
	// * `vehicleState`
	// * `supportedTripTypes`
	// * `maximumCapacity`
	// * `vehicleType`
	//
	// The following `Vehicle` fields are ignored when creating a `Vehicle`:
	//
	// * `name`
	// * `currentTrips`
	// * `availableCapacity`
	// * `current_route_segment`
	// * `current_route_segment_end_point`
	// * `current_route_segment_version`
	// * `current_route_segment_traffic`
	// * `route`
	// * `waypoints`
	// * `waypoints_version`
	// * `remaining_distance_meters`
	// * `remaining_time_seconds`
	// * `eta_to_next_waypoint`
	// * `navigation_status`
	//
	// All other fields are optional and used if provided.
	CreateVehicle(ctx context.Context, in *CreateVehicleRequest, opts ...grpc.CallOption) (*Vehicle, error)
	// Returns a vehicle from the Fleet Engine.
	GetVehicle(ctx context.Context, in *GetVehicleRequest, opts ...grpc.CallOption) (*Vehicle, error)
	// Deletes a Vehicle from the Fleet Engine.
	//
	// Returns FAILED_PRECONDITION if the Vehicle has active Trips.
	// assigned to it.
	DeleteVehicle(ctx context.Context, in *DeleteVehicleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Writes updated vehicle data to the Fleet Engine.
	//
	// When updating a `Vehicle`, the following fields cannot be updated since
	// they are managed by the server:
	//
	// * `currentTrips`
	// * `availableCapacity`
	// * `current_route_segment_version`
	// * `waypoints_version`
	//
	// The vehicle `name` also cannot be updated.
	//
	// If the `attributes` field is updated, **all** the vehicle's attributes are
	// replaced with the attributes provided in the request. If you want to update
	// only some attributes, see the `UpdateVehicleAttributes` method. Likewise,
	// the `waypoints` field can be updated, but must contain all the waypoints
	// currently on the vehicle, and no other waypoints.
	UpdateVehicle(ctx context.Context, in *UpdateVehicleRequest, opts ...grpc.CallOption) (*Vehicle, error)
	// Partially updates a vehicle's attributes.
	// Only the attributes mentioned in the request will be updated, other
	// attributes will NOT be altered. Note: this is different in `UpdateVehicle`,
	// where the whole `attributes` field will be replaced by the one in
	// `UpdateVehicleRequest`, attributes not in the request would be removed.
	UpdateVehicleAttributes(ctx context.Context, in *UpdateVehicleAttributesRequest, opts ...grpc.CallOption) (*UpdateVehicleAttributesResponse, error)
	// Returns a paginated list of vehicles associated with
	// a provider that match the request options.
	ListVehicles(ctx context.Context, in *ListVehiclesRequest, opts ...grpc.CallOption) (*ListVehiclesResponse, error)
	// Returns a list of vehicles that match the request options.
	SearchVehicles(ctx context.Context, in *SearchVehiclesRequest, opts ...grpc.CallOption) (*SearchVehiclesResponse, error)
}

type vehicleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVehicleServiceClient(cc grpc.ClientConnInterface) VehicleServiceClient {
	return &vehicleServiceClient{cc}
}

func (c *vehicleServiceClient) CreateVehicle(ctx context.Context, in *CreateVehicleRequest, opts ...grpc.CallOption) (*Vehicle, error) {
	out := new(Vehicle)
	err := c.cc.Invoke(ctx, VehicleService_CreateVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vehicleServiceClient) GetVehicle(ctx context.Context, in *GetVehicleRequest, opts ...grpc.CallOption) (*Vehicle, error) {
	out := new(Vehicle)
	err := c.cc.Invoke(ctx, VehicleService_GetVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vehicleServiceClient) DeleteVehicle(ctx context.Context, in *DeleteVehicleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, VehicleService_DeleteVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vehicleServiceClient) UpdateVehicle(ctx context.Context, in *UpdateVehicleRequest, opts ...grpc.CallOption) (*Vehicle, error) {
	out := new(Vehicle)
	err := c.cc.Invoke(ctx, VehicleService_UpdateVehicle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vehicleServiceClient) UpdateVehicleAttributes(ctx context.Context, in *UpdateVehicleAttributesRequest, opts ...grpc.CallOption) (*UpdateVehicleAttributesResponse, error) {
	out := new(UpdateVehicleAttributesResponse)
	err := c.cc.Invoke(ctx, VehicleService_UpdateVehicleAttributes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vehicleServiceClient) ListVehicles(ctx context.Context, in *ListVehiclesRequest, opts ...grpc.CallOption) (*ListVehiclesResponse, error) {
	out := new(ListVehiclesResponse)
	err := c.cc.Invoke(ctx, VehicleService_ListVehicles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vehicleServiceClient) SearchVehicles(ctx context.Context, in *SearchVehiclesRequest, opts ...grpc.CallOption) (*SearchVehiclesResponse, error) {
	out := new(SearchVehiclesResponse)
	err := c.cc.Invoke(ctx, VehicleService_SearchVehicles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VehicleServiceServer is the server API for VehicleService service.
// All implementations should embed UnimplementedVehicleServiceServer
// for forward compatibility
type VehicleServiceServer interface {
	// Instantiates a new vehicle associated with an on-demand rideshare or
	// deliveries provider. Each `Vehicle` must have a unique vehicle ID.
	//
	// The following `Vehicle` fields are required when creating a `Vehicle`:
	//
	// * `vehicleState`
	// * `supportedTripTypes`
	// * `maximumCapacity`
	// * `vehicleType`
	//
	// The following `Vehicle` fields are ignored when creating a `Vehicle`:
	//
	// * `name`
	// * `currentTrips`
	// * `availableCapacity`
	// * `current_route_segment`
	// * `current_route_segment_end_point`
	// * `current_route_segment_version`
	// * `current_route_segment_traffic`
	// * `route`
	// * `waypoints`
	// * `waypoints_version`
	// * `remaining_distance_meters`
	// * `remaining_time_seconds`
	// * `eta_to_next_waypoint`
	// * `navigation_status`
	//
	// All other fields are optional and used if provided.
	CreateVehicle(context.Context, *CreateVehicleRequest) (*Vehicle, error)
	// Returns a vehicle from the Fleet Engine.
	GetVehicle(context.Context, *GetVehicleRequest) (*Vehicle, error)
	// Deletes a Vehicle from the Fleet Engine.
	//
	// Returns FAILED_PRECONDITION if the Vehicle has active Trips.
	// assigned to it.
	DeleteVehicle(context.Context, *DeleteVehicleRequest) (*emptypb.Empty, error)
	// Writes updated vehicle data to the Fleet Engine.
	//
	// When updating a `Vehicle`, the following fields cannot be updated since
	// they are managed by the server:
	//
	// * `currentTrips`
	// * `availableCapacity`
	// * `current_route_segment_version`
	// * `waypoints_version`
	//
	// The vehicle `name` also cannot be updated.
	//
	// If the `attributes` field is updated, **all** the vehicle's attributes are
	// replaced with the attributes provided in the request. If you want to update
	// only some attributes, see the `UpdateVehicleAttributes` method. Likewise,
	// the `waypoints` field can be updated, but must contain all the waypoints
	// currently on the vehicle, and no other waypoints.
	UpdateVehicle(context.Context, *UpdateVehicleRequest) (*Vehicle, error)
	// Partially updates a vehicle's attributes.
	// Only the attributes mentioned in the request will be updated, other
	// attributes will NOT be altered. Note: this is different in `UpdateVehicle`,
	// where the whole `attributes` field will be replaced by the one in
	// `UpdateVehicleRequest`, attributes not in the request would be removed.
	UpdateVehicleAttributes(context.Context, *UpdateVehicleAttributesRequest) (*UpdateVehicleAttributesResponse, error)
	// Returns a paginated list of vehicles associated with
	// a provider that match the request options.
	ListVehicles(context.Context, *ListVehiclesRequest) (*ListVehiclesResponse, error)
	// Returns a list of vehicles that match the request options.
	SearchVehicles(context.Context, *SearchVehiclesRequest) (*SearchVehiclesResponse, error)
}

// UnimplementedVehicleServiceServer should be embedded to have forward compatible implementations.
type UnimplementedVehicleServiceServer struct {
}

func (UnimplementedVehicleServiceServer) CreateVehicle(context.Context, *CreateVehicleRequest) (*Vehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVehicle not implemented")
}
func (UnimplementedVehicleServiceServer) GetVehicle(context.Context, *GetVehicleRequest) (*Vehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVehicle not implemented")
}
func (UnimplementedVehicleServiceServer) DeleteVehicle(context.Context, *DeleteVehicleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVehicle not implemented")
}
func (UnimplementedVehicleServiceServer) UpdateVehicle(context.Context, *UpdateVehicleRequest) (*Vehicle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVehicle not implemented")
}
func (UnimplementedVehicleServiceServer) UpdateVehicleAttributes(context.Context, *UpdateVehicleAttributesRequest) (*UpdateVehicleAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVehicleAttributes not implemented")
}
func (UnimplementedVehicleServiceServer) ListVehicles(context.Context, *ListVehiclesRequest) (*ListVehiclesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVehicles not implemented")
}
func (UnimplementedVehicleServiceServer) SearchVehicles(context.Context, *SearchVehiclesRequest) (*SearchVehiclesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchVehicles not implemented")
}

// UnsafeVehicleServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VehicleServiceServer will
// result in compilation errors.
type UnsafeVehicleServiceServer interface {
	mustEmbedUnimplementedVehicleServiceServer()
}

func RegisterVehicleServiceServer(s grpc.ServiceRegistrar, srv VehicleServiceServer) {
	s.RegisterService(&VehicleService_ServiceDesc, srv)
}

func _VehicleService_CreateVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VehicleServiceServer).CreateVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VehicleService_CreateVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VehicleServiceServer).CreateVehicle(ctx, req.(*CreateVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VehicleService_GetVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VehicleServiceServer).GetVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VehicleService_GetVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VehicleServiceServer).GetVehicle(ctx, req.(*GetVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VehicleService_DeleteVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VehicleServiceServer).DeleteVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VehicleService_DeleteVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VehicleServiceServer).DeleteVehicle(ctx, req.(*DeleteVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VehicleService_UpdateVehicle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVehicleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VehicleServiceServer).UpdateVehicle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VehicleService_UpdateVehicle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VehicleServiceServer).UpdateVehicle(ctx, req.(*UpdateVehicleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VehicleService_UpdateVehicleAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVehicleAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VehicleServiceServer).UpdateVehicleAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VehicleService_UpdateVehicleAttributes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VehicleServiceServer).UpdateVehicleAttributes(ctx, req.(*UpdateVehicleAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VehicleService_ListVehicles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVehiclesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VehicleServiceServer).ListVehicles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VehicleService_ListVehicles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VehicleServiceServer).ListVehicles(ctx, req.(*ListVehiclesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VehicleService_SearchVehicles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVehiclesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VehicleServiceServer).SearchVehicles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VehicleService_SearchVehicles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VehicleServiceServer).SearchVehicles(ctx, req.(*SearchVehiclesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VehicleService_ServiceDesc is the grpc.ServiceDesc for VehicleService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VehicleService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "maps.fleetengine.v1.VehicleService",
	HandlerType: (*VehicleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateVehicle",
			Handler:    _VehicleService_CreateVehicle_Handler,
		},
		{
			MethodName: "GetVehicle",
			Handler:    _VehicleService_GetVehicle_Handler,
		},
		{
			MethodName: "DeleteVehicle",
			Handler:    _VehicleService_DeleteVehicle_Handler,
		},
		{
			MethodName: "UpdateVehicle",
			Handler:    _VehicleService_UpdateVehicle_Handler,
		},
		{
			MethodName: "UpdateVehicleAttributes",
			Handler:    _VehicleService_UpdateVehicleAttributes_Handler,
		},
		{
			MethodName: "ListVehicles",
			Handler:    _VehicleService_ListVehicles_Handler,
		},
		{
			MethodName: "SearchVehicles",
			Handler:    _VehicleService_SearchVehicles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/fleetengine/v1/vehicle_api.proto",
}
