// Copyright (c) 2014 The parser Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Initial yacc source generated by ebnf2y[1]
// at 2014-07-25 14:37:06.973454437 +0200 CEST
//
//  $ ebnf2y -o nquads.y -pkg parser parser.ebnf
//
// CAUTION: If this file is a Go source file (*.go), it was generated
// automatically by '$ go tool yacc' from a *.y file - DO NOT EDIT in that case!
//
//   [1]: http://modernc.org/ebnf2y

package parser // import "modernc.org/parser/nquads"

import __yyfmt__ "fmt"

import (
	"net/url"
)

type yySymType struct {
	yys       int
	glabel    *GraphLabel
	object    *Object
	pos       Pos
	predicate *Predicate
	subject   *Subject
	val       string
}

const daccent = 57346
const dot = 57347
const eol = 57348
const illegal = 57349
const iriref = 57350
const label = 57351
const langtag = 57352
const str = 57353

var yyToknames = []string{
	"daccent",
	"dot",
	"eol",
	"illegal",
	"iriref",
	"label",
	"langtag",
	"str",
}
var yyStatenames = []string{}

const yyEOFCode = 1
const yyErrCode = 2
const yyMaxDepth = 200

var yyExca = []int{
	-1, 1,
	1, -1,
	-2, 0,
}

const yyNprod = 31
const yyPrivate = 57344

var yyTokenNames []string
var yyStates []string

const yyLast = 35

var yyAct = []int{

	28, 4, 35, 30, 31, 19, 32, 10, 21, 22,
	34, 23, 14, 15, 18, 17, 33, 26, 6, 7,
	12, 29, 11, 27, 8, 3, 2, 1, 5, 9,
	13, 25, 24, 16, 20,
}
var yyPact = []int{

	10, -1000, -1000, -1000, -1000, -1, -1000, -1000, 14, 4,
	-1000, -1000, 10, 0, -1000, -1000, -1000, 13, -1000, -1000,
	-5, -1000, -1000, 6, -1000, -1000, -6, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000,
}
var yyPgo = []int{

	0, 34, 33, 32, 31, 30, 29, 28, 27, 26,
	25, 24, 22, 1, 21,
}
var yyR1 = []int{

	0, 1, 1, 1, 1, 1, 2, 3, 3, 4,
	4, 5, 5, 5, 6, 9, 10, 10, 11, 11,
	12, 12, 8, 13, 13, 13, 14, 14, 14, 7,
	7,
}
var yyR2 = []int{

	0, 1, 1, 1, 2, 2, 2, 0, 1, 2,
	1, 1, 1, 1, 1, 3, 0, 1, 0, 3,
	0, 1, 1, 4, 5, 5, 1, 1, 1, 1,
	1,
}
var yyChk = []int{

	-1000, -8, -9, -10, -13, -7, 8, 9, -11, -6,
	8, -12, 6, -5, 8, 9, -2, 11, -13, 5,
	-1, 8, 9, 11, -3, -4, 4, 10, 5, -14,
	8, 9, 11, 10, 4, 8,
}
var yyDef = []int{

	16, -2, 22, 18, 17, 0, 29, 30, 20, 0,
	14, 15, 21, 0, 11, 12, 13, 7, 19, 23,
	0, 1, 2, 3, 6, 8, 0, 10, 24, 25,
	26, 27, 28, 4, 5, 9,
}
var yyTok1 = []int{

	1,
}
var yyTok2 = []int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
}
var yyTok3 = []int{
	0,
}

/*	parser for yacc output	*/

var yyDebug = 0

type yyLexer interface {
	Lex(lval *yySymType) int
	Error(s string)
}

const yyFlag = -1000

func yyTokname(c int) string {
	// 4 is TOKSTART above
	if c >= 4 && c-4 < len(yyToknames) {
		if yyToknames[c-4] != "" {
			return yyToknames[c-4]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yyStatname(s int) string {
	if s >= 0 && s < len(yyStatenames) {
		if yyStatenames[s] != "" {
			return yyStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yylex1(lex yyLexer, lval *yySymType) int {
	c := 0
	char := lex.Lex(lval)
	if char <= 0 {
		c = yyTok1[0]
		goto out
	}
	if char < len(yyTok1) {
		c = yyTok1[char]
		goto out
	}
	if char >= yyPrivate {
		if char < yyPrivate+len(yyTok2) {
			c = yyTok2[char-yyPrivate]
			goto out
		}
	}
	for i := 0; i < len(yyTok3); i += 2 {
		c = yyTok3[i+0]
		if c == char {
			c = yyTok3[i+1]
			goto out
		}
	}

out:
	if c == 0 {
		c = yyTok2[1] /* unknown char */
	}
	if yyDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yyTokname(c), uint(char))
	}
	return c
}

func yyParse(yylex yyLexer) int {
	var yyn int
	var yylval yySymType
	var yyVAL yySymType
	yyS := make([]yySymType, yyMaxDepth)

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yystate := 0
	yychar := -1
	yyp := -1
	goto yystack

ret0:
	return 0

ret1:
	return 1

yystack:
	/* put a state and value onto the stack */
	if yyDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yyTokname(yychar), yyStatname(yystate))
	}

	yyp++
	if yyp >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyS[yyp] = yyVAL
	yyS[yyp].yys = yystate

yynewstate:
	yyn = yyPact[yystate]
	if yyn <= yyFlag {
		goto yydefault /* simple state */
	}
	if yychar < 0 {
		yychar = yylex1(yylex, &yylval)
	}
	yyn += yychar
	if yyn < 0 || yyn >= yyLast {
		goto yydefault
	}
	yyn = yyAct[yyn]
	if yyChk[yyn] == yychar { /* valid shift */
		yychar = -1
		yyVAL = yylval
		yystate = yyn
		if Errflag > 0 {
			Errflag--
		}
		goto yystack
	}

yydefault:
	/* default state action */
	yyn = yyDef[yystate]
	if yyn == -2 {
		if yychar < 0 {
			yychar = yylex1(yylex, &yylval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yyExca[xi+0] == -1 && yyExca[xi+1] == yystate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yyn = yyExca[xi+0]
			if yyn < 0 || yyn == yychar {
				break
			}
		}
		yyn = yyExca[xi+1]
		if yyn < 0 {
			goto ret0
		}
	}
	if yyn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yylex.Error("syntax error")
			Nerrs++
			if yyDebug >= 1 {
				__yyfmt__.Printf("%s", yyStatname(yystate))
				__yyfmt__.Printf(" saw %s\n", yyTokname(yychar))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yyp >= 0 {
				yyn = yyPact[yyS[yyp].yys] + yyErrCode
				if yyn >= 0 && yyn < yyLast {
					yystate = yyAct[yyn] /* simulate a shift of "error" */
					if yyChk[yystate] == yyErrCode {
						goto yystack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yyDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yyS[yyp].yys)
				}
				yyp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yyDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yyTokname(yychar))
			}
			if yychar == yyEOFCode {
				goto ret1
			}
			yychar = -1
			goto yynewstate /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if yyDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yyn, yyStatname(yystate))
	}

	yynt := yyn
	yypt := yyp
	_ = yypt // guard against "declared and not used"

	yyp -= yyR2[yyn]
	yyVAL = yyS[yyp+1]

	/* consult goto table to find next state */
	yyn = yyR1[yyn]
	yyg := yyPgo[yyn]
	yyj := yyg + yyS[yyp].yys + 1

	if yyj >= yyLast {
		yystate = yyAct[yyg]
	} else {
		yystate = yyAct[yyj]
		if yyChk[yystate] != -yyn {
			yystate = yyAct[yyg]
		}
	}
	// dummy call; replaced with literal code
	switch yynt {

	case 1:

		{
			yyVAL.glabel = &GraphLabel{yyS[yypt-0].pos, IRIRef, yyS[yypt-0].val}
			u, err := url.Parse(yyS[yypt-0].val)
			if err != nil {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, err.Error())
				break
			}

			if !u.IsAbs() {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, "graph name URI must be absolute")
			}
		}
	case 2:

		{
			yyVAL.glabel = &GraphLabel{yyS[yypt-0].pos, BlankNodeLabel, yyS[yypt-0].val}
		}
	case 3:

		{
			yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, "graph name may not be a simple literal")
			return 1
		}
	case 4:

		{
			yylex.(*lexer).error(yyS[yypt-1].pos.Line, yyS[yypt-1].pos.Col, "graph name may not be a language tagged literal")
			return 1
		}
	case 5:

		{
			yylex.(*lexer).error(yyS[yypt-1].pos.Line, yyS[yypt-1].pos.Col, "graph name may not be a datatyped literal")
			return 1
		}
	case 6:

		{
			switch {
			case yyS[yypt-0].object == nil:
				yyVAL.object = &Object{Pos: yyS[yypt-1].pos, Tag: Literal, Value: yyS[yypt-1].val}
			default:
				x := yyS[yypt-0].object
				x.Pos, x.Tag, x.Value = yyS[yypt-1].pos, Literal, yyS[yypt-1].val
				yyVAL.object = x
			}
		}
	case 7:

		{
			yyVAL.object = nil
		}
	case 8:
		yyVAL.object = yyS[yypt-0].object
	case 9:

		{
			yyVAL.object = &Object{Pos: yyS[yypt-0].pos, Tag2: IRIRef, Value2: yyS[yypt-0].val}
			u, err := url.Parse(yyS[yypt-0].val)
			if err != nil {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, err.Error())
				break
			}

			if !u.IsAbs() {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, "bad IRI : relative IRI not allowed in datatype")
			}
		}
	case 10:

		{
			yyVAL.object = &Object{Pos: yyS[yypt-0].pos, Tag2: LangTag, Value2: yyS[yypt-0].val}
		}
	case 11:

		{
			yyVAL.object = &Object{Pos: yyS[yypt-0].pos, Tag: IRIRef, Value: yyS[yypt-0].val}
			u, err := url.Parse(yyS[yypt-0].val)
			if err != nil {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, err.Error())
				break
			}

			if !u.IsAbs() {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, "bad IRI : relative IRI not allowed in object")
			}
		}
	case 12:

		{
			yyVAL.object = &Object{Pos: yyS[yypt-0].pos, Tag: BlankNodeLabel, Value: yyS[yypt-0].val}
		}
	case 13:
		yyVAL.object = yyS[yypt-0].object
	case 14:

		{
			yyVAL.predicate = &Predicate{yyS[yypt-0].pos, yyS[yypt-0].val}
			u, err := url.Parse(yyS[yypt-0].val)
			if err != nil {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, err.Error())
				break
			}

			if !u.IsAbs() {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, "bad IRI : relative IRI not allowed in predicate")
			}
		}
	case 23:

		{
			lx := yylex.(*lexer)
			lx.ast = append(lx.ast, &Statement{yyS[yypt-3].subject.Pos, yyS[yypt-3].subject, yyS[yypt-2].predicate, yyS[yypt-1].object, nil})
		}
	case 24:

		{
			lx := yylex.(*lexer)
			lx.ast = append(lx.ast, &Statement{yyS[yypt-4].subject.Pos, yyS[yypt-4].subject, yyS[yypt-3].predicate, yyS[yypt-2].object, yyS[yypt-1].glabel})
		}
	case 25:

		{
			yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, "n-quads does not have a fifth element")
			return 1
		}
	case 29:

		{
			yyVAL.subject = &Subject{yyS[yypt-0].pos, IRIRef, yyS[yypt-0].val}
			u, err := url.Parse(yyS[yypt-0].val)
			if err != nil {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, err.Error())
				break
			}

			if !u.IsAbs() {
				yylex.(*lexer).error(yyS[yypt-0].pos.Line, yyS[yypt-0].pos.Col, "bad IRI : relative IRI not allowed in subject")
			}
		}
	case 30:

		{
			yyVAL.subject = &Subject{yyS[yypt-0].pos, BlankNodeLabel, yyS[yypt-0].val}
		}
	}
	goto yystack /* stack new state and value */
}
